/*
 * Decompiled with CFR 0.152.
 */
package com.github.eclipsecolortheme.preferences;

import com.github.eclipsecolortheme.Activator;
import com.github.eclipsecolortheme.ColorTheme;
import com.github.eclipsecolortheme.ColorThemeManager;
import java.io.BufferedInputStream;
import java.io.CharConversionException;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class ColorThemePreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private ColorThemeManager colorThemeManager = new ColorThemeManager();
    private Composite container;
    private List themeSelectionList;
    private Composite themeSelection;
    private Composite themeDetails;
    private Label authorLabel;
    private Link websiteLink;
    private Browser browser;
    private Button forceDefaultBG;

    public ColorThemePreferencePage() {
        this.setPreferenceStore(Activator.getDefault().getPreferenceStore());
    }

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite parent) {
        this.container = new Composite(parent, 0);
        GridData gridData = new GridData();
        GridLayout containerLayout = new GridLayout(1, true);
        containerLayout.marginWidth = 0;
        this.container.setLayout((Layout)containerLayout);
        gridData = new GridData(1808);
        this.themeSelection = new Composite(this.container, 0);
        GridLayout themeSelectionLayout = new GridLayout(2, false);
        themeSelectionLayout.marginWidth = 0;
        themeSelectionLayout.marginHeight = 0;
        this.themeSelection.setLayout((Layout)themeSelectionLayout);
        this.themeSelection.setLayoutData((Object)gridData);
        gridData = new GridData(1040);
        gridData.minimumWidth = 120;
        this.themeSelectionList = new List(this.themeSelection, 2560);
        this.themeSelectionList.setLayoutData((Object)gridData);
        this.fillThemeSelectionList();
        gridData = new GridData(1808);
        gridData.widthHint = 400;
        gridData.verticalAlignment = 128;
        GridLayout themeDetailsLayout = new GridLayout(1, true);
        themeDetailsLayout.marginWidth = 0;
        themeDetailsLayout.marginHeight = 0;
        this.themeDetails = new Composite(this.themeSelection, 0);
        this.themeDetails.setLayoutData((Object)gridData);
        this.themeDetails.setLayout((Layout)themeDetailsLayout);
        gridData = new GridData(1808);
        gridData.heightHint = 306;
        Browser browser = this.getBrowser();
        if (browser != null) {
            browser.setLayoutData((Object)gridData);
            browser.setText("<html><body></body></html>");
        }
        this.authorLabel = new Label(this.themeDetails, 0);
        GridDataFactory.swtDefaults().grab(true, false).applyTo((Control)this.authorLabel);
        this.websiteLink = new Link(this.themeDetails, 0);
        GridDataFactory.swtDefaults().grab(true, false).applyTo((Control)this.websiteLink);
        this.themeSelectionList.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                ColorThemePreferencePage.this.updateDetails(ColorThemePreferencePage.this.colorThemeManager.getTheme(ColorThemePreferencePage.this.themeSelectionList.getSelection()[0]));
            }
        });
        String activeThemeName = this.getPreferenceStore().getString("colorTheme");
        if (this.colorThemeManager.getTheme(activeThemeName) == null) {
            activeThemeName = "Default";
        }
        this.themeSelectionList.setSelection(new String[]{activeThemeName});
        this.updateDetails(this.colorThemeManager.getTheme(activeThemeName));
        Link ectLink = new Link(this.container, 0);
        ectLink.setText("Download more themes or create your own on <a>eclipsecolorthemes.org</a>.");
        ColorThemePreferencePage.setLinkTarget(ectLink, "http://eclipsecolorthemes.org");
        this.forceDefaultBG = new Button(this.container, 32);
        this.forceDefaultBG.setText("Set all background colors to the default");
        this.forceDefaultBG.setSelection(this.getPreferenceStore().getBoolean("forceDefaultBG"));
        this.forceDefaultBG.setToolTipText("Forces the background color of all color styles to be 'background' color of the theme");
        return this.container;
    }

    private Browser getBrowser() {
        if (this.browser != null) {
            return this.browser;
        }
        try {
            this.browser = new Browser(this.themeDetails, 2064);
        }
        catch (SWTError e) {
            try {
                this.browser = new Browser(this.themeDetails, 67584);
            }
            catch (SWTError e1) {
                e.printStackTrace();
                e1.printStackTrace();
            }
        }
        return this.browser;
    }

    private void fillThemeSelectionList() {
        Set<ColorTheme> themes = this.colorThemeManager.getThemes();
        LinkedList<String> themeNames = new LinkedList<String>();
        for (ColorTheme theme : themes) {
            themeNames.add(theme.getName());
        }
        Collections.sort(themeNames, String.CASE_INSENSITIVE_ORDER);
        themeNames.add(0, "Default");
        this.themeSelectionList.setItems(themeNames.toArray(new String[themeNames.size()]));
    }

    private static void setLinkTarget(Link link, final String target) {
        link.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                Program.launch((String)target);
            }
        });
    }

    private void updateDetails(ColorTheme theme) {
        if (theme == null) {
            this.themeDetails.setVisible(false);
        } else {
            this.authorLabel.setText("Created by " + theme.getAuthor());
            String website = theme.getWebsite();
            if (website == null || website.length() == 0) {
                this.websiteLink.setVisible(false);
            } else {
                this.websiteLink.setText("<a>" + website + "</a>");
                Listener[] listenerArray = this.websiteLink.getListeners(13);
                int n = listenerArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Listener listener = listenerArray[n2];
                    this.websiteLink.removeListener(13, listener);
                    ++n2;
                }
                ColorThemePreferencePage.setLinkTarget(this.websiteLink, website);
                this.websiteLink.setVisible(true);
            }
            String id = theme.getId();
            Browser browser = this.getBrowser();
            if (browser != null) {
                browser.setUrl("http://www.eclipsecolorthemes.org/static/themes/java/" + id + ".html");
            }
            this.themeDetails.setVisible(true);
            this.authorLabel.pack();
            this.websiteLink.pack();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean performOk() {
        IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        try {
            HashMap<IEditorInput, String> editorsToReopen;
            block8: {
                ArrayList<IEditorReference> editorsToClose = new ArrayList<IEditorReference>();
                editorsToReopen = new HashMap<IEditorInput, String>();
                IEditorReference[] iEditorReferenceArray = activePage.getEditorReferences();
                int n = iEditorReferenceArray.length;
                int n2 = 0;
                while (true) {
                    if (n2 >= n) {
                        if (!editorsToClose.isEmpty()) {
                            if (MessageDialog.openConfirm((Shell)this.getShell(), (String)"Reopen Editors", (String)"In order to change the color theme, some editors have to be closed and reopened.")) break;
                            return false;
                        }
                        break block8;
                    }
                    IEditorReference editor = iEditorReferenceArray[n2];
                    String id = editor.getId();
                    if (!id.equals("org.eclipse.cdt.ui.editor.CEditor")) {
                        editorsToClose.add(editor);
                        editorsToReopen.put(editor.getEditorInput(), id);
                    }
                    ++n2;
                }
                activePage.closeEditors(editorsToClose.toArray(new IEditorReference[editorsToClose.size()]), true);
            }
            if (this.themeSelectionList.getSelectionCount() <= 0) return super.performOk();
            String selectedThemeName = this.themeSelectionList.getSelection()[0];
            this.getPreferenceStore().setValue("colorTheme", selectedThemeName);
            this.getPreferenceStore().setValue("forceDefaultBG", this.forceDefaultBG.getSelection());
            this.colorThemeManager.applyTheme(selectedThemeName);
            Iterator iterator = editorsToReopen.keySet().iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    return super.performOk();
                }
                IEditorInput editorInput = (IEditorInput)iterator.next();
                activePage.openEditor(editorInput, (String)editorsToReopen.get(editorInput));
            }
        }
        catch (PartInitException e) {
            e.printStackTrace();
        }
        return super.performOk();
    }

    protected void performDefaults() {
        this.getPreferenceStore().setToDefault("colorTheme");
        this.colorThemeManager.clearImportedThemes();
        this.reloadThemeSelectionList();
        this.getPreferenceStore().setToDefault("forceDefaultBG");
        super.performDefaults();
    }

    protected void contributeButtons(Composite parent) {
        ++((GridLayout)parent.getLayout()).numColumns;
        Button button = new Button(parent, 0);
        button.setText("&Import a theme...");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                FileDialog dialog = new FileDialog(ColorThemePreferencePage.this.getShell());
                String file = dialog.open();
                BufferedInputStream bufferedFileStream = null;
                try {
                    try {
                        bufferedFileStream = new BufferedInputStream(new FileInputStream(file));
                        ColorThemePreferencePage.this.colorThemeManager.saveTheme(bufferedFileStream);
                    }
                    catch (CharConversionException charConversionException) {
                        ColorThemePreferencePage.this.showErrorMessage("Invalid file encoding.");
                        try {
                            if (bufferedFileStream != null) {
                                bufferedFileStream.close();
                            }
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        return;
                    }
                    catch (Exception exception) {
                        ColorThemePreferencePage.this.showErrorMessage("This is not a valid theme file.");
                        try {
                            if (bufferedFileStream != null) {
                                bufferedFileStream.close();
                            }
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        return;
                    }
                }
                finally {
                    try {
                        if (bufferedFileStream != null) {
                            bufferedFileStream.close();
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                ColorThemePreferencePage.this.reloadThemeSelectionList();
            }
        });
    }

    protected void showErrorMessage(String message) {
        MessageBox box = new MessageBox(this.getShell(), 32);
        box.setText("Theme not imported");
        box.setMessage(message);
        box.open();
    }

    private void reloadThemeSelectionList() {
        this.themeSelectionList.removeAll();
        this.fillThemeSelectionList();
        this.themeSelectionList.setSelection(new String[]{"Default"});
        this.updateDetails(null);
        this.container.pack();
    }
}

