/*
 * Decompiled with CFR 0.152.
 */
package cucumber.eclipse.editor.builder;

import cucumber.eclipse.editor.steps.BuildStorage;
import cucumber.eclipse.editor.steps.GlueRepository;
import cucumber.eclipse.editor.steps.GlueStorage;
import cucumber.eclipse.editor.steps.StepDefinitionsRepository;
import cucumber.eclipse.editor.steps.StepDefinitionsStorage;
import cucumber.eclipse.editor.steps.UniversalStepDefinitionsProvider;
import cucumber.eclipse.editor.util.FileUtil;
import cucumber.eclipse.steps.integration.GherkinStepWrapper;
import cucumber.eclipse.steps.integration.Glue;
import cucumber.eclipse.steps.integration.StepDefinition;
import cucumber.eclipse.steps.integration.StepPreferences;
import cucumber.eclipse.steps.integration.filter.Filter;
import cucumber.eclipse.steps.integration.filter.FilterUtil;
import cucumber.eclipse.steps.integration.filter.SameLocationFilter;
import cucumber.eclipse.steps.integration.marker.MarkerFactory;
import gherkin.formatter.Formatter;
import gherkin.formatter.model.Background;
import gherkin.formatter.model.Examples;
import gherkin.formatter.model.ExamplesTableRow;
import gherkin.formatter.model.Feature;
import gherkin.formatter.model.Scenario;
import gherkin.formatter.model.ScenarioOutline;
import gherkin.formatter.model.Step;
import gherkin.lexer.LexingError;
import gherkin.parser.Parser;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;

public class CucumberGherkinBuilder
extends IncrementalProjectBuilder {
    public static final String ID = "cucumber.eclipse.builder.gherkin";
    private MarkerFactory markerFactory = MarkerFactory.INSTANCE;
    private final UniversalStepDefinitionsProvider stepDefinitionsProvider = UniversalStepDefinitionsProvider.INSTANCE;
    private final BuildStorage<GlueRepository> glueStorage = GlueStorage.INSTANCE;
    private volatile boolean fullBuildRequired = false;
    private final Set<IResource> resources = new HashSet<IResource>();

    protected IProject[] build(int kind, Map<String, String> args, IProgressMonitor monitor) throws CoreException {
        boolean glueDetectionEnabled = StepPreferences.INSTANCE.isStepDefinitionsMatchingEnabled();
        switch (kind) {
            case 6: {
                System.out.println("gherkin full build");
                this.fullBuild(glueDetectionEnabled, monitor);
                break;
            }
            case 9: 
            case 10: {
                IResourceDelta delta = this.getDelta(this.getProject());
                System.out.println("> gherkin incremental build on " + delta.getResource().getName());
                this.incrementalBuild(delta, glueDetectionEnabled, monitor);
                break;
            }
            case 15: {
                System.out.println("> gherkin clean build");
                break;
            }
        }
        return null;
    }

    private void incrementalBuild(IResourceDelta delta, boolean glueDetectionEnabled, IProgressMonitor monitor) throws CoreException {
        try {
            this.fullBuildRequired = false;
            delta.accept((IResourceDeltaVisitor)new CucumberGherkinBuildCheckVisitor(glueDetectionEnabled));
            boolean featuresHasChanged = false;
            if (this.fullBuildRequired) {
                System.out.println(">gherkin builder: force full build");
                this.fullBuild(glueDetectionEnabled, monitor);
                featuresHasChanged = true;
            } else {
                CucumberGherkinBuildVisitor visitorBuilder = new CucumberGherkinBuildVisitor(this.markerFactory, this.resources, glueDetectionEnabled, monitor);
                delta.accept((IResourceDeltaVisitor)visitorBuilder);
                featuresHasChanged = !this.resources.isEmpty();
                this.build(visitorBuilder, glueDetectionEnabled, monitor);
            }
            if (featuresHasChanged) {
                this.glueStorage.persist(this.getProject(), monitor);
            }
        }
        catch (CoreException e) {
            throw new CoreException((IStatus)new Status(4, "cucumber.eclipse.steps.integration", e.getMessage(), (Throwable)e));
        }
    }

    private void fullBuild(boolean glueDetectionEnabled, IProgressMonitor monitor) throws CoreException {
        try {
            CucumberGherkinBuildVisitor visitorBuilder = new CucumberGherkinBuildVisitor(this.markerFactory, this.resources, glueDetectionEnabled, monitor);
            this.getProject().accept((IResourceVisitor)visitorBuilder);
            this.build(visitorBuilder, glueDetectionEnabled, monitor);
            this.glueStorage.persist(this.getProject(), monitor);
        }
        catch (CoreException e) {
            throw new CoreException((IStatus)new Status(4, "cucumber.eclipse.steps.integration", e.getMessage(), (Throwable)e));
        }
    }

    private void build(CucumberGherkinBuildVisitor visitorBuilder, boolean glueDetectionEnabled, IProgressMonitor monitor) throws CoreException {
        ArrayList<StepDefinition> allStepDefinitions = new ArrayList<StepDefinition>();
        allStepDefinitions.addAll(this.stepDefinitionsProvider.getStepDefinitions(this.getProject()));
        Iterator<IResource> iterator = this.resources.iterator();
        while (iterator.hasNext()) {
            IResource resource = iterator.next();
            if (monitor.isCanceled() || this.isInterrupted()) {
                monitor.setCanceled(true);
                return;
            }
            if (!resource.exists()) {
                iterator.remove();
                continue;
            }
            visitorBuilder.buildGherkin(resource, allStepDefinitions, glueDetectionEnabled);
            iterator.remove();
        }
        monitor.done();
    }

    protected void clean(IProgressMonitor monitor) throws CoreException {
        System.out.println("CucumberGherkinBuilder.clean");
        this.getProject().accept((IResourceVisitor)new CucumberGherkinCleanBuildVisitor(this.markerFactory, monitor));
    }

    class CucumberGherkinBuildCheckVisitor
    implements IResourceDeltaVisitor {
        private boolean glueDetectionEnabled;

        public CucumberGherkinBuildCheckVisitor(boolean glueDetectionEnabled) {
            this.glueDetectionEnabled = glueDetectionEnabled;
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            boolean isGherkinFile;
            boolean contentChanged;
            IResource resource = delta.getResource();
            if (!resource.exists()) {
                return false;
            }
            if (!(resource instanceof IFile)) {
                if (resource instanceof IProject) {
                    boolean projectConfigurationChanged;
                    boolean bl = projectConfigurationChanged = (delta.getFlags() & 0x80000) != 0;
                    if (projectConfigurationChanged) {
                        CucumberGherkinBuilder.this.fullBuildRequired = true;
                    }
                }
                return true;
            }
            int flags = delta.getFlags();
            boolean bl = contentChanged = (flags & 0x100) != 0;
            if (!contentChanged) {
                return true;
            }
            if (resource.getFullPath().toString().contains("test-classes")) {
                return false;
            }
            IFile file = (IFile)resource;
            String fileExtension = file.getFileExtension();
            boolean bl2 = isGherkinFile = "feature".equals(fileExtension) || "story".equals(fileExtension);
            if (!isGherkinFile) {
                if (!this.glueDetectionEnabled) {
                    return true;
                }
                StepDefinitionsRepository stepDefinitionsRepository = StepDefinitionsStorage.INSTANCE.getOrCreate(CucumberGherkinBuilder.this.getProject(), null);
                boolean isStepDefinitionsResource = stepDefinitionsRepository.isStepDefinitionsResource(resource);
                if (isStepDefinitionsResource && CucumberGherkinBuilder.this.stepDefinitionsProvider.support((IResource)file)) {
                    CucumberGherkinBuilder.this.fullBuildRequired = true;
                }
            }
            return true;
        }
    }

    class CucumberGherkinBuildVisitor
    implements IResourceVisitor,
    IResourceDeltaVisitor {
        private IProgressMonitor monitor;
        private MarkerFactory markerFactory;
        private Set<IResource> gherkinsToBuild;
        private boolean glueDetectionEnabled;

        public CucumberGherkinBuildVisitor(MarkerFactory markerFactory, Set<IResource> gherkinsToBuild, boolean glueDetectionEnabled, IProgressMonitor monitor) {
            this.monitor = monitor;
            this.markerFactory = markerFactory;
            this.gherkinsToBuild = gherkinsToBuild;
            this.glueDetectionEnabled = glueDetectionEnabled;
        }

        public boolean visit(IResource resource) throws CoreException {
            return this.collectFeature(resource, false, this.glueDetectionEnabled);
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            IResource resource = delta.getResource();
            return this.collectFeature(resource, true, this.glueDetectionEnabled);
        }

        protected boolean collectFeature(IResource resource, boolean isIncrementalBuild, boolean glueDetectionEnabled) throws CoreException {
            boolean isGherkinFile;
            if (this.monitor.isCanceled()) {
                return false;
            }
            if (!resource.exists()) {
                return false;
            }
            if (!(resource instanceof IFile)) {
                return true;
            }
            if (resource.getFullPath().toString().contains("test-classes")) {
                return false;
            }
            IFile file = (IFile)resource;
            String fileExtension = file.getFileExtension();
            boolean bl = isGherkinFile = "feature".equals(fileExtension) || "story".equals(fileExtension);
            if (isGherkinFile) {
                this.gherkinsToBuild.add(resource);
            }
            return true;
        }

        protected void buildGherkin(IResource resource, List<StepDefinition> allStepDefinitions, boolean glueDetectionEnabled) throws CoreException {
            IFile file = (IFile)resource;
            long start = System.currentTimeMillis();
            GlueRepository glueRepository = (GlueRepository)CucumberGherkinBuilder.this.glueStorage.getOrCreate(resource.getProject(), null);
            glueRepository.clean(resource);
            this.markerFactory.cleanMarkers(resource);
            try {
                String gherkinSource = FileUtil.read(file);
                MarkerFormatter formatter = new MarkerFormatter((IDocument)new Document(gherkinSource), resource, this.markerFactory, glueDetectionEnabled);
                Parser gherkinParser = new Parser((Formatter)formatter, false);
                gherkinParser.parse(gherkinSource, file.getFullPath().toString(), Integer.valueOf(0));
            }
            catch (LexingError e) {
                String error;
                String firstLine = e.getMessage().split("\\R", 2)[0];
                Pattern pattern = Pattern.compile("Lexing error on line (\\d+): '(.*)");
                Matcher matcher = pattern.matcher(firstLine);
                int lineNumber = 0;
                if (matcher.matches()) {
                    lineNumber = Integer.valueOf(matcher.group(1));
                    error = matcher.group(2);
                } else {
                    lineNumber = 0;
                    error = e.getMessage();
                }
                RuntimeException runtimeException = new RuntimeException("Syntax error: " + error);
                this.markerFactory.syntaxErrorOnGherkin(resource, (Exception)runtimeException, lineNumber);
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new CoreException((IStatus)new Status(4, "cucumber.eclipse.steps.integration", e.getMessage()));
            }
            long end = System.currentTimeMillis();
            System.out.println("Gherkin Compile " + resource.getName() + " in " + (end - start) + " ms.");
        }
    }

    class CucumberGherkinCleanBuildVisitor
    implements IResourceVisitor {
        private IProgressMonitor monitor;
        private MarkerFactory markerFactory;

        public CucumberGherkinCleanBuildVisitor(MarkerFactory markerFactory, IProgressMonitor monitor) {
            this.monitor = monitor;
            this.markerFactory = markerFactory;
        }

        public boolean visit(IResource resource) throws CoreException {
            if (this.monitor.isCanceled()) {
                return false;
            }
            this.markerFactory.cleanMarkers(resource);
            GlueRepository glueRepository = (GlueRepository)CucumberGherkinBuilder.this.glueStorage.getOrCreate(CucumberGherkinBuilder.this.getProject(), null);
            glueRepository.clean(resource);
            return true;
        }
    }

    protected class MarkerFormatter
    implements Formatter {
        private IResource gherkinFile;
        private IDocument gherkinDocument;
        private IProject project;
        private MarkerFactory markerFactory;
        private boolean inScenarioOutline = false;
        private List<Step> scenarioOutlineSteps;
        private boolean isGlueDetectionEnabled;
        private GlueRepository glueRepository;
        private StepPreferences stepPreferences = StepPreferences.INSTANCE;

        public MarkerFormatter(IDocument document, IResource gherkinFile, MarkerFactory markerFactory, boolean isGlueDetectionEnabled) throws CoreException {
            this.gherkinFile = gherkinFile;
            this.project = gherkinFile.getProject();
            this.gherkinDocument = document;
            this.markerFactory = markerFactory;
            this.isGlueDetectionEnabled = isGlueDetectionEnabled;
            this.glueRepository = (GlueRepository)CucumberGherkinBuilder.this.glueStorage.getOrCreate(this.project, null);
        }

        public void syntaxError(String state, String event, List<String> legalEvents, String uri, Integer line) {
            this.markerFactory.syntaxErrorOnGherkin(this.gherkinFile, "Found " + event + " when expecting one of: " + legalEvents + ". (Current state: " + state + ").", line.intValue());
        }

        public void uri(String uri) {
        }

        public void feature(Feature feature) {
        }

        public void scenarioOutline(ScenarioOutline scenarioOutline) {
            this.inScenarioOutline = true;
            this.scenarioOutlineSteps = new ArrayList<Step>();
        }

        public void examples(Examples examples) {
            ExamplesTableRow examplesHeader = (ExamplesTableRow)examples.getRows().get(0);
            int variablesSize = examplesHeader.getCells().size();
            int i = 1;
            while (i < examples.getRows().size()) {
                ExamplesTableRow currentExample = (ExamplesTableRow)examples.getRows().get(i);
                int examplesSize = currentExample.getCells().size();
                if (examplesSize != variablesSize) {
                    this.markerFactory.syntaxErrorOnGherkin(this.gherkinFile, "The number of examples (" + examplesSize + ")does not match the number of variables (" + variablesSize + ")", currentExample.getLine().intValue());
                } else {
                    try {
                        this.matchScenarioOutlineExample(examplesHeader, currentExample);
                    }
                    catch (CoreException e) {
                        throw new RuntimeException(e);
                    }
                }
                ++i;
            }
        }

        private void matchScenarioOutlineExample(ExamplesTableRow header, ExamplesTableRow example) throws CoreException {
            Map<String, String> exampleVariablesMap = this.getExampleVariablesMap(header, example);
            for (Step scenarioOutlineStepLine : this.scenarioOutlineSteps) {
                this.validate(scenarioOutlineStepLine, exampleVariablesMap, example.getLine());
            }
        }

        private String getResolvedStepStringForExample(Step stepLine, Map<String, String> examplesLineMap) {
            String derivateGherkinStep = stepLine.getName();
            if (examplesLineMap != null) {
                for (Map.Entry<String, String> examplesLineEntry : examplesLineMap.entrySet()) {
                    derivateGherkinStep = derivateGherkinStep.replace("<" + examplesLineEntry.getKey() + ">", examplesLineEntry.getValue());
                }
            }
            return derivateGherkinStep;
        }

        protected void validate(Step step) throws CoreException {
            if (!this.isGlueDetectionEnabled) {
                return;
            }
            Set<StepDefinition> allStepDefinitions = CucumberGherkinBuilder.this.stepDefinitionsProvider.getStepDefinitions(this.project);
            Set<StepDefinition> stepDefinitionsScope = this.filter((IFile)this.gherkinFile, allStepDefinitions);
            StepDefinition glueStepDefinition = this.glueRepository.findMatchingStep(stepDefinitionsScope, step.getName());
            boolean isFound = glueStepDefinition != null;
            GherkinStepWrapper gherkinStepWrapper = new GherkinStepWrapper(step, this.gherkinFile);
            if (isFound) {
                Glue glue = this.glueRepository.add(gherkinStepWrapper, glueStepDefinition);
                this.markerFactory.glueFound(glue);
            } else if (!this.inScenarioOutline) {
                this.markerFactory.unmatchedStep(this.gherkinDocument, gherkinStepWrapper);
                this.glueRepository.clean(step);
            }
        }

        private void validate(Step scenarioOutlineStepLine, Map<String, String> exampleVariablesMap, Integer exampleLine) throws CoreException {
            if (!this.isGlueDetectionEnabled) {
                return;
            }
            String derivateGherkinStepSource = this.getResolvedStepStringForExample(scenarioOutlineStepLine, exampleVariablesMap);
            Set<StepDefinition> allStepDefinitions = CucumberGherkinBuilder.this.stepDefinitionsProvider.getStepDefinitions(this.project);
            Set<StepDefinition> stepDefinitionsScope = this.filter((IFile)this.gherkinFile, allStepDefinitions);
            StepDefinition glueStepDefinition = this.glueRepository.findMatchingStep(stepDefinitionsScope, derivateGherkinStepSource);
            boolean isFound = glueStepDefinition != null;
            GherkinStepWrapper gherkinStepWrapper = new GherkinStepWrapper(scenarioOutlineStepLine, this.gherkinFile);
            if (isFound) {
                Glue glue = this.glueRepository.add(gherkinStepWrapper, glueStepDefinition);
                this.markerFactory.glueFound(glue);
            } else {
                this.markerFactory.unmatchedStep(this.gherkinDocument, gherkinStepWrapper);
                this.markerFactory.gherkinStepExampleUnmatch(this.gherkinDocument, this.gherkinFile, exampleLine.intValue());
            }
        }

        private Set<StepDefinition> filter(IFile gherkinFile, Set<StepDefinition> stepDefinitions) {
            HashSet<StepDefinition> filtered = new HashSet<StepDefinition>();
            String gherkinLocation = gherkinFile.getParent().getFullPath().toString();
            boolean shouldFilterInSameLocation = this.stepPreferences.isGlueOnlyInSameLocationEnabled();
            if (!shouldFilterInSameLocation) {
                return stepDefinitions;
            }
            SameLocationFilter sameLocationFilter = new SameLocationFilter(gherkinLocation);
            FilterUtil.filter(stepDefinitions, (Filter)sameLocationFilter, filtered);
            return filtered;
        }

        private Map<String, String> getExampleVariablesMap(ExamplesTableRow header, ExamplesTableRow values) {
            LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
            int i = 0;
            while (i < header.getCells().size()) {
                result.put((String)header.getCells().get(i), (String)values.getCells().get(i));
                ++i;
            }
            return result;
        }

        public void startOfScenarioLifeCycle(Scenario scenario) {
        }

        public void background(Background background) {
        }

        public void scenario(Scenario scenario) {
            this.inScenarioOutline = false;
        }

        public void step(Step step) {
            if (this.inScenarioOutline) {
                this.scenarioOutlineSteps.add(step);
            }
            try {
                this.validate(step);
            }
            catch (CoreException e) {
                throw new RuntimeException(e);
            }
        }

        public void endOfScenarioLifeCycle(Scenario scenario) {
        }

        public void done() {
        }

        public void close() {
        }

        public void eof() {
        }
    }
}

