/*
 * Decompiled with CFR 0.152.
 */
package cucumber.eclipse.editor.builder;

import cucumber.eclipse.editor.steps.UniversalStepDefinitionsProvider;
import cucumber.eclipse.steps.integration.StepPreferences;
import cucumber.eclipse.steps.integration.marker.MarkerFactory;
import java.io.IOException;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class CucumberStepDefinitionsBuilder
extends IncrementalProjectBuilder {
    public static final String ID = "cucumber.eclipse.builder.stepdefinition";
    private final UniversalStepDefinitionsProvider stepDefinitionsProvider = UniversalStepDefinitionsProvider.INSTANCE;
    private MarkerFactory markerFactory = MarkerFactory.INSTANCE;
    private StepPreferences cucumberPreferences = StepPreferences.INSTANCE;

    protected IProject[] build(int kind, Map<String, String> args, IProgressMonitor monitor) throws CoreException {
        if (!this.cucumberPreferences.isStepDefinitionsMatchingEnabled()) {
            return null;
        }
        switch (kind) {
            case 6: {
                System.out.println("step definitions full build");
                this.fullBuild(this.markerFactory, monitor);
                break;
            }
            case 9: 
            case 10: {
                IResourceDelta delta = this.getDelta(this.getProject());
                System.out.println("step definitions incremental build on " + delta.getResource().getName());
                this.incrementalBuild(delta, this.markerFactory, monitor);
                break;
            }
            case 15: {
                System.out.println("clean build");
                break;
            }
        }
        return null;
    }

    protected void fullBuild(MarkerFactory markerFactory, IProgressMonitor monitor) throws CoreException {
        try {
            IProject project = this.getProject();
            this.stepDefinitionsProvider.clean(project);
            project.accept((IResourceVisitor)new CucumberStepDefinitionsBuildVisitor(markerFactory, monitor));
            this.stepDefinitionsProvider.persist(project, monitor);
        }
        catch (CoreException e) {
            e.printStackTrace();
            throw e;
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new CoreException((IStatus)new Status(4, "cucumber.eclipse.editor", e.getMessage(), (Throwable)e));
        }
    }

    protected void incrementalBuild(IResourceDelta delta, MarkerFactory markerFactory, IProgressMonitor monitor) throws CoreException {
        try {
            IProject project = delta.getResource().getProject();
            if (!this.stepDefinitionsProvider.isInitialized(project)) {
                this.stepDefinitionsProvider.load(project);
            }
            CucumberStepDefinitionsBuildVisitor visitor = new CucumberStepDefinitionsBuildVisitor(markerFactory, monitor);
            delta.accept((IResourceDeltaVisitor)visitor);
            if (visitor.hasProcessedAtLeastOneFile()) {
                this.stepDefinitionsProvider.persist(this.getProject(), monitor);
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new CoreException((IStatus)new Status(4, "cucumber.eclipse.editor", e.getMessage(), (Throwable)e));
        }
    }

    protected void clean(IProgressMonitor monitor) throws CoreException {
        System.out.println("CucumberStepDefinitionsBuilder.clean");
        IProject project = this.getProject();
        this.stepDefinitionsProvider.clean(project);
        project.accept((IResourceVisitor)new CucumberStepDefinitionsCleanBuildVisitor(this.markerFactory, monitor));
    }

    class CucumberStepDefinitionsBuildVisitor
    implements IResourceVisitor,
    IResourceDeltaVisitor {
        private IProgressMonitor monitor;
        private MarkerFactory markerFactory;
        private boolean hasProcessedAtLeastOneFile = false;

        public CucumberStepDefinitionsBuildVisitor(MarkerFactory markerFactory, IProgressMonitor monitor) {
            this.monitor = monitor;
            this.markerFactory = markerFactory;
        }

        public boolean visit(IResource resource) throws CoreException {
            if (this.monitor.isCanceled()) {
                return false;
            }
            if (!resource.exists()) {
                return true;
            }
            if (CucumberStepDefinitionsBuilder.this.stepDefinitionsProvider.support(resource)) {
                this.hasProcessedAtLeastOneFile = true;
                this.markerFactory.cleanMarkers(resource);
                CucumberStepDefinitionsBuilder.this.stepDefinitionsProvider.findStepDefinitions(resource, this.markerFactory, this.monitor);
            }
            return true;
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            boolean projectDescriptionChanged;
            if (this.monitor.isCanceled()) {
                return false;
            }
            int flags = delta.getFlags();
            boolean contentChanged = (flags & 0x100) != 0;
            boolean bl = projectDescriptionChanged = (flags & 0x80000) != 0;
            if (contentChanged || projectDescriptionChanged) {
                IResource resource = delta.getResource();
                return this.visit(resource);
            }
            return true;
        }

        public boolean hasProcessedAtLeastOneFile() {
            return this.hasProcessedAtLeastOneFile;
        }
    }

    class CucumberStepDefinitionsCleanBuildVisitor
    implements IResourceVisitor {
        private IProgressMonitor monitor;
        private MarkerFactory markerFactory;

        public CucumberStepDefinitionsCleanBuildVisitor(MarkerFactory markerFactory, IProgressMonitor monitor) {
            this.monitor = monitor;
            this.markerFactory = markerFactory;
        }

        public boolean visit(IResource resource) throws CoreException {
            if (this.monitor.isCanceled()) {
                return false;
            }
            this.markerFactory.cleanMarkers(resource);
            return true;
        }
    }
}

