/*
 * Decompiled with CFR 0.152.
 */
package cucumber.eclipse.editor.editors;

import cucumber.eclipse.editor.editors.ColorManager;
import cucumber.eclipse.editor.editors.GherkinColors;
import cucumber.eclipse.editor.editors.GherkinNumericDetector;
import cucumber.eclipse.editor.editors.GherkinPlaceholderRule;
import cucumber.eclipse.editor.editors.GherkinStarStepWordDetector;
import cucumber.eclipse.editor.editors.GherkinTagRule;
import cucumber.eclipse.editor.editors.GherkinWhitespaceDetector;
import cucumber.eclipse.editor.editors.GherkinWordDetector;
import gherkin.I18n;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.EndOfLineRule;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.SingleLineRule;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WhitespaceRule;
import org.eclipse.jface.text.rules.WordRule;

public class GherkinKeywordScanner
extends RuleBasedScanner {
    private static final List<String> FEATURE_ELEMENT_KEYWORD_KEYS = Arrays.asList("scenario_outline", "feature", "background", "scenario", "examples");
    private static final List<String> STEP_KEYWORD_KEYS = Arrays.asList("given", "when", "then", "and", "but");
    private static I18n i18n;
    private static String _code;
    private ColorManager manager;

    static {
        _code = "en";
    }

    public GherkinKeywordScanner(ColorManager manager) {
        this.manager = manager;
        this.configureRules();
    }

    public void configureRules() {
        List keywords;
        this.validateIsoCode();
        i18n = new I18n(_code);
        Token keyword = new Token((Object)new TextAttribute(this.manager.getColor(GherkinColors.KEYWORD)));
        Token step = new Token((Object)new TextAttribute(this.manager.getColor(GherkinColors.STEP)));
        Token tag = new Token((Object)new TextAttribute(this.manager.getColor(GherkinColors.TAG)));
        Token string = new Token((Object)new TextAttribute(this.manager.getColor(GherkinColors.STRING)));
        Token comment = new Token((Object)new TextAttribute(this.manager.getColor(GherkinColors.COMMENT)));
        Token other = new Token((Object)new TextAttribute(this.manager.getColor(GherkinColors.DEFAULT)));
        Token numeric = new Token((Object)new TextAttribute(this.manager.getColor(GherkinColors.NUMERIC)));
        Token placeholder = new Token((Object)new TextAttribute(this.manager.getColor(GherkinColors.PLACEHOLDER)));
        ArrayList<Object> rules = new ArrayList<Object>();
        rules.add(new EndOfLineRule("#", (IToken)comment));
        rules.add(new SingleLineRule("\"", "\"", (IToken)string, '\\'));
        rules.add(new SingleLineRule("'", "'", (IToken)string, '\\'));
        rules.add(new GherkinTagRule((IToken)tag));
        rules.add(new GherkinPlaceholderRule((IToken)placeholder));
        rules.add(new WhitespaceRule((IWhitespaceDetector)new GherkinWhitespaceDetector()));
        WordRule wordRule = new WordRule((IWordDetector)new GherkinWordDetector(), (IToken)other);
        WordRule numericRule = new WordRule((IWordDetector)new GherkinNumericDetector(), (IToken)numeric);
        WordRule wordStarStepRule = new WordRule((IWordDetector)new GherkinStarStepWordDetector(), (IToken)step);
        wordStarStepRule.addWord("*", (IToken)keyword);
        for (String featureElement : FEATURE_ELEMENT_KEYWORD_KEYS) {
            keywords = i18n.keywords(featureElement);
            for (String e : keywords) {
                rules.add(new SingleLineRule(String.valueOf(e.trim()) + ":", " ", (IToken)keyword));
            }
        }
        for (String featureElement : STEP_KEYWORD_KEYS) {
            keywords = i18n.keywords(featureElement);
            for (String e : keywords) {
                rules.add(new SingleLineRule(e.trim(), " ", (IToken)step));
            }
        }
        rules.add(numericRule);
        rules.add(wordRule);
        rules.add(wordStarStepRule);
        IRule[] result = new IRule[rules.size()];
        rules.toArray(result);
        this.setRules(result);
    }

    private void validateIsoCode() {
        boolean valid = false;
        try {
            List all = I18n.getAll();
            for (I18n i18n : all) {
                if (!i18n.getIsoCode().equals(_code)) continue;
                valid = true;
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            _code = "en";
        }
        if (!valid) {
            _code = "en";
        }
    }

    public static void setCode(String code) {
        _code = code;
    }
}

