/*
 * Decompiled with CFR 0.152.
 */
package cucumber.eclipse.editor.editors;

import cucumber.eclipse.editor.Activator;
import cucumber.eclipse.editor.contentassist.CucumberContentAssist;
import cucumber.eclipse.editor.editors.DocumentUtil;
import cucumber.eclipse.editor.editors.Editor;
import cucumber.eclipse.steps.integration.KeyWordProvider;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.internal.runtime.AdapterManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.swt.graphics.Image;

public class GherkinKeywordsAssistProcessor
implements IContentAssistProcessor {
    private final IContextInformation[] NO_CONTEXTS = new IContextInformation[0];
    private ICompletionProposal[] NO_COMPLETIONS = new ICompletionProposal[0];
    public final Image ICON = Activator.getImageDescriptor("icons/cukes.gif").createImage();
    private Editor editor;
    private String errorMsg;

    public GherkinKeywordsAssistProcessor(Editor editor) {
        this.editor = editor;
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        this.errorMsg = null;
        try {
            IDocument document = viewer.getDocument();
            String lang = DocumentUtil.getDocumentLanguage(document);
            if (lang == null) {
                lang = "en";
            }
            IProject project = this.editor.getFile().getProject();
            CucumberContentAssist contentAssist = new CucumberContentAssist(lang, project);
            KeyWordProvider keyWordProvider = this.getKeyWordProvider(project);
            if (keyWordProvider == null) {
                this.errorMsg = "Can't fetch keywords!";
                return this.NO_COMPLETIONS;
            }
            List stepKeyWords = keyWordProvider.getStepKeyWords(lang);
            List groupingKeyWords = keyWordProvider.getGroupingKeyWords(lang);
            IRegion line = viewer.getDocument().getLineInformationOfOffset(offset);
            String typed = viewer.getDocument().get(line.getOffset(), offset - line.getOffset()).replaceAll(contentAssist.STARTSWITH_ANYSPACE, "");
            String preStep = viewer.getDocument().get(line.getOffset(), line.getLength()).replaceAll(contentAssist.STARTSWITH_ANYSPACE, "");
            preStep = contentAssist.lastPrefix(preStep, stepKeyWords);
            ArrayList<ICompletionProposal> result = new ArrayList<ICompletionProposal>();
            for (String groupingKeyWord : groupingKeyWords) {
                if (!groupingKeyWord.startsWith(typed)) continue;
                result.add((ICompletionProposal)this.createCompletionProposal(offset, typed, groupingKeyWord, String.valueOf(groupingKeyWord) + ":\r\n"));
            }
            for (String stepKeyWord : stepKeyWords) {
                if (stepKeyWord.startsWith(typed)) {
                    result.add((ICompletionProposal)this.createCompletionProposal(offset, typed, stepKeyWord, String.valueOf(stepKeyWord) + " "));
                    continue;
                }
                if (!typed.startsWith(stepKeyWord)) continue;
                this.addStepDetailsProposal(offset, typed, preStep, result, stepKeyWords, contentAssist);
            }
            return result.toArray(new ICompletionProposal[result.size()]);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.errorMsg = e.toString();
            return this.NO_COMPLETIONS;
        }
    }

    private KeyWordProvider getKeyWordProvider(IProject project) {
        Object adapter = AdapterManager.getDefault().loadAdapter((Object)project, KeyWordProvider.class.getName());
        if (adapter instanceof KeyWordProvider) {
            return (KeyWordProvider)adapter;
        }
        return (KeyWordProvider)project.getAdapter(KeyWordProvider.class);
    }

    private void addStepDetailsProposal(int offset, String typed, String preStep, ArrayList<ICompletionProposal> result, List<String> stepKeyWords, CucumberContentAssist contentAssist) {
        String lastPrefix = contentAssist.lastPrefix(typed, stepKeyWords);
        contentAssist.collectAllSteps(lastPrefix);
        List<String> stepDetailList = contentAssist.importAllStepList();
        List<String> matchedStepList = contentAssist.importMatchedStepList();
        if (matchedStepList.isEmpty() && stepDetailList.isEmpty()) {
            contentAssist.displayNoProposal(offset, this.ICON, result);
        } else if (!matchedStepList.isEmpty()) {
            for (String step : matchedStepList) {
                if (step.startsWith(lastPrefix)) {
                    contentAssist.importStepProposals(lastPrefix, preStep, offset, this.ICON, step, result);
                    continue;
                }
                if (!step.contains(lastPrefix)) continue;
                contentAssist.importStepProposals(lastPrefix, preStep, offset, this.ICON, step, result);
            }
        } else if (lastPrefix.matches(contentAssist.STARTS_ANY) && matchedStepList.isEmpty()) {
            contentAssist.displayNoProposal(offset, this.ICON, result);
        } else if (lastPrefix.matches(contentAssist.COMMA_SPACE_REGEX) | !stepDetailList.isEmpty()) {
            for (String step : stepDetailList) {
                contentAssist.importStepProposals(lastPrefix, preStep, offset, this.ICON, step, result);
            }
        } else {
            contentAssist.displayNoProposal(offset, this.ICON, result);
        }
    }

    private CompletionProposal createCompletionProposal(int offset, String typed, String displayString, String fullString) {
        return new CompletionProposal(fullString, offset - typed.length(), typed.length(), fullString.length(), this.ICON, displayString, null, null);
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        return this.NO_CONTEXTS;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return null;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public String getErrorMessage() {
        return this.errorMsg;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }
}

