/*
 * Decompiled with CFR 0.152.
 */
package cucumber.eclipse.editor.editors;

import cucumber.eclipse.editor.editors.PositionedElement;
import gherkin.formatter.Formatter;
import gherkin.formatter.model.Background;
import gherkin.formatter.model.BasicStatement;
import gherkin.formatter.model.DescribedStatement;
import gherkin.formatter.model.Examples;
import gherkin.formatter.model.ExamplesTableRow;
import gherkin.formatter.model.Feature;
import gherkin.formatter.model.Scenario;
import gherkin.formatter.model.ScenarioOutline;
import gherkin.formatter.model.Step;
import gherkin.lexer.LexingError;
import gherkin.parser.ParseError;
import gherkin.parser.Parser;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;

public class GherkinModel {
    private List<PositionedElement> elements = new ArrayList<PositionedElement>();

    public PositionedElement getFeatureElement() {
        return this.elements.isEmpty() ? null : this.elements.get(0);
    }

    public List<Position> getFoldRanges() {
        ArrayList<Position> foldRanges = new ArrayList<Position>();
        for (PositionedElement element : this.elements) {
            if (!element.isFeature() && !element.isStepContainer() && !element.isExamples()) continue;
            try {
                foldRanges.add(element.toPosition());
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
        }
        return foldRanges;
    }

    public PositionedElement getStepElement(int offset) throws BadLocationException {
        for (PositionedElement element : this.elements) {
            if (!element.isStep() || !element.toPosition().includes(offset)) continue;
            return element;
        }
        return null;
    }

    public void updateFromDocument(final IDocument document) {
        this.elements.clear();
        Formatter formatter = new Formatter(){
            private Stack<PositionedElement> stack = new Stack();

            public void uri(String arg0) {
            }

            public void syntaxError(String state, String event, List<String> legalEvents, String uri, Integer line) {
            }

            public void step(Step arg0) {
                PositionedElement element = this.newPositionedElement((BasicStatement)arg0);
                this.stack.peek().addChild(element);
                this.stack.peek().setEndLine(arg0.getLineRange().getLast());
            }

            public void scenarioOutline(ScenarioOutline arg0) {
                this.handleStepContainer((DescribedStatement)arg0);
            }

            private void handleStepContainer(DescribedStatement stmt) {
                if (this.stack.peek().isStepContainer()) {
                    this.stack.pop();
                }
                PositionedElement element = this.newPositionedElement((BasicStatement)stmt);
                this.stack.peek().addChild(element);
                this.stack.push(element);
            }

            public void scenario(Scenario arg0) {
                this.handleStepContainer((DescribedStatement)arg0);
            }

            public void feature(Feature arg0) {
                this.stack.push(this.newPositionedElement((BasicStatement)arg0));
            }

            public void examples(Examples arg0) {
                int lastLine = this.getLastExamplesLine(arg0);
                this.newPositionedElement((BasicStatement)arg0).setEndLine(lastLine);
                this.stack.peek().setEndLine(lastLine);
            }

            public void eof() {
                while (!this.stack.isEmpty()) {
                    this.stack.pop().setEndLine(document.getNumberOfLines());
                }
            }

            public void done() {
            }

            public void close() {
            }

            public void background(Background arg0) {
                this.handleStepContainer((DescribedStatement)arg0);
            }

            private PositionedElement newPositionedElement(BasicStatement stmt) {
                PositionedElement element = new PositionedElement(document, stmt);
                GherkinModel.this.elements.add(element);
                return element;
            }

            private int getLastExamplesLine(Examples examples) {
                int lastline = examples.getLineRange().getLast();
                if (!examples.getRows().isEmpty()) {
                    lastline = ((ExamplesTableRow)examples.getRows().get(examples.getRows().size() - 1)).getLine();
                }
                return lastline;
            }

            public void endOfScenarioLifeCycle(Scenario arg0) {
            }

            public void startOfScenarioLifeCycle(Scenario arg0) {
            }
        };
        Parser p = new Parser(formatter, false);
        try {
            p.parse(document.get(), "", Integer.valueOf(0));
        }
        catch (LexingError le) {
            le.printStackTrace();
        }
        catch (ParseError pe) {
            pe.printStackTrace();
        }
    }
}

