/*
 * Decompiled with CFR 0.152.
 */
package cucumber.eclipse.editor.editors;

import cucumber.eclipse.editor.editors.PositionedElement;
import gherkin.formatter.model.BasicStatement;
import org.eclipse.jface.viewers.BaseLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;

public class GherkinOutlinePage
extends ContentOutlinePage {
    private PositionedElement featureElement;
    private TreeViewer viewer;
    private IEditorInput input;

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.viewer = this.getTreeViewer();
        this.viewer.setContentProvider((IContentProvider)new ContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.viewer.setComparer((IElementComparer)new ElementComparer());
        this.viewer.setInput((Object)this.input);
    }

    public void setInput(IEditorInput input) {
        this.input = input;
        if (this.viewer != null) {
            this.viewer.setInput((Object)input);
        }
    }

    public void update(PositionedElement featureElement) {
        this.featureElement = featureElement;
        if (this.viewer != null) {
            this.viewer.refresh();
        }
    }

    private class ContentProvider
    implements ITreeContentProvider {
        private ContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            Object[] objectArray;
            if (GherkinOutlinePage.this.featureElement == null) {
                objectArray = new Object[]{};
            } else {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = GherkinOutlinePage.this.featureElement;
            }
            return objectArray;
        }

        public Object[] getChildren(Object parentElement) {
            return ((PositionedElement)parentElement).getChildren().toArray();
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return !((PositionedElement)element).getChildren().isEmpty();
        }
    }

    private static class ElementComparer
    implements IElementComparer {
        private ElementComparer() {
        }

        public int hashCode(Object element) {
            return element instanceof PositionedElement ? ((PositionedElement)element).getStatement().getLine().intValue() : element.hashCode();
        }

        public boolean equals(Object a, Object b) {
            if (a instanceof PositionedElement && b instanceof PositionedElement) {
                BasicStatement s1 = ((PositionedElement)a).getStatement();
                BasicStatement s2 = ((PositionedElement)b).getStatement();
                return s1.getLine().equals(s2.getLine()) && s1.getKeyword().equals(s2.getKeyword()) && s1.getName().equals(s2.getName());
            }
            return a.equals(b);
        }
    }

    private class LabelProvider
    extends BaseLabelProvider
    implements ILabelProvider {
        private LabelProvider() {
        }

        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            return element.toString();
        }
    }
}

