/*
 * Decompiled with CFR 0.152.
 */
package cucumber.eclipse.editor.editors;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.texteditor.ITextEditor;

public class GherkinToggleCommentHandler
extends AbstractHandler {
    private static final char EMPTY_CHAR = ' ';
    private static final char COMMENT_CHAR = '#';

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ITextEditor editor = (ITextEditor)HandlerUtil.getActiveEditorChecked((ExecutionEvent)event);
        ISelectionProvider selectionProvider = editor.getSelectionProvider();
        TextSelection selection = (TextSelection)selectionProvider.getSelection();
        IDocument doc = editor.getDocumentProvider().getDocument((Object)editor.getEditorInput());
        this.toggleComments(doc, selection);
        selectionProvider.setSelection((ISelection)selection);
        return null;
    }

    private void toggleComments(IDocument doc, TextSelection selection) {
        try {
            boolean shouldComment = this.shouldComment(doc, selection);
            if (shouldComment) {
                this.commentSelectedLines(doc, selection);
            } else {
                this.uncommentSelectedLines(doc, selection);
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    private boolean shouldComment(IDocument doc, TextSelection selection) throws BadLocationException {
        boolean shouldComment = false;
        int i = selection.getStartLine();
        while (i < selection.getEndLine() + 1) {
            int offset = doc.getLineOffset(i);
            while (offset < doc.getLineOffset(i) + doc.getLineLength(i)) {
                if (doc.getChar(offset) != ' ') {
                    if (doc.getChar(offset) == '#') break;
                    shouldComment = true;
                    break;
                }
                ++offset;
            }
            ++i;
        }
        return shouldComment;
    }

    private void commentSelectedLines(IDocument doc, TextSelection selection) throws BadLocationException {
        StringBuilder content = new StringBuilder(doc.get());
        int addedChars = 0;
        int i = selection.getStartLine();
        while (i < selection.getEndLine() + 1) {
            int offset = doc.getLineOffset(i);
            while (offset < doc.getLineOffset(i) + doc.getLineLength(i)) {
                if (doc.getChar(offset) != ' ') {
                    if (doc.getChar(offset) == '#') break;
                    content.insert(offset + addedChars, '#');
                    ++addedChars;
                    break;
                }
                ++offset;
            }
            ++i;
        }
        doc.set(content.toString());
    }

    private void uncommentSelectedLines(IDocument doc, TextSelection selection) throws BadLocationException {
        StringBuilder content = new StringBuilder(doc.get());
        int removedChars = 0;
        int i = selection.getStartLine();
        while (i < selection.getEndLine() + 1) {
            int offset = doc.getLineOffset(i);
            while (offset < doc.getLineOffset(i) + doc.getLineLength(i)) {
                if (doc.getChar(offset) != ' ') {
                    if (doc.getChar(offset) != '#') break;
                    content.deleteCharAt(offset - removedChars);
                    ++removedChars;
                    break;
                }
                ++offset;
            }
            ++i;
        }
        doc.set(content.toString());
    }
}

