/*
 * Decompiled with CFR 0.152.
 */
package cucumber.eclipse.editor.markers;

import cucumber.eclipse.editor.i18n.CucumberEditorMessages;
import cucumber.eclipse.editor.nature.CucumberProjectNature;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.IMarkerResolutionGenerator2;

public class ConfigureAsCucumberProjectMarkerResolutionGenerator
implements IMarkerResolutionGenerator2 {
    public IMarkerResolution[] getResolutions(IMarker marker) {
        if (!this.hasResolutions(marker)) {
            return new IMarkerResolution[0];
        }
        return new IMarkerResolution[]{new ConfigureAsCucumberProjectMarkerResolution(marker.getResource().getProject())};
    }

    public boolean hasResolutions(IMarker marker) {
        boolean hasResolutions = false;
        try {
            hasResolutions = "cucumber.eclipse.marker.not_a_cucumber_project".equals(marker.getType());
        }
        catch (CoreException e) {
            e.printStackTrace();
            hasResolutions = false;
        }
        return hasResolutions;
    }

    private class ConfigureAsCucumberProjectMarkerResolution
    implements IMarkerResolution {
        private IProject project;

        public ConfigureAsCucumberProjectMarkerResolution(IProject project) {
            this.project = project;
        }

        public String getLabel() {
            return NLS.bind((String)CucumberEditorMessages.MarkerResolution__Configure_as_cucumber_project, (Object)this.project.getName());
        }

        public void run(IMarker marker) {
            try {
                CucumberProjectNature cucumberProjectNature = new CucumberProjectNature();
                cucumberProjectNature.setProject(this.project);
                cucumberProjectNature.configure();
                marker.delete();
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
    }
}

