/*
 * Decompiled with CFR 0.152.
 */
package cucumber.eclipse.editor.markers;

import cucumber.eclipse.editor.Activator;
import cucumber.eclipse.editor.editors.DocumentUtil;
import cucumber.eclipse.editor.editors.Editor;
import cucumber.eclipse.editor.editors.GherkinModel;
import cucumber.eclipse.editor.snippet.ExtensionRegistryStepGeneratorProvider;
import cucumber.eclipse.editor.snippet.SnippetApplicator;
import cucumber.eclipse.editor.steps.UniversalStepDefinitionsProvider;
import gherkin.formatter.model.Step;
import java.io.IOException;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.IMarkerResolutionGenerator;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;

public class StepCreationMarkerResolutionGenerator
implements IMarkerResolutionGenerator {
    public IMarkerResolution[] getResolutions(IMarker marker) {
        try {
            boolean isUnmatchedStepMarker = "cucumber.eclipse.marker.gherkin.unmatched_step".equals(marker.getType());
            if (!isUnmatchedStepMarker) {
                return new IMarkerResolution[0];
            }
            String gherkinStepKeyword = (String)marker.getAttribute("cucumber.eclipse.marker.gherkin.unmatched_step.keyword");
            String gherkinStepName = (String)marker.getAttribute("cucumber.eclipse.marker.gherkin.unmatched_step.name");
            Step gherkinStep = new Step(null, gherkinStepKeyword, gherkinStepName, null, null, null);
            UniversalStepDefinitionsProvider stepProvider = UniversalStepDefinitionsProvider.INSTANCE;
            IFile gherkinFile = (IFile)marker.getResource();
            IProject project = gherkinFile.getProject();
            if (!stepProvider.isInitialized(project)) {
                try {
                    stepProvider.load(project);
                }
                catch (CoreException e) {
                    Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                    ErrorDialog.openError((Shell)shell, (String)"Any cucumber build results found.", (String)"Build the project to get resolution suggestions.", (IStatus)e.getStatus());
                }
            }
            Set<IFile> stepDefinitionsFiles = stepProvider.getStepDefinitionsFiles(project);
            IMarkerResolution[] resolutions = new IMarkerResolution[stepDefinitionsFiles.size()];
            int it = 0;
            for (IFile stepDefinitionsFile : stepDefinitionsFiles) {
                resolutions[it++] = new StepCreationMarkerResolution(gherkinStep, stepDefinitionsFile);
            }
            return resolutions;
        }
        catch (CoreException e) {
            e.printStackTrace();
            return new IMarkerResolution[0];
        }
    }

    private static class StepCreationMarkerResolution
    implements IMarkerResolution {
        private final IFile stepDefinitionsFile;
        private final Step gherkinStep;

        public StepCreationMarkerResolution(Step gherkinStep, IFile stepDefinitionsFile) {
            this.stepDefinitionsFile = stepDefinitionsFile;
            this.gherkinStep = gherkinStep;
        }

        public void run(IMarker marker) {
            ExtensionRegistryStepGeneratorProvider generatorProvider = new ExtensionRegistryStepGeneratorProvider();
            new SnippetApplicator(generatorProvider).generateSnippet(this.gherkinStep, this.stepDefinitionsFile);
        }

        public String getLabel() {
            return String.format("Create step in %s", this.stepDefinitionsFile.getName());
        }

        private static GherkinModel getCurrentModel(IFile featureFile) throws IOException, CoreException {
            GherkinModel model = StepCreationMarkerResolution.getModelFromOpenEditor(featureFile);
            if (model == null) {
                model = StepCreationMarkerResolution.getModelFromFile(featureFile);
            }
            return model;
        }

        private static GherkinModel getModelFromOpenEditor(IFile featureFile) throws PartInitException {
            IEditorReference[] editorReferences;
            IEditorReference[] iEditorReferenceArray = editorReferences = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getEditorReferences();
            int n = editorReferences.length;
            int n2 = 0;
            while (n2 < n) {
                IEditorPart editor;
                FileEditorInput fileEditorInput;
                IEditorReference editorReference = iEditorReferenceArray[n2];
                if (editorReference.getEditorInput() instanceof FileEditorInput && featureFile.equals((Object)(fileEditorInput = (FileEditorInput)editorReference.getEditorInput()).getFile()) && (editor = editorReference.getEditor(false)) instanceof Editor) {
                    return ((Editor)editor).getModel();
                }
                ++n2;
            }
            return null;
        }

        private static GherkinModel getModelFromFile(IFile featureFile) throws IOException, CoreException {
            GherkinModel model = new GherkinModel();
            model.updateFromDocument(DocumentUtil.read(featureFile.getContents(), featureFile.getCharset()));
            return model;
        }

        private static void logException(IMarker marker, Exception exception) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "cucumber.eclipse.editor", String.format("Couldn't create step for %s", marker), (Throwable)exception));
        }
    }
}

