/*
 * Decompiled with CFR 0.152.
 */
package cucumber.eclipse.editor.nature;

import cucumber.eclipse.steps.integration.builder.BuilderUtil;
import cucumber.eclipse.steps.integration.marker.MarkerFactory;
import java.util.LinkedHashMap;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class CucumberProjectNature
implements IProjectNature {
    public static final String ID = "cucumber.eclipse.nature";
    private IProject project;

    public void configure() throws CoreException {
        IProjectDescription description = this.project.getDescription();
        String[] oldNatures = description.getNatureIds();
        String[] newNatures = new String[oldNatures.length + 1];
        newNatures[0] = ID;
        int it = 0;
        while (it < oldNatures.length) {
            String nature = oldNatures[it];
            if (ID.equals(nature)) {
                return;
            }
            newNatures[it + 1] = nature;
            ++it;
        }
        description.setNatureIds(newNatures);
        this.project.setDescription(description, (IProgressMonitor)new NullProgressMonitor());
        MarkerFactory.INSTANCE.cleanCucumberNatureMissing(this.project);
        this.addBuilder(this.project);
        BuilderUtil.buildProject((IProject)this.project, (int)6);
    }

    public void deconfigure() throws CoreException {
        this.removeBuilder(this.project);
        MarkerFactory.INSTANCE.cleanMarkersRecursively((IResource)this.project);
    }

    public IProject getProject() {
        return this.project;
    }

    public void setProject(IProject project) {
        this.project = project;
    }

    private void addBuilder(IProject projectToUpdate) throws CoreException {
        IProjectDescription description = projectToUpdate.getDescription();
        LinkedHashMap<String, ICommand> builders = new LinkedHashMap<String, ICommand>(description.getBuildSpec().length + 1);
        ICommand[] iCommandArray = description.getBuildSpec();
        int n = iCommandArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICommand builder = iCommandArray[n2];
            builders.put(builder.getBuilderName(), builder);
            ++n2;
        }
        ICommand stepDefinitionsBuilder = description.newCommand();
        stepDefinitionsBuilder.setBuilderName("cucumber.eclipse.builder.stepdefinition");
        builders.put(stepDefinitionsBuilder.getBuilderName(), stepDefinitionsBuilder);
        ICommand gherkinBuilder = description.newCommand();
        gherkinBuilder.setBuilderName("cucumber.eclipse.builder.gherkin");
        builders.put(gherkinBuilder.getBuilderName(), gherkinBuilder);
        description.setBuildSpec(builders.values().toArray(new ICommand[builders.size()]));
        projectToUpdate.setDescription(description, (IProgressMonitor)new NullProgressMonitor());
    }

    private void removeBuilder(IProject project) throws CoreException {
        IProjectDescription description = project.getDescription();
        ICommand[] buildSpec = description.getBuildSpec();
        ICommand[] newBuildSpec = new ICommand[buildSpec.length - 2];
        int it = 0;
        ICommand[] iCommandArray = buildSpec;
        int n = buildSpec.length;
        int n2 = 0;
        while (n2 < n) {
            boolean isCucumberBuilder;
            ICommand builder = iCommandArray[n2];
            boolean bl = isCucumberBuilder = "cucumber.eclipse.builder.stepdefinition".equals(builder.getBuilderName()) || "cucumber.eclipse.builder.gherkin".equals(builder.getBuilderName());
            if (!isCucumberBuilder) {
                newBuildSpec[it++] = builder;
            }
            ++n2;
        }
        description.setBuildSpec(newBuildSpec);
        project.setDescription(description, (IProgressMonitor)new NullProgressMonitor());
    }
}

