/*
 * Decompiled with CFR 0.152.
 */
package cucumber.eclipse.editor.properties;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ICoreRunnable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.dialogs.PropertyPage;
import org.osgi.service.prefs.BackingStoreException;

public class ProjectGlueCodeOptions
extends PropertyPage
implements IWorkbenchPropertyPage {
    private Button matchAllParameterButton;
    private static final String NAMESPACE = "cucumber.steps.glue";
    private static final String KEY_MATCH_ALL_PARAMETER = "matchAllParameter";

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        GridData data = new GridData(1808);
        data.grabExcessHorizontalSpace = true;
        composite.setLayoutData((Object)data);
        this.matchAllParameterButton = this.createEnableOption(composite);
        return composite;
    }

    private Button createEnableOption(Composite composite) {
        Button button = new Button(composite, 32);
        GridData gd = new GridData();
        button.setLayoutData((Object)gd);
        gd.horizontalSpan = 2;
        button.setText("Match regardless of parametertype");
        button.setSelection(ProjectGlueCodeOptions.isMatchAllParameter(this.getResource()));
        button.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        return button;
    }

    private IResource getResource() {
        return (IResource)this.getElement().getAdapter(IResource.class);
    }

    private static IEclipsePreferences getNode(IResource resource) {
        ProjectScope scope = new ProjectScope(resource.getProject());
        IEclipsePreferences node = scope.getNode(NAMESPACE);
        return node;
    }

    protected void performDefaults() {
        super.performDefaults();
        this.matchAllParameterButton.setSelection(false);
    }

    public boolean performOk() {
        IResource resource = this.getResource();
        IEclipsePreferences node = ProjectGlueCodeOptions.getNode(resource);
        boolean oldvalue = ProjectGlueCodeOptions.isMatchAllParameter(resource);
        boolean newValue = this.matchAllParameterButton.getSelection();
        if (newValue != oldvalue) {
            node.putBoolean(KEY_MATCH_ALL_PARAMETER, newValue);
            try {
                node.flush();
            }
            catch (BackingStoreException backingStoreException) {}
            final IProject project = resource.getProject();
            Job.create((String)("Rebuild of " + project.getName()), (ICoreRunnable)new ICoreRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    project.build(6, monitor);
                }
            }).schedule();
        }
        return true;
    }

    public static boolean isMatchAllParameter(IResource resource) {
        IEclipsePreferences node = ProjectGlueCodeOptions.getNode(resource);
        return node.getBoolean(KEY_MATCH_ALL_PARAMETER, false);
    }
}

