/*
 * Decompiled with CFR 0.152.
 */
package cucumber.eclipse.editor.util;

import cucumber.eclipse.editor.Activator;
import cucumber.eclipse.steps.integration.IStepDefinitionGenerator;
import cucumber.eclipse.steps.integration.IStepDefinitionOpener;
import cucumber.eclipse.steps.integration.IStepDefinitionsProvider;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;

public class ExtensionRegistryUtil {
    static final String EXTENSION_POINT_STEPDEFINITIONS_ID = "cucumber.eclipse.steps.integration";
    static final String EXTENSION_POINT_STEPDEFINITIONS_OPENER = "cucumber.eclipse.editor.step_definition_opener";

    private static <T> List<T> getIntegrationExtensionsOfType(String extensionPointId, Class<T> clazz) {
        IConfigurationElement[] config;
        ArrayList<Object> extensions = new ArrayList<Object>();
        IConfigurationElement[] iConfigurationElementArray = config = Platform.getExtensionRegistry().getConfigurationElementsFor(extensionPointId);
        int n = config.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ce = iConfigurationElementArray[n2];
            try {
                Object obj = ce.createExecutableExtension("class");
                if (clazz.isAssignableFrom(obj.getClass())) {
                    Object value = obj;
                    extensions.add(value);
                }
            }
            catch (Exception e) {
                Activator.getDefault().getLog().log((IStatus)new Status(4, "cucumber.eclipse.editor", "Couldn't instantiate extension", (Throwable)e));
            }
            ++n2;
        }
        return extensions;
    }

    public static List<IStepDefinitionsProvider> getStepDefinitionsProvider() {
        return ExtensionRegistryUtil.getIntegrationExtensionsOfType(EXTENSION_POINT_STEPDEFINITIONS_ID, IStepDefinitionsProvider.class);
    }

    public static List<IStepDefinitionGenerator> getStepDefinitionGenerator() {
        return ExtensionRegistryUtil.getIntegrationExtensionsOfType(EXTENSION_POINT_STEPDEFINITIONS_ID, IStepDefinitionGenerator.class);
    }

    public static List<IStepDefinitionOpener> getStepDefinitionOpener() {
        return ExtensionRegistryUtil.getIntegrationExtensionsOfType(EXTENSION_POINT_STEPDEFINITIONS_OPENER, IStepDefinitionOpener.class);
    }
}

