/*
 * Decompiled with CFR 0.152.
 */
package cucumber.eclipse.editor.util;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;

public class SWTUtil {
    public static void setButtonGridData(Button button) {
        GridData gridData = new GridData();
        button.setLayoutData((Object)gridData);
        SWTUtil.setButtonDimensionHint(button);
    }

    public static int getButtonWidthHint(Button button) {
        button.setFont(JFaceResources.getDialogFont());
        PixelConverter converter = new PixelConverter((Control)button);
        int widthHint = converter.convertHorizontalDLUsToPixels(61);
        return Math.max(widthHint, button.computeSize((int)-1, (int)-1, (boolean)true).x);
    }

    public static void setButtonDimensionHint(Button button) {
        Object gd = button.getLayoutData();
        if (gd instanceof GridData) {
            ((GridData)gd).widthHint = SWTUtil.getButtonWidthHint(button);
        }
    }

    public static Display getDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow(IWorkbench workBench) {
        if (workBench == null) {
            return null;
        }
        return workBench.getActiveWorkbenchWindow();
    }

    public static IWorkbenchPage getActivePage(IWorkbench workBench) {
        IWorkbenchWindow activeWorkbenchWindow = SWTUtil.getActiveWorkbenchWindow(workBench);
        if (activeWorkbenchWindow == null) {
            return null;
        }
        return activeWorkbenchWindow.getActivePage();
    }

    public static Composite createGridContainer(Composite parent, int columns) {
        Composite result = new Composite(parent, 0);
        SWTUtil.createGridLayout(result, columns);
        return result;
    }

    public static void createGridLayout(Composite result, int columns) {
        GridLayout layout = new GridLayout();
        layout.numColumns = columns;
        result.setLayout((Layout)layout);
        GridData gd = new GridData(4, 4, true, true);
        result.setLayoutData((Object)gd);
    }

    public static Text createPathBrowserText(final Composite container, String text, ModifyListener listener) {
        final Text result = SWTUtil.createLabelText(container, text, listener);
        Button button = new Button(container, 8);
        button.setText("Browse...");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object[] res;
                ContainerSelectionDialog dialog = new ContainerSelectionDialog(container.getShell(), (IContainer)ResourcesPlugin.getWorkspace().getRoot(), false, "Select new file container");
                dialog.showClosedProjects(false);
                if (dialog.open() == 0 && (res = dialog.getResult()).length == 1) {
                    result.setText(((Path)res[0]).toString());
                }
            }
        });
        return result;
    }

    public static Text createLabelText(Composite container, String text, ModifyListener listener) {
        Label label = new Label(container, 0);
        label.setText(text);
        Text result = new Text(container, 2052);
        GridData gd = new GridData(768);
        result.setLayoutData((Object)gd);
        if (listener != null) {
            result.addModifyListener(listener);
        }
        return result;
    }

    public static GridData createGridData() {
        return new GridData(4, 128, true, false);
    }
}

