/*
 * Decompiled with CFR 0.152.
 */
package cucumber.eclipse.steps.integration.marker;

import cucumber.eclipse.steps.integration.Activator;
import cucumber.eclipse.steps.integration.GherkinStepWrapper;
import cucumber.eclipse.steps.integration.Glue;
import cucumber.eclipse.steps.integration.StepDefinition;
import cucumber.eclipse.steps.integration.i18n.CucumberStepsIntegrationMessages;
import gherkin.formatter.model.Step;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;

public class MarkerFactory {
    public static final MarkerFactory INSTANCE = new MarkerFactory();
    public static final String CUCUMBER_MARKER = "cucumber.eclipse.marker";
    public static final String STEPDEF_SYNTAX_ERROR = "cucumber.eclipse.marker.stepdef.syntaxerror";
    public static final String GHERKIN_SYNTAX_ERROR = "cucumber.eclipse.marker.gherkin.syntaxerror";
    public static final String STEP_DEFINTION_MATCH = "cucumber.eclipse.marker.stepdef.matches";
    public static final String STEP_DEFINITION_MATCH_PATH_ATTRIBUTE = "cucumber.eclipse.marker.stepdef.matches.path";
    public static final String STEP_DEFINITION_MATCH_JDT_HANDLE_IDENTIFIER_ATTRIBUTE = "cucumber.eclipse.marker.stepdef.matches.jdt_handler_identifier";
    public static final String STEP_DEFINITION_MATCH_LINE_NUMBER_ATTRIBUTE = "cucumber.eclipse.marker.stepdef.matches.line_number";
    public static final String STEP_DEFINITION_MATCH_TEXT_ATTRIBUTE = "cucumber.eclipse.marker.stepdef.matches.text";
    public static final String SCENARIO_OUTLINE_EXAMPLE_UNMATCH = "cucumber.eclipse.marker.scenario_outline_example_unmatch";
    public static final String MULTIPLE_STEP_DEFINTIONS_MATCH = "cucumber.eclipse.marker.stepdef.multiple_matches";
    public static final String UNMATCHED_STEP = "cucumber.eclipse.marker.gherkin.unmatched_step";
    public static final String UNMATCHED_STEP_KEYWORD_ATTRIBUTE = "cucumber.eclipse.marker.gherkin.unmatched_step.keyword";
    public static final String UNMATCHED_STEP_NAME_ATTRIBUTE = "cucumber.eclipse.marker.gherkin.unmatched_step.name";
    public static final String UNMATCHED_STEP_PATH_ATTRIBUTE = "cucumber.eclipse.marker.gherkin.unmatched_step.path";
    public static final String NOT_A_CUCUMBER_PROJECT = "cucumber.eclipse.marker.not_a_cucumber_project";
    public static final String NOT_A_CUCUMBER_PROJECT_NAME_ATTRIBUTE = "cucumber.eclipse.marker.not_a_cucumber_project.project_name";
    public static final String CUCUMBER_NATURE_MISSING_MARKER = "cucumber.eclipse.marker.project.cucumber_nature_missing";

    private MarkerFactory() {
    }

    public void syntaxErrorOnStepDefinition(IResource stepDefinitionResource, Exception e) {
        this.syntaxErrorOnStepDefinition(stepDefinitionResource, e, 0);
    }

    public void unmatchedStep(final IDocument gherkinDocument, GherkinStepWrapper gherkinStepWrapper) {
        final IResource gherkinFile = gherkinStepWrapper.getSource();
        final Step gherkinStep = gherkinStepWrapper.getStep();
        final int lineNumber = gherkinStep.getLine();
        this.mark(gherkinFile, new IMarkerBuilder(){

            @Override
            public IMarker build() throws CoreException {
                IMarker marker = null;
                String warningMessage = String.format("Step '%s' does not have a matching glue code%s", gherkinStep.getName(), "");
                int lineStartOffset = 0;
                IRegion lineInfo = null;
                String currentLine = null;
                try {
                    lineInfo = gherkinDocument.getLineInformation(lineNumber - 1);
                    lineStartOffset = lineInfo.getOffset();
                    currentLine = gherkinDocument.get(lineStartOffset, lineInfo.getLength());
                }
                catch (BadLocationException badLocationException) {
                    return null;
                }
                String textStatement = gherkinStep.getName();
                int statementStartOffset = lineStartOffset + currentLine.indexOf(textStatement);
                Region stepRegion = new Region(statementStartOffset, textStatement.length());
                marker = gherkinFile.createMarker(MarkerFactory.UNMATCHED_STEP);
                marker.setAttribute("severity", 1);
                marker.setAttribute("message", (Object)warningMessage);
                marker.setAttribute("lineNumber", lineNumber);
                marker.setAttribute("charStart", stepRegion.getOffset());
                marker.setAttribute("charEnd", stepRegion.getOffset() + stepRegion.getLength());
                marker.setAttribute(MarkerFactory.UNMATCHED_STEP_KEYWORD_ATTRIBUTE, (Object)gherkinStep.getKeyword());
                marker.setAttribute(MarkerFactory.UNMATCHED_STEP_NAME_ATTRIBUTE, (Object)gherkinStep.getName());
                marker.setAttribute(MarkerFactory.UNMATCHED_STEP_PATH_ATTRIBUTE, (Object)gherkinFile.getFullPath().toString());
                return marker;
            }
        });
    }

    public void syntaxErrorOnStepDefinition(final IResource stepDefinitionResource, final Exception e, final int lineNumber) {
        this.mark(stepDefinitionResource, new IMarkerBuilder(){

            @Override
            public IMarker build() throws CoreException {
                IMarker marker = stepDefinitionResource.createMarker(MarkerFactory.STEPDEF_SYNTAX_ERROR);
                marker.setAttribute("severity", 2);
                marker.setAttribute("message", (Object)e.getMessage());
                marker.setAttribute("lineNumber", lineNumber);
                return marker;
            }
        });
    }

    public void syntaxErrorOnGherkin(IResource stepDefinitionResource, Exception e) {
        this.syntaxErrorOnGherkin(stepDefinitionResource, e, 0);
    }

    public void syntaxErrorOnGherkin(IResource gherkinResource, Exception e, int lineNumber) {
        this.syntaxErrorOnGherkin(gherkinResource, e.getMessage(), lineNumber);
    }

    public void syntaxErrorOnGherkin(final IResource gherkinResource, final String msg, final int lineNumber) {
        this.mark(gherkinResource, new IMarkerBuilder(){

            @Override
            public IMarker build() throws CoreException {
                IMarker marker = null;
                marker = gherkinResource.createMarker(MarkerFactory.GHERKIN_SYNTAX_ERROR);
                marker.setAttribute("severity", 2);
                marker.setAttribute("message", (Object)msg);
                marker.setAttribute("lineNumber", lineNumber);
                return marker;
            }
        });
    }

    public void glueFound(Glue glue) {
        Step step = glue.getGherkinStepWrapper().getStep();
        this.glueFound(glue, step.getName(), step.getLine());
    }

    public void glueFound(Glue glue, final String stepDefinitionText, final int lineNumber) {
        final IResource gherkinResource = glue.getGherkinStepWrapper().getSource();
        final StepDefinition stepDefinition = glue.getStepDefinition();
        this.mark(gherkinResource, new IMarkerBuilder(){

            @Override
            public IMarker build() throws CoreException {
                IMarker marker = null;
                marker = gherkinResource.createMarker(MarkerFactory.STEP_DEFINTION_MATCH);
                marker.setAttribute("severity", 0);
                String message = String.format("Glued with %s", stepDefinition.getLabel());
                marker.setAttribute("message", (Object)message);
                marker.setAttribute("lineNumber", lineNumber);
                if (stepDefinition.getSource() != null) {
                    marker.setAttribute(MarkerFactory.STEP_DEFINITION_MATCH_PATH_ATTRIBUTE, (Object)stepDefinition.getSource().getFullPath().toString());
                }
                marker.setAttribute(MarkerFactory.STEP_DEFINITION_MATCH_JDT_HANDLE_IDENTIFIER_ATTRIBUTE, (Object)stepDefinition.getId());
                marker.setAttribute(MarkerFactory.STEP_DEFINITION_MATCH_LINE_NUMBER_ATTRIBUTE, stepDefinition.getLineNumber());
                marker.setAttribute(MarkerFactory.STEP_DEFINITION_MATCH_TEXT_ATTRIBUTE, (Object)stepDefinitionText);
                return marker;
            }
        });
    }

    public void gherkinStepExampleUnmatch(final IDocument gherkinDocument, final IResource gherkinResource, final int lineNumber) {
        this.mark(gherkinResource, new IMarkerBuilder(){

            @Override
            public IMarker build() throws CoreException {
                IMarker marker = null;
                int lineStartOffset = 0;
                IRegion lineInfo = null;
                String currentLine = null;
                try {
                    lineInfo = gherkinDocument.getLineInformation(lineNumber - 1);
                    lineStartOffset = lineInfo.getOffset();
                    currentLine = gherkinDocument.get(lineStartOffset, lineInfo.getLength());
                }
                catch (BadLocationException badLocationException) {
                    return null;
                }
                String currentLineTrim = currentLine.trim();
                int statementStartOffset = lineStartOffset + currentLine.indexOf(currentLineTrim);
                Region stepRegion = new Region(statementStartOffset, currentLineTrim.length());
                marker = gherkinResource.createMarker(MarkerFactory.SCENARIO_OUTLINE_EXAMPLE_UNMATCH);
                marker.setAttribute("severity", 1);
                marker.setAttribute("message", (Object)String.format("No compatible step definition with %s", currentLineTrim));
                marker.setAttribute("lineNumber", lineNumber);
                marker.setAttribute("charStart", stepRegion.getOffset());
                marker.setAttribute("charEnd", stepRegion.getOffset() + stepRegion.getLength());
                return marker;
            }
        });
    }

    public void featureFileIsNotInCucumberProject(final IFile project) {
        this.mark((IResource)project, new IMarkerBuilder(){

            @Override
            public IMarker build() throws CoreException {
                IMarker marker = null;
                project.deleteMarkers(MarkerFactory.NOT_A_CUCUMBER_PROJECT, true, 0);
                marker = project.createMarker(MarkerFactory.NOT_A_CUCUMBER_PROJECT);
                marker.setAttribute("severity", 1);
                marker.setAttribute("message", (Object)CucumberStepsIntegrationMessages.MarkerFactory__Step_definitions_detection_not_working_on_non_cucumber_project);
                marker.setAttribute("lineNumber", 1);
                marker.setAttribute(MarkerFactory.NOT_A_CUCUMBER_PROJECT_NAME_ATTRIBUTE, (Object)project.getName());
                return marker;
            }
        });
    }

    public void cleanMarkers(IResource resource) {
        try {
            resource.deleteMarkers(CUCUMBER_MARKER, true, 0);
        }
        catch (CoreException e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "cucumber.eclipse.steps.integration", String.format("Couldn't remove markers from %s", resource), (Throwable)e));
        }
    }

    public void cleanMarkersRecursively(IResource resource) {
        try {
            resource.deleteMarkers(CUCUMBER_MARKER, true, 2);
        }
        catch (CoreException e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "cucumber.eclipse.steps.integration", String.format("Couldn't remove markers from %s", resource), (Throwable)e));
        }
    }

    private void mark(IResource resource, final IMarkerBuilder markerBuilder) {
        try {
            IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    markerBuilder.build();
                }
            };
            resource.getWorkspace().run(runnable, null, 1, null);
        }
        catch (CoreException e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "cucumber.eclipse.steps.integration", String.format("Failed to place marker %s", resource), (Throwable)e));
        }
    }

    public void cleanCucumberNatureMissing(IProject project) throws CoreException {
        IMarker[] markers;
        IMarker[] iMarkerArray = markers = project.findMarkers(CUCUMBER_NATURE_MISSING_MARKER, false, 0);
        int n = markers.length;
        int n2 = 0;
        while (n2 < n) {
            IMarker marker = iMarkerArray[n2];
            marker.delete();
            ++n2;
        }
    }

    private static interface IMarkerBuilder {
        public IMarker build() throws CoreException;
    }
}

