/*
 * Decompiled with CFR 0.152.
 */
package cucumber.eclipse.steps.jdt;

import cucumber.eclipse.steps.integration.IStepDefinitionOpener;
import cucumber.eclipse.steps.integration.StepDefinition;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.ui.PartInitException;

public class JavaStepDefinitionOpener
implements IStepDefinitionOpener {
    public void openInEditor(StepDefinition stepDefinition) throws CoreException {
        if (this.canOpen(stepDefinition)) {
            try {
                this.showMethod(this.getMember(stepDefinition));
            }
            catch (PartInitException e) {
                throw new CoreException((IStatus)new Status(4, "cucumber.eclipse.steps.jdt", e.getMessage(), (Throwable)e));
            }
            catch (JavaModelException e) {
                throw new CoreException((IStatus)new Status(4, "cucumber.eclipse.steps.jdt", e.getMessage(), (Throwable)e));
            }
        }
    }

    public boolean canOpen(StepDefinition stepDefinition) {
        IMember member = this.getMember(stepDefinition);
        return member != null;
    }

    private void showMethod(IMember member) throws PartInitException, JavaModelException {
        JavaUI.openInEditor((IJavaElement)member, (boolean)true, (boolean)true);
    }

    private IMember getMember(StepDefinition stepDefinition) {
        String jdtHandleIdentifier = stepDefinition.getId();
        if (jdtHandleIdentifier == null || jdtHandleIdentifier.isEmpty()) {
            return null;
        }
        IJavaElement element = JavaCore.create((String)jdtHandleIdentifier);
        if (!(element instanceof IMember)) {
            return null;
        }
        return (IMember)element;
    }
}

