/*
 * Decompiled with CFR 0.152.
 */
package cucumber.eclipse.steps.jdt.filter;

import cucumber.eclipse.steps.integration.filter.Filter;
import java.util.ArrayList;
import java.util.regex.Pattern;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IPackageDeclaration;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;

public class CompilationUnitStepDefinitionsPreferencesFilter
implements Filter<ICompilationUnit> {
    private String[] filters;

    public CompilationUnitStepDefinitionsPreferencesFilter(String[] filters) {
        this.filters = filters;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean accept(ICompilationUnit element) {
        try {
            IType[] types;
            IPackageDeclaration packageDeclaration = element.getPackageDeclarations()[0];
            String packageName = packageDeclaration.getElementName();
            if (packageName == null) {
                packageName = "";
            }
            ArrayList<String> typesNames = new ArrayList<String>();
            Object[] objectArray = types = element.getTypes();
            int n = types.length;
            int n2 = 0;
            while (n2 < n) {
                IType type = objectArray[n2];
                typesNames.add(String.valueOf(packageName) + "." + type.getElementName());
                ++n2;
            }
            objectArray = this.filters;
            n = this.filters.length;
            n2 = 0;
            while (n2 < n) {
                IType filter = objectArray[n2];
                if (typesNames.contains(filter)) return true;
                if (Pattern.matches((String)filter, packageName)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
        catch (JavaModelException e) {
            e.printStackTrace();
            return false;
        }
    }
}

