/*
 * Decompiled with CFR 0.152.
 */
package cucumber.eclipse.steps.jdt.ui;

import cucumber.eclipse.steps.jdt.Activator;
import cucumber.eclipse.steps.jdt.ui.CreateStepDefinitionsFilterDialog;
import cucumber.eclipse.steps.jdt.ui.CucumberJavaPreferences;
import cucumber.eclipse.steps.jdt.ui.CucumberJavaUIMessages;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.internal.ui.SWTFactory;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.debug.ui.Filter;
import org.eclipse.jdt.internal.debug.ui.FilterLabelProvider;
import org.eclipse.jdt.internal.debug.ui.FilterViewerComparator;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.dialogs.SelectionDialog;

public class CucumberJavaPreferencesPage
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static final String PAGE_ID = "cucumber.eclipse.editor.steps.jdt.CucumberJavaPreferencesPage";
    private CheckboxTableViewer fTableViewer;
    private Button fUseStepDefinitionsFiltersButton;
    private Button fAddPackageButton;
    private Button fAddTypeButton;
    private Button fRemoveFilterButton;
    private Button fAddFilterButton;
    private Button fSelectAllButton;
    private Button fDeselectAllButton;

    public CucumberJavaPreferencesPage() {
        this.setPreferenceStore(Activator.getDefault().getPreferenceStore());
        this.setTitle(CucumberJavaUIMessages.CucumberJavaPreferencesPage__title);
        this.setDescription(CucumberJavaUIMessages.CucumberJavaPreferencesPage__description);
    }

    protected Control createContents(Composite parent) {
        Composite composite = SWTFactory.createComposite((Composite)parent, (Font)parent.getFont(), (int)1, (int)1, (int)1808, (int)0, (int)0);
        this.createStepFilterPreferences(composite);
        return composite;
    }

    public void init(IWorkbench workbench) {
    }

    private void handleFilterViewerKeyPress(KeyEvent event) {
        if (event.character == '\u007f' && event.stateMask == 0) {
            this.removeFilters();
        }
    }

    private void createStepFilterPreferences(Composite parent) {
        Composite container = SWTFactory.createComposite((Composite)parent, (Font)parent.getFont(), (int)2, (int)1, (int)1808, (int)0, (int)0);
        this.fUseStepDefinitionsFiltersButton = SWTFactory.createCheckButton((Composite)container, (String)CucumberJavaUIMessages.CucumberJavaPreferencesPage__Use_packages_filters, null, (boolean)CucumberJavaPreferences.isUseStepDefinitionsFilters(), (int)2);
        this.fUseStepDefinitionsFiltersButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                CucumberJavaPreferencesPage.this.setPageEnablement(CucumberJavaPreferencesPage.this.fUseStepDefinitionsFiltersButton.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        SWTFactory.createLabel((Composite)container, (String)CucumberJavaUIMessages.CucumberJavaPreferencesPage__Define_step_definitions_filters, (int)2);
        this.fTableViewer = CheckboxTableViewer.newCheckList((Composite)container, (int)68354);
        this.fTableViewer.getTable().setFont(container.getFont());
        this.fTableViewer.setLabelProvider((IBaseLabelProvider)new FilterLabelProvider());
        this.fTableViewer.setComparator((ViewerComparator)new FilterViewerComparator());
        this.fTableViewer.setContentProvider((IContentProvider)new StepDefinitionsFilterContentProvider());
        this.fTableViewer.setInput((Object)this.getAllStoredFilters(false));
        this.fTableViewer.getTable().setLayoutData((Object)new GridData(1808));
        this.fTableViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                ((Filter)event.getElement()).setChecked(event.getChecked());
            }
        });
        this.fTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = event.getSelection();
                if (selection.isEmpty()) {
                    CucumberJavaPreferencesPage.this.fRemoveFilterButton.setEnabled(false);
                } else {
                    CucumberJavaPreferencesPage.this.fRemoveFilterButton.setEnabled(true);
                }
            }
        });
        this.fTableViewer.getControl().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                CucumberJavaPreferencesPage.this.handleFilterViewerKeyPress(event);
            }
        });
        this.createStepFilterButtons(container);
        this.setPageEnablement(this.fUseStepDefinitionsFiltersButton.getSelection());
    }

    private void initTableState(boolean defaults) {
        Filter[] filters = this.getAllStoredFilters(defaults);
        int i = 0;
        while (i < filters.length) {
            this.fTableViewer.add((Object)filters[i]);
            this.fTableViewer.setChecked((Object)filters[i], filters[i].isChecked());
            ++i;
        }
    }

    protected void setPageEnablement(boolean enabled) {
        this.fAddFilterButton.setEnabled(enabled);
        this.fAddPackageButton.setEnabled(enabled);
        this.fAddTypeButton.setEnabled(enabled);
        this.fDeselectAllButton.setEnabled(enabled);
        this.fSelectAllButton.setEnabled(enabled);
        this.fTableViewer.getTable().setEnabled(enabled);
        this.fRemoveFilterButton.setEnabled(enabled & !this.fTableViewer.getSelection().isEmpty());
    }

    private void createStepFilterButtons(Composite container) {
        this.initializeDialogUnits((Control)container);
        Composite buttonContainer = new Composite(container, 0);
        GridData gd = new GridData(1040);
        buttonContainer.setLayoutData((Object)gd);
        GridLayout buttonLayout = new GridLayout();
        buttonLayout.numColumns = 1;
        buttonLayout.marginHeight = 0;
        buttonLayout.marginWidth = 0;
        buttonContainer.setLayout((Layout)buttonLayout);
        this.fAddFilterButton = SWTFactory.createPushButton((Composite)buttonContainer, (String)CucumberJavaUIMessages.CucumberJavaPreferencesPage__Add_filter, (String)CucumberJavaUIMessages.CucumberJavaPreferencesPage__Key_in_the_name_of_a_new_step_filter, null);
        this.fAddFilterButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                CucumberJavaPreferencesPage.this.addFilter();
            }
        });
        this.fAddTypeButton = SWTFactory.createPushButton((Composite)buttonContainer, (String)CucumberJavaUIMessages.CucumberJavaPreferencesPage__Add_Type, (String)CucumberJavaUIMessages.CucumberJavaPreferencesPage__Choose_a_Java_type_and_add_it_to_step_definitions_filters, null);
        this.fAddTypeButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                CucumberJavaPreferencesPage.this.addType();
            }
        });
        this.fAddPackageButton = SWTFactory.createPushButton((Composite)buttonContainer, (String)CucumberJavaUIMessages.CucumberJavaPreferencesPage__Add__Package, (String)CucumberJavaUIMessages.CucumberJavaPreferencesPage__Choose_a_package_and_add_it_to_step_definitions_filters, null);
        this.fAddPackageButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                CucumberJavaPreferencesPage.this.addPackage();
            }
        });
        this.fRemoveFilterButton = SWTFactory.createPushButton((Composite)buttonContainer, (String)CucumberJavaUIMessages.CucumberJavaPreferencesPage___Remove, (String)CucumberJavaUIMessages.CucumberJavaPreferencesPage__Remove_all_selected_step_filters, null);
        this.fRemoveFilterButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                CucumberJavaPreferencesPage.this.removeFilters();
            }
        });
        this.fRemoveFilterButton.setEnabled(false);
        Label separator = new Label(buttonContainer, 0);
        separator.setVisible(false);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 1;
        gd.heightHint = 4;
        separator.setLayoutData((Object)gd);
        this.fSelectAllButton = SWTFactory.createPushButton((Composite)buttonContainer, (String)CucumberJavaUIMessages.CucumberJavaPreferencesPage__Select_All, (String)CucumberJavaUIMessages.CucumberJavaPreferencesPage__Selects_all_step_filters, null);
        this.fSelectAllButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                CucumberJavaPreferencesPage.this.fTableViewer.setAllChecked(true);
            }
        });
        this.fDeselectAllButton = SWTFactory.createPushButton((Composite)buttonContainer, (String)CucumberJavaUIMessages.CucumberJavaPreferencesPage__Deselect_All, (String)CucumberJavaUIMessages.CucumberJavaPreferencesPage__Deselects_all_step_filters, null);
        this.fDeselectAllButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                CucumberJavaPreferencesPage.this.fTableViewer.setAllChecked(false);
            }
        });
    }

    private void addFilter() {
        Filter newfilter = CreateStepDefinitionsFilterDialog.showCreateStepFilterDialog(this.getShell(), this.getAllFiltersFromTable());
        if (newfilter != null) {
            this.fTableViewer.add((Object)newfilter);
            this.fTableViewer.setChecked((Object)newfilter, true);
            this.fTableViewer.refresh((Object)newfilter);
        }
    }

    private void addType() {
        try {
            Object[] types;
            SelectionDialog dialog = JavaUI.createTypeDialog((Shell)this.getShell(), (IRunnableContext)PlatformUI.getWorkbench().getProgressService(), (IJavaSearchScope)SearchEngine.createWorkspaceScope(), (int)2, (boolean)false);
            dialog.setTitle(CucumberJavaUIMessages.CucumberJavaPreferencesPage__Add_type_to_step_filters);
            dialog.setMessage(CucumberJavaUIMessages.CucumberJavaPreferencesPage__Select_a_type_to_filter_when_stepping);
            if (dialog.open() == 0 && (types = dialog.getResult()) != null && types.length > 0) {
                IType type = (IType)types[0];
                this.addFilter(type.getFullyQualifiedName(), true);
            }
        }
        catch (JavaModelException jme) {
            ExceptionHandler.handle((CoreException)((Object)jme), (String)CucumberJavaUIMessages.CucumberJavaPreferencesPage__Add_type_to_step_filters, (String)CucumberJavaUIMessages.CucumberJavaPreferencesPage__Could_not_open_type_selection_dialog_for_step_filters);
        }
    }

    private void addPackage() {
        try {
            Object[] packages;
            ElementListSelectionDialog dialog = JDIDebugUIPlugin.createAllPackagesDialog((Shell)this.getShell(), null, (boolean)false);
            dialog.setTitle(CucumberJavaUIMessages.CucumberJavaPreferencesPage__Add_package_to_step_filters);
            dialog.setMessage(CucumberJavaUIMessages.CucumberJavaPreferencesPage__Select_a_package_to_filter_when_stepping);
            dialog.setMultipleSelection(true);
            if (dialog.open() == 0 && (packages = dialog.getResult()) != null) {
                IJavaElement pkg = null;
                int i = 0;
                while (i < packages.length) {
                    pkg = (IJavaElement)packages[i];
                    String filter = String.valueOf(pkg.getElementName()) + ".*";
                    this.addFilter(filter, true);
                    ++i;
                }
            }
        }
        catch (JavaModelException jme) {
            ExceptionHandler.handle((CoreException)((Object)jme), (String)CucumberJavaUIMessages.CucumberJavaPreferencesPage__Add_package_to_step_filters, (String)CucumberJavaUIMessages.CucumberJavaPreferencesPage__Could_not_open_package_selection_dialog_for_step_filters);
        }
    }

    protected void removeFilters() {
        this.fTableViewer.remove(((IStructuredSelection)this.fTableViewer.getSelection()).toArray());
    }

    public boolean performOk() {
        IPreferenceStore store = this.getPreferenceStore();
        store.setValue("cucumber.eclipse.steps.jdt.use_step_definitions_filters", this.fUseStepDefinitionsFiltersButton.getSelection());
        ArrayList<String> active = new ArrayList<String>();
        ArrayList<String> inactive = new ArrayList<String>();
        String name = "";
        Filter[] filters = this.getAllFiltersFromTable();
        int i = 0;
        while (i < filters.length) {
            name = filters[i].getName();
            if (filters[i].isChecked()) {
                active.add(name);
            } else {
                inactive.add(name);
            }
            ++i;
        }
        String pref = CucumberJavaPreferences.serializeList(active.toArray(new String[active.size()]));
        store.setValue("cucumber.eclipse.steps.jdt.active_filters", pref);
        pref = CucumberJavaPreferences.serializeList(inactive.toArray(new String[inactive.size()]));
        store.setValue("cucumber.eclipse.steps.jdt.inactive_filters", pref);
        return super.performOk();
    }

    protected void performDefaults() {
        boolean stepenabled = CucumberJavaPreferences.isUseStepDefinitionsFilters();
        this.fUseStepDefinitionsFiltersButton.setSelection(stepenabled);
        this.setPageEnablement(stepenabled);
        this.fTableViewer.getTable().removeAll();
        this.initTableState(true);
        super.performDefaults();
    }

    protected void addFilter(String filter, boolean checked) {
        if (filter != null) {
            Filter f = new Filter(filter, checked);
            this.fTableViewer.add((Object)f);
            this.fTableViewer.setChecked((Object)f, checked);
        }
    }

    protected Filter[] getAllFiltersFromTable() {
        TableItem[] items = this.fTableViewer.getTable().getItems();
        Filter[] filters = new Filter[items.length];
        int i = 0;
        while (i < items.length) {
            filters[i] = (Filter)items[i].getData();
            filters[i].setChecked(items[i].getChecked());
            ++i;
        }
        return filters;
    }

    protected Filter[] getAllStoredFilters(boolean defaults) {
        String[] inactivefilters;
        String[] activefilters;
        Filter[] filters = null;
        IPreferenceStore store = this.getPreferenceStore();
        if (defaults) {
            activefilters = CucumberJavaPreferences.parseList(store.getDefaultString("cucumber.eclipse.steps.jdt.active_filters"));
            inactivefilters = CucumberJavaPreferences.parseList(store.getDefaultString("cucumber.eclipse.steps.jdt.inactive_filters"));
        } else {
            activefilters = CucumberJavaPreferences.parseList(store.getString("cucumber.eclipse.steps.jdt.active_filters"));
            inactivefilters = CucumberJavaPreferences.parseList(store.getString("cucumber.eclipse.steps.jdt.inactive_filters"));
        }
        filters = new Filter[activefilters.length + inactivefilters.length];
        int i = 0;
        while (i < activefilters.length) {
            filters[i] = new Filter(activefilters[i], true);
            ++i;
        }
        i = 0;
        while (i < inactivefilters.length) {
            filters[i + activefilters.length] = new Filter(inactivefilters[i], false);
            ++i;
        }
        return filters;
    }

    class StepDefinitionsFilterContentProvider
    implements IStructuredContentProvider {
        public StepDefinitionsFilterContentProvider() {
            CucumberJavaPreferencesPage.this.initTableState(false);
        }

        public Object[] getElements(Object inputElement) {
            return CucumberJavaPreferencesPage.this.getAllFiltersFromTable();
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }
    }
}

