/*
 * Decompiled with CFR 0.152.
 */
package de.anbos.eclipse.logviewer.plugin;

import de.anbos.eclipse.logviewer.plugin.LogFile;
import de.anbos.eclipse.logviewer.plugin.LogFileTab;
import de.anbos.eclipse.logviewer.plugin.LogViewerConsole;
import de.anbos.eclipse.logviewer.plugin.LogViewerPlugin;
import de.anbos.eclipse.logviewer.plugin.Logger;
import de.anbos.eclipse.logviewer.plugin.action.ClearHistoryAction;
import de.anbos.eclipse.logviewer.plugin.action.CloseAllFilesViewAction;
import de.anbos.eclipse.logviewer.plugin.action.FileCloseViewAction;
import de.anbos.eclipse.logviewer.plugin.action.FileEncondingViewAction;
import de.anbos.eclipse.logviewer.plugin.action.FileOpenViewAction;
import de.anbos.eclipse.logviewer.plugin.action.PreferencesViewAction;
import de.anbos.eclipse.logviewer.plugin.action.RefreshCurrentFileViewAction;
import de.anbos.eclipse.logviewer.plugin.action.StartTailOnAllFileViewAction;
import de.anbos.eclipse.logviewer.plugin.action.StartTailOnCurrentFileViewAction;
import de.anbos.eclipse.logviewer.plugin.action.StopTailOnAllFileViewAction;
import de.anbos.eclipse.logviewer.plugin.action.StopTailOnCurrentFileViewAction;
import de.anbos.eclipse.logviewer.plugin.action.TabRenameAction;
import de.anbos.eclipse.logviewer.plugin.action.delegate.FileOpenViewActionDelegate;
import de.anbos.eclipse.logviewer.plugin.file.document.LogDocument;
import de.anbos.eclipse.logviewer.plugin.preferences.FileHistoryTracker;
import de.anbos.eclipse.logviewer.plugin.preferences.PreferenceValueConverter;
import de.anbos.eclipse.logviewer.plugin.ui.menu.LocalPullDownMenu;
import de.anbos.eclipse.logviewer.plugin.viewer.LogFileViewer;
import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IFindReplaceTarget;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IOConsole;
import org.eclipse.ui.console.IOConsoleOutputStream;
import org.eclipse.ui.part.ViewPart;

public class LogViewer
extends ViewPart {
    private Logger logger = LogViewerPlugin.getDefault().getLogger();
    private Composite parent;
    private LogViewerConsole console = null;
    private boolean stopAfterChange = false;
    private TabFolder tabfolder;
    private LogFileViewer viewer;
    private Map<String, LogFileTab> logTab = new Hashtable<String, LogFileTab>();
    private TabItem oldTabItem = null;
    private ViewDocumentListener documentListener;
    private FileOpenViewAction fileOpenAction;
    private ClearHistoryAction clearHistoryAction;
    private PreferencesViewAction preferencesAction;
    private FileCloseViewAction fileCloseAction;
    private CloseAllFilesViewAction closeAllFilesAction;
    private RefreshCurrentFileViewAction refreshCurrentFileAction;
    private StartTailOnCurrentFileViewAction startTailOnCurrentFile;
    private StopTailOnCurrentFileViewAction stopTailOnCurrentFile;
    private StartTailOnAllFileViewAction startTailOnAllFiles;
    private StopTailOnAllFileViewAction stopTailOnAllFiles;
    private FileEncondingViewAction fileEncodingAction;
    private TabRenameAction tabRenameAction;
    private int monitorCounter;
    private int monitorCounterMax;

    public LogViewer() {
        this.resetMonitorCounter();
    }

    public void createPartControl(Composite parent) {
        this.parent = parent;
        this.documentListener = new ViewDocumentListener();
        this.tabfolder = new TabFolder(parent, 0);
        this.tabfolder.addSelectionListener((SelectionListener)new TabSelectionListener());
        this.viewer = new LogFileViewer((Composite)this.tabfolder, 770);
        DropTarget target = new DropTarget((Control)parent, 7);
        target.setTransfer(new Transfer[]{FileTransfer.getInstance(), TextTransfer.getInstance()});
        target.addDropListener((DropTargetListener)new DropTargetAdapter(){

            public void dragEnter(DropTargetEvent e) {
                if (e.detail == 0) {
                    e.detail = 1;
                }
            }

            public void drop(DropTargetEvent event) {
                if (event.data == null || ((String[])event.data).length < 1) {
                    event.detail = 0;
                    return;
                }
                if (!LogViewer.this.checkAndOpenFile(LogFile.LogFileType.LOGFILE_SYSTEM_FILE, ((String[])event.data)[0], false)) {
                    event.detail = 0;
                }
            }
        });
        this.makeActions();
        this.hookContextMenu();
        this.contributeToActionBars();
        this.openAllLastOpenFiles();
    }

    public void closeCurrentLogFile() {
        try {
            LogFileTab tab = this.getSelectedTab();
            this.removeMonitorCounter(tab.getDocument().isMonitor());
            tab.close();
            this.logTab.remove(tab.getKey());
        }
        catch (IOException iOException) {
            this.logger.logError("unable to remove the current; active tab");
        }
        int index = this.tabfolder.getSelectionIndex();
        this.getSelectedItem().dispose();
        if (!this.greyAllOutIfNoFiles()) {
            if (index == 0) {
                this.tabfolder.setSelection(0);
            } else {
                this.tabfolder.setSelection(index - 1);
            }
        }
    }

    public void closeAllLogFiles() {
        for (String key : this.logTab.keySet()) {
            LogFileTab tab = this.logTab.get(key);
            try {
                tab.close();
                tab.getItem().dispose();
            }
            catch (IOException iOException) {
                this.logger.logError("unable to remove tab: " + tab.getDocument().getFile().getFileName());
            }
        }
        this.logTab.clear();
        this.greyAllOutIfNoFiles();
    }

    public void refreshCurrentLogFile() {
        try {
            boolean wasMonitor = this.getSelectedTab().getDocument().isMonitor();
            if (!wasMonitor) {
                this.stopAfterChange = true;
            }
            this.getSelectedTab().getDocument().synchronize();
        }
        catch (Exception e) {
            this.logger.logError("unable to refresh the current tab's content", e);
        }
    }

    public void startTailOnAllDocuments() {
        for (String key : this.logTab.keySet()) {
            LogFileTab tab = this.logTab.get(key);
            tab.getDocument().setMonitor(true);
        }
        this.setMonitorCounterToMax();
        this.updateTailStartStopButtons(true);
    }

    public void stopTailOnAllDocuments() {
        for (String key : this.logTab.keySet()) {
            LogFileTab tab = this.logTab.get(key);
            tab.getDocument().setMonitor(false);
        }
        this.setMonitorCounterToMin();
        this.updateTailStartStopButtons(false);
    }

    public void startTail() {
        try {
            this.getSelectedTab().getDocument().setMonitor(true);
            this.increaseMonitorCounter();
            this.updateTailStartStopButtons(true);
        }
        catch (Exception e) {
            this.logger.logError("unable to start tailing", e);
        }
    }

    public void stopTail() {
        try {
            this.getSelectedTab().getDocument().setMonitor(false);
            this.decreaseMonitorCounter();
            this.updateTailStartStopButtons(false);
        }
        catch (Exception e) {
            this.logger.logError("unable to stop tailing", e);
        }
    }

    boolean greyAllOutIfNoFiles() {
        if (this.tabfolder.getItemCount() == 0) {
            this.fileCloseAction.setEnabled(false);
            this.closeAllFilesAction.setEnabled(false);
            this.refreshCurrentFileAction.setEnabled(false);
            this.fileEncodingAction.setEnabled(false);
            this.startTailOnCurrentFile.setEnabled(false);
            this.stopTailOnCurrentFile.setEnabled(false);
            this.startTailOnAllFiles.setEnabled(false);
            this.stopTailOnAllFiles.setEnabled(false);
            this.tabRenameAction.setEnabled(false);
            this.resetMonitorCounter();
            return true;
        }
        return false;
    }

    void updateTailStartStopButtons(boolean monitor) {
        this.stopTailOnCurrentFile.setEnabled(monitor);
        this.startTailOnCurrentFile.setEnabled(!monitor);
        if (this.monitorCounter == 0) {
            this.startTailOnAllFiles.setEnabled(true);
            this.stopTailOnAllFiles.setEnabled(false);
        } else if (this.monitorCounter == this.monitorCounterMax) {
            this.startTailOnAllFiles.setEnabled(false);
            this.stopTailOnAllFiles.setEnabled(true);
        } else {
            this.startTailOnAllFiles.setEnabled(true);
            this.stopTailOnAllFiles.setEnabled(true);
        }
    }

    public boolean hasLogFile(LogFile file) {
        if (file == null) {
            return false;
        }
        return this.logTab.containsKey(file.getFileName());
    }

    void increaseMonitorCounter() {
        if (this.monitorCounter < this.monitorCounterMax) {
            ++this.monitorCounter;
        }
    }

    void decreaseMonitorCounter() {
        if (this.monitorCounter > 0) {
            --this.monitorCounter;
        }
    }

    void setMonitorCounterToMax() {
        this.monitorCounter = this.monitorCounterMax;
    }

    void setMonitorCounterToMin() {
        this.monitorCounter = 0;
    }

    void resetMonitorCounter() {
        this.monitorCounter = 0;
        this.monitorCounterMax = 0;
    }

    void removeMonitorCounter(boolean monitor) {
        if (this.monitorCounterMax > 0) {
            --this.monitorCounterMax;
        }
        if (monitor) {
            this.decreaseMonitorCounter();
        }
    }

    void addMonitorCounter(boolean monitor) {
        ++this.monitorCounterMax;
        if (monitor) {
            this.increaseMonitorCounter();
        }
    }

    public boolean checkAndOpenFile(LogFile.LogFileType type, String fullPath, boolean fromAction) {
        File file = new File(fullPath);
        if (!fromAction && file.isDirectory()) {
            FileOpenViewActionDelegate action = new FileOpenViewActionDelegate();
            action.setParentPath(fullPath);
            action.run(this, this.getSite().getShell());
            return action.isFileOpened();
        }
        LogFile logFile = new LogFile(type, fullPath, null, null, true);
        if (!this.hasLogFile(logFile)) {
            FileHistoryTracker.getInstance().storeFile(type, fullPath);
        }
        this.openLogFile(logFile);
        return true;
    }

    public void openLogFile(LogFile file) {
        String key = file.getFileName();
        if (!this.logTab.containsKey(key)) {
            try {
                if (file.getTabName().equals(LogViewerPlugin.getResourceString("logviewer.plugin.console.name"))) {
                    this.createConsole();
                }
                String encoding = LogViewerPlugin.getDefault().getPreferenceStore().getString("ENCODING");
                LogDocument document = new LogDocument(file, encoding);
                TabItem item = new TabItem(this.tabfolder, 0);
                item.setControl(this.viewer.getControl());
                item.setText(file.getTabName());
                item.setToolTipText(file.getFileName());
                this.logTab.put(key, new LogFileTab(key, item, document));
                document.addDocumentListener(this.documentListener);
                boolean monitorState = file.getMonitor();
                document.setMonitor(monitorState);
                this.addMonitorCounter(monitorState);
                this.updateTailStartStopButtons(monitorState);
                this.refreshCurrentFileAction.setEnabled(true);
                this.fileEncodingAction.setEnabled(true);
                this.fileCloseAction.setEnabled(true);
                this.closeAllFilesAction.setEnabled(true);
                this.tabRenameAction.setEnabled(true);
                this.startTailOnAllFiles.setEnabled(true);
                this.stopTailOnAllFiles.setEnabled(true);
            }
            catch (Exception e) {
                this.logger.logError("unable to open the selected logfile", e);
                LogViewerPlugin.getDefault().showErrorMessage(LogViewerPlugin.getResourceString("main.error.open.file", new String[]{file.getFileName()}));
                return;
            }
        }
        LogFileTab tab = this.logTab.get(key);
        try {
            this.showDocument(tab.getDocument(), null, 0, true);
            this.tabfolder.setSelection(new TabItem[]{tab.getItem()});
            this.oldTabItem = tab.getItem();
            Event event = new Event();
            event.item = tab.getItem();
            this.tabfolder.notifyListeners(13, event);
        }
        catch (Exception e) {
            this.logger.logError("showing the document has lead to the following exception", e);
        }
        if (!file.getMonitor()) {
            this.refreshCurrentLogFile();
        }
    }

    public boolean isAvailable() {
        return this.viewer != null && this.viewer.getControl() != null && !this.viewer.getControl().isDisposed();
    }

    public void setFocus() {
        this.tabfolder.setFocus();
    }

    public LogDocument getCurrentDocument() {
        return this.getSelectedTab().getDocument();
    }

    public LogFileViewer getViewer() {
        return this.viewer;
    }

    public Object getAdapter(Class adapter) {
        Object object = super.getAdapter(adapter);
        if (object != null) {
            return object;
        }
        if (adapter.equals(IFindReplaceTarget.class)) {
            return this.viewer.getActualViewer().getFindReplaceTarget();
        }
        return null;
    }

    public String getCurrentLogFileTabName() {
        return this.getSelectedTab().getItem().getText();
    }

    public void setCurrentLogFileTabName(String name) {
        this.getSelectedTab().getItem().setText(name);
        this.getSelectedTab().getDocument().getFile().setTabName(name);
    }

    public void dispose() {
        this.storeAllCurrentlyOpenFiles();
        super.dispose();
    }

    public IOConsoleOutputStream getConsoleStream() {
        if (this.console == null) {
            this.createConsole();
        }
        return this.console.getOutStream();
    }

    public IOConsole getConsole() {
        if (this.console == null) {
            this.createConsole();
        }
        return this.console;
    }

    public void printDefaultMessage() {
        if (this.getConsole().getDocument().get().length() == 0) {
            try {
                this.getConsoleStream().write("Paste messages into this console and check rules and filters in Log Viewer.\n");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void hookContextMenu() {
        MenuManager manager = new MenuManager();
        manager.setRemoveAllWhenShown(true);
        manager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                LogViewer.this.fillContextMenu(manager);
            }
        });
        Menu menu = manager.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(manager, null);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        LocalPullDownMenu menu = new LocalPullDownMenu(manager, this, this.parent.getShell());
        menu.addAction((IAction)this.fileOpenAction);
        menu.addFilelist();
        menu.addAction((IAction)this.clearHistoryAction);
        menu.addSeparator();
        menu.addAction((IAction)this.refreshCurrentFileAction);
        menu.addAction((IAction)this.startTailOnCurrentFile);
        menu.addAction((IAction)this.stopTailOnCurrentFile);
        menu.addAction((IAction)this.fileCloseAction);
        menu.addSeparator();
        menu.addAction((IAction)this.fileEncodingAction);
        menu.addAction((IAction)this.tabRenameAction);
        menu.addSeparator();
        menu.addAction((IAction)this.startTailOnAllFiles);
        menu.addAction((IAction)this.stopTailOnAllFiles);
        menu.addAction((IAction)this.closeAllFilesAction);
        menu.addSeparator();
        menu.addAction((IAction)this.preferencesAction);
        menu.addSeparator();
        menu.finalize();
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.refreshCurrentFileAction);
        manager.add((IAction)this.startTailOnCurrentFile);
        manager.add((IAction)this.stopTailOnCurrentFile);
        manager.add((IAction)this.fileCloseAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.fileEncodingAction);
        manager.add((IAction)this.tabRenameAction);
        manager.add((IContributionItem)new Separator("additions"));
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.fileOpenAction);
        manager.add((IAction)this.preferencesAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.refreshCurrentFileAction);
        manager.add((IAction)this.startTailOnCurrentFile);
        manager.add((IAction)this.stopTailOnCurrentFile);
        manager.add((IAction)this.fileCloseAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.startTailOnAllFiles);
        manager.add((IAction)this.stopTailOnAllFiles);
        manager.add((IAction)this.closeAllFilesAction);
        manager.add((IContributionItem)new Separator("additions"));
    }

    protected void showDocument(LogDocument document, ISelection sel, int index, boolean monitor) {
        this.viewer.setDocument((IDocument)document);
        if (monitor) {
            this.viewer.showTopOrBottomOfFile();
        } else {
            this.viewer.setSelection(sel);
            if (this.viewer.isShowTopOfFile()) {
                this.viewer.showTopOrBottomOfFile();
            } else {
                this.viewer.setTopIndex(index);
            }
        }
    }

    private LogFileTab getSelectedTab(TabItem item) {
        if (item != null) {
            for (LogFileTab logTab : this.logTab.values()) {
                if (logTab.getItem() != item) continue;
                return logTab;
            }
        }
        return null;
    }

    private LogFileTab getSelectedTab() {
        TabItem item = this.getSelectedItem();
        return this.getSelectedTab(item);
    }

    private TabItem getSelectedItem() {
        TabItem[] items = this.tabfolder.getSelection();
        if (items.length > 0) {
            return items[0];
        }
        return null;
    }

    private void makeActions() {
        this.fileOpenAction = new FileOpenViewAction(this, this.parent.getShell());
        this.fileOpenAction.setEnabled(true);
        this.clearHistoryAction = new ClearHistoryAction(this, this.parent.getShell());
        this.clearHistoryAction.setEnabled(true);
        this.preferencesAction = new PreferencesViewAction(this, this.parent.getShell());
        this.preferencesAction.setEnabled(true);
        this.fileCloseAction = new FileCloseViewAction(this, this.parent.getShell());
        this.fileCloseAction.setEnabled(false);
        this.closeAllFilesAction = new CloseAllFilesViewAction(this, this.parent.getShell());
        this.closeAllFilesAction.setEnabled(false);
        this.refreshCurrentFileAction = new RefreshCurrentFileViewAction(this, this.parent.getShell());
        this.refreshCurrentFileAction.setEnabled(false);
        this.startTailOnCurrentFile = new StartTailOnCurrentFileViewAction(this, this.parent.getShell());
        this.startTailOnCurrentFile.setEnabled(false);
        this.stopTailOnCurrentFile = new StopTailOnCurrentFileViewAction(this, this.parent.getShell());
        this.stopTailOnCurrentFile.setEnabled(false);
        this.startTailOnAllFiles = new StartTailOnAllFileViewAction(this, this.parent.getShell());
        this.startTailOnAllFiles.setEnabled(false);
        this.stopTailOnAllFiles = new StopTailOnAllFileViewAction(this, this.parent.getShell());
        this.stopTailOnAllFiles.setEnabled(false);
        this.fileEncodingAction = new FileEncondingViewAction(this, this.parent.getShell());
        this.fileEncodingAction.setEnabled(false);
        this.tabRenameAction = new TabRenameAction(this, this.parent.getShell());
        this.tabRenameAction.setEnabled(false);
    }

    private void storeAllCurrentlyOpenFiles() {
        Vector<LogFile> fileList = new Vector<LogFile>();
        for (String key : this.logTab.keySet()) {
            LogFileTab tab = this.logTab.get(key);
            LogFile logFile = tab.getDocument().getFile();
            fileList.add(logFile);
        }
        LogViewerPlugin.getDefault().getPreferenceStore().setValue("LAST_OPEN_FILES", PreferenceValueConverter.asLogFileListString(fileList));
    }

    private void openAllLastOpenFiles() {
        List<LogFile> logFiles = PreferenceValueConverter.asLogFileList(LogViewerPlugin.getDefault().getPreferenceStore().getString("LAST_OPEN_FILES"));
        for (LogFile logFile : logFiles) {
            this.openLogFile(logFile);
        }
    }

    private void createConsole() {
        this.console = new LogViewerConsole(LogViewerPlugin.getResourceString("logviewer.plugin.console.name"), null);
        ConsolePlugin.getDefault().getConsoleManager().addConsoles(new IConsole[]{this.console});
        this.printDefaultMessage();
    }

    private class TabSelectionListener
    implements SelectionListener {
        private TabSelectionListener() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            LogFileTab oldTab;
            TabItem item = (TabItem)e.item;
            if (item == null) {
                return;
            }
            LogFileTab tab = LogViewer.this.getSelectedTab(item);
            if (tab == null || tab.getDocument() == null) {
                return;
            }
            if (LogViewer.this.oldTabItem != null && (oldTab = LogViewer.this.getSelectedTab(LogViewer.this.oldTabItem)) != null && oldTab.getDocument() != null) {
                oldTab.setSelection(LogViewer.this.viewer.getSelection());
                oldTab.setTopIndex(LogViewer.this.viewer.getTopIndex());
            }
            LogViewer.this.fileEncodingAction.setText(LogViewerPlugin.getResourceString("menu.encodingchange.text", new Object[]{tab.getDocument().getEncoding()}));
            LogViewer.this.showDocument(tab.getDocument(), tab.getSelection(), tab.getTopIndex(), false);
            LogViewer.this.updateTailStartStopButtons(tab.getDocument().isMonitor());
            LogViewer.this.refreshCurrentFileAction.setEnabled(true);
            LogViewer.this.oldTabItem = item;
        }
    }

    private class ViewDocumentListener
    implements IDocumentListener {
        public void documentAboutToBeChanged(DocumentEvent documentevent) {
        }

        public void documentChanged(DocumentEvent event) {
            if (!LogViewer.this.isAvailable()) {
                return;
            }
            LogFileTab tab = LogViewer.this.getSelectedTab();
            if (LogViewer.this.viewer.isShowWhenUpdated()) {
                try {
                    PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("de.anbos.eclipse.logviewer.plugin.LogViewer");
                }
                catch (PartInitException e) {
                    e.printStackTrace();
                }
                if (event.getDocument() != tab.getDocument()) {
                    for (Object key : LogViewer.this.logTab.keySet()) {
                        LogFileTab newTab = (LogFileTab)LogViewer.this.logTab.get(key);
                        if (event.getDocument() != newTab.getDocument()) continue;
                        LogViewer.this.showDocument(newTab.getDocument(), null, 0, true);
                        LogViewer.this.tabfolder.setSelection(new TabItem[]{newTab.getItem()});
                        Event newEvent = new Event();
                        newEvent.item = newTab.getItem();
                        LogViewer.this.tabfolder.notifyListeners(13, newEvent);
                        break;
                    }
                }
            }
            if (LogViewer.this.logTab != null && event.getDocument() == tab.getDocument() && LogViewer.this.viewer.getDocument() != null) {
                LogViewer.this.viewer.refresh();
                LogViewer.this.viewer.showBottomOfFile();
            }
            if (LogViewer.this.stopAfterChange) {
                LogViewer.this.stopAfterChange = false;
                LogViewer.this.stopTail();
            }
        }

        protected ViewDocumentListener() {
        }
    }
}

