/*
 * Decompiled with CFR 0.152.
 */
package de.anbos.eclipse.logviewer.plugin;

import java.io.File;
import java.lang.reflect.Method;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleView;
import org.eclipse.ui.console.TextConsolePage;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.part.MessagePage;
import org.eclipse.ui.part.PageBookView;

public class ResourceUtils {
    public static ISelection getResourceSelection(IWorkbenchPart part) {
        ISelection selection = null;
        if (part != null) {
            if (part instanceof IEditorPart) {
                File file = ResourceUtils.getResource((IEditorPart)part);
                if (file != null) {
                    selection = new StructuredSelection((Object)file);
                }
            } else {
                try {
                    selection = part.getSite().getSelectionProvider().getSelection();
                }
                catch (Exception exception) {}
            }
        }
        return selection;
    }

    public static ISelection getConsoleSelection(IWorkbenchPart part) {
        StructuredSelection selection = null;
        IConsole con = ResourceUtils.getConsole(part);
        if (con != null) {
            selection = new StructuredSelection((Object)con);
        }
        return selection;
    }

    public static IConsole getConsole(IWorkbenchPart part) {
        IPage page;
        ITextViewer viewer;
        if (!(part instanceof IViewPart)) {
            return null;
        }
        IViewPart vp = (IViewPart)part;
        if (vp instanceof PageBookView && ((viewer = ResourceUtils.getViewer(page = ((PageBookView)vp).getCurrentPage())) == null || viewer.getDocument() == null)) {
            return null;
        }
        IConsole con = null;
        try {
            con = ((IConsoleView)part).getConsole();
        }
        catch (Exception exception) {}
        return con;
    }

    public static ITextViewer getViewer(IPage page) {
        if (page == null) {
            return null;
        }
        if (page instanceof TextConsolePage) {
            return ((TextConsolePage)page).getViewer();
        }
        if (page.getClass().equals(MessagePage.class)) {
            return null;
        }
        try {
            Method method = page.getClass().getDeclaredMethod("getViewer", null);
            method.setAccessible(true);
            return (ITextViewer)method.invoke((Object)page, null);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static File getResource(Object myObj) {
        IEditorPart editorPart;
        IEditorInput input;
        Object adapter;
        Object object = null;
        object = myObj instanceof IEditorPart ? ((adapter = (input = (editorPart = (IEditorPart)myObj).getEditorInput()).getAdapter(IFile.class)) instanceof IFile ? (IFile)adapter : ((adapter = editorPart.getAdapter(IFile.class)) instanceof IFile ? (IFile)adapter : input)) : myObj;
        if (object instanceof IFile) {
            return ResourceUtils.toFile(((IFile)object).getLocation());
        }
        if (object instanceof File) {
            return (File)object;
        }
        if (object instanceof IAdaptable) {
            IAdaptable adaptable = (IAdaptable)object;
            IFile ifile = (IFile)adaptable.getAdapter(IFile.class);
            if (ifile != null) {
                return ResourceUtils.toFile(ifile.getLocation());
            }
            IResource ires = (IResource)adaptable.getAdapter(IResource.class);
            if (ires != null) {
                return ResourceUtils.toFile(ires.getLocation());
            }
            File file = (File)adaptable.getAdapter(File.class);
            if (file != null) {
                return file;
            }
        }
        return null;
    }

    public static File toFile(IPath iPath) {
        if (iPath != null) {
            return iPath.toFile();
        }
        return null;
    }
}

