/*
 * Decompiled with CFR 0.152.
 */
package de.anbos.eclipse.logviewer.plugin.file;

import de.anbos.eclipse.logviewer.plugin.LogViewerPlugin;
import de.anbos.eclipse.logviewer.plugin.Logger;
import de.anbos.eclipse.logviewer.plugin.file.IFileChangedListener;
import de.anbos.eclipse.logviewer.plugin.file.ThreadInterruptedException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;

public class FileTail
implements Runnable {
    private static final int INITIAL_LOAD_SIZE = 1000000;
    private Logger logger = LogViewerPlugin.getDefault().getLogger();
    private String filePath;
    private IFileChangedListener listener;
    private CharsetDecoder decoder;
    private boolean isRunning;
    private boolean isFirstTimeRead;
    private int bufferCapacity;

    public FileTail(String myFilePath, Charset charset, IFileChangedListener myListener) {
        this.filePath = myFilePath;
        this.listener = myListener;
        this.decoder = charset.newDecoder();
        this.decoder.onUnmappableCharacter(CodingErrorAction.REPLACE);
        this.bufferCapacity = LogViewerPlugin.getDefault().getPreferenceStore().getInt("BUFFER");
    }

    public void setMonitorStatus(boolean monitor) {
        if (this.isRunning == monitor) {
            return;
        }
        this.isRunning = monitor;
        if (this.isRunning) {
            Thread tailThread = new Thread(this);
            tailThread.setDaemon(true);
            tailThread.start();
        }
    }

    /*
     * Exception decompiling
     */
    public synchronized void run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private synchronized RandomAccessFile openFile() throws ThreadInterruptedException, FileNotFoundException {
        boolean firstExec = true;
        while (this.isRunning) {
            try {
                RandomAccessFile file = new RandomAccessFile(this.filePath, "r");
                this.isFirstTimeRead = true;
                return file;
            }
            catch (FileNotFoundException fileNotFoundException) {
                try {
                    if (firstExec) {
                        this.listener.fileChanged(LogViewerPlugin.getResourceString("tail.loading.file.warning", new String[]{this.filePath}).toCharArray(), true);
                        firstExec = false;
                    }
                    this.wait(500L);
                }
                catch (InterruptedException ie) {
                    throw new ThreadInterruptedException(ie);
                }
            }
        }
        throw new FileNotFoundException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void read(FileChannel channel) throws IOException {
        if (this.isFirstTimeRead) {
            this.listener.fileChanged(LogViewerPlugin.getResourceString("tail.loading.file", new String[]{this.filePath}).toCharArray(), true);
            this.bufferCapacity = LogViewerPlugin.getDefault().getPreferenceStore().getInt("BUFFER");
        }
        long startPosition = channel.position();
        long endPosition = channel.size();
        long size = endPosition - startPosition;
        if (this.isFirstTimeRead || size > 1000000L) {
            this.isFirstTimeRead = false;
            FileChannel fileChannel = channel;
            synchronized (fileChannel) {
                if (size > 1000000L) {
                    startPosition = endPosition - 1000000L;
                    size = 1000000L;
                }
                MappedByteBuffer mappedBuffer = channel.map(FileChannel.MapMode.READ_ONLY, startPosition, size);
                CharBuffer mappedChars = this.decoder.decode(mappedBuffer);
                channel.position(endPosition);
                this.listener.fileChanged(mappedChars.array(), true);
            }
            return;
        }
        ByteBuffer buffer = ByteBuffer.allocate(this.bufferCapacity);
        channel.read(buffer);
        buffer.flip();
        CharBuffer chars = this.decoder.decode(buffer);
        this.listener.fileChanged(chars.array(), false);
    }
}

