/*
 * Decompiled with CFR 0.152.
 */
package de.anbos.eclipse.logviewer.plugin.preferences;

import de.anbos.eclipse.logviewer.plugin.LogFile;
import de.anbos.eclipse.logviewer.plugin.LogViewerPlugin;
import de.anbos.eclipse.logviewer.plugin.preferences.HistoryFile;
import de.anbos.eclipse.logviewer.plugin.preferences.HistoryFileComparator;
import de.anbos.eclipse.logviewer.plugin.preferences.PreferenceValueConverter;
import java.util.Collections;
import java.util.List;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileHistoryTracker {
    private static final FileHistoryTracker instance = new FileHistoryTracker();
    private List<HistoryFile> files;

    private FileHistoryTracker() {
    }

    public static FileHistoryTracker getInstance() {
        return instance;
    }

    public void storeFile(LogFile.LogFileType type, String path) {
        this.init();
        HistoryFile file = new HistoryFile(path, type, 0);
        if (this.containsThenIncrement(file)) {
            LogViewerPlugin.getDefault().getPreferenceStore().setValue("HISTORY_FILES", PreferenceValueConverter.asString(this.files));
            return;
        }
        if (this.files.size() == 10) {
            this.files.remove(9);
            this.files.add(file);
        } else {
            this.files.add(file);
        }
        Collections.sort(this.files, new HistoryFileComparator());
        LogViewerPlugin.getDefault().getPreferenceStore().setValue("HISTORY_FILES", PreferenceValueConverter.asString(this.files));
    }

    public List<HistoryFile> getFiles() {
        this.init();
        return this.files;
    }

    public void clearFiles() {
        this.init();
        this.files.clear();
        LogViewerPlugin.getDefault().getPreferenceStore().setValue("HISTORY_FILES", PreferenceValueConverter.asString(this.files));
    }

    private void init() {
        String historyFilesPrefString = LogViewerPlugin.getDefault().getPreferenceStore().getString("HISTORY_FILES");
        if (historyFilesPrefString != null && historyFilesPrefString.length() <= 0) {
            this.files = new Vector<HistoryFile>();
            return;
        }
        this.files = PreferenceValueConverter.asUnsortedHistoryFileList(historyFilesPrefString);
        Collections.sort(this.files, new HistoryFileComparator());
    }

    private boolean containsThenIncrement(HistoryFile file) {
        for (HistoryFile fileOld : this.files) {
            if (!fileOld.equals(file)) continue;
            fileOld.incrementCount();
            Collections.sort(this.files, new HistoryFileComparator());
            return true;
        }
        return false;
    }
}

