/*
 * Decompiled with CFR 0.152.
 */
package de.anbos.eclipse.logviewer.plugin.preferences;

import de.anbos.eclipse.logviewer.plugin.LogFile;
import de.anbos.eclipse.logviewer.plugin.preferences.Base64;
import de.anbos.eclipse.logviewer.plugin.preferences.HistoryFile;
import de.anbos.eclipse.logviewer.plugin.preferences.rule.RulePreferenceData;
import de.anbos.eclipse.logviewer.plugin.viewer.rule.ILogFileToolRule;
import de.anbos.eclipse.logviewer.plugin.viewer.rule.LogToolRuleDesc;
import de.anbos.eclipse.logviewer.plugin.viewer.rule.RuleFactory;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.swt.graphics.RGB;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PreferenceValueConverter {
    public static String VALUE_DELIMITER = "|";
    public static String ITEM_DELIMITER = "#";

    public static String asString(RulePreferenceData[] items) {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < items.length) {
            buffer.append(PreferenceValueConverter.asString(items[i]));
            buffer.append(ITEM_DELIMITER);
            ++i;
        }
        return buffer.toString();
    }

    public static final String asString(RulePreferenceData data) {
        String position = Base64.encode(Integer.toString(data.getPosition()));
        String checked = Base64.encode(Boolean.toString(data.isEnabled()));
        String rule = Base64.encode(data.getRuleName());
        String background = Base64.encode(StringConverter.asString((RGB)data.getBackgroundColor()));
        String foreground = Base64.encode(StringConverter.asString((RGB)data.getForegroundColor()));
        String value = Base64.encode(data.getRuleValue());
        String matchMode = Base64.encode(data.getMatchMode());
        String caseInsensitive = Base64.encode(Boolean.toString(data.isCaseInsensitive()));
        return String.valueOf(position) + VALUE_DELIMITER + checked + VALUE_DELIMITER + rule + VALUE_DELIMITER + background + VALUE_DELIMITER + foreground + VALUE_DELIMITER + value + VALUE_DELIMITER + matchMode + VALUE_DELIMITER + caseInsensitive;
    }

    public static RulePreferenceData[] asRulePreferenceDataArray(String value) {
        StringTokenizer tokenizer = new StringTokenizer(value, ITEM_DELIMITER);
        RulePreferenceData[] items = new RulePreferenceData[tokenizer.countTokens()];
        int i = 0;
        while (i < items.length) {
            items[i] = PreferenceValueConverter.asRulePreferenceData(tokenizer.nextToken());
            ++i;
        }
        return items;
    }

    public static RulePreferenceData asRulePreferenceData(String value) {
        RulePreferenceData data = new RulePreferenceData();
        data.fillTokens(value, VALUE_DELIMITER);
        return data;
    }

    public static ILogFileToolRule asRule(String value) {
        if (value == null || value.length() <= 0) {
            return null;
        }
        LogToolRuleDesc ruleDesc = new LogToolRuleDesc();
        ruleDesc.fillTokens(value, VALUE_DELIMITER);
        return RuleFactory.getRule(ruleDesc.getRuleName(), ruleDesc);
    }

    public static List<ILogFileToolRule> asRuleArray(String value) {
        Vector<ILogFileToolRule> rules = new Vector<ILogFileToolRule>();
        StringTokenizer tokenizer = new StringTokenizer(value, ITEM_DELIMITER);
        while (tokenizer.hasMoreTokens()) {
            ILogFileToolRule rule = PreferenceValueConverter.asRule(tokenizer.nextToken());
            if (rule == null) continue;
            rules.add(rule);
        }
        return rules;
    }

    public static String asString(HistoryFile historyFile) {
        return String.valueOf(historyFile.getPath()) + VALUE_DELIMITER + historyFile.getCount() + VALUE_DELIMITER + (Object)((Object)historyFile.getType());
    }

    public static HistoryFile asHistoryFile(String value) {
        String[] str = new String[3];
        StringTokenizer tokenizer = new StringTokenizer(value, VALUE_DELIMITER);
        int i = 0;
        while (i < 3) {
            str[i] = tokenizer.hasMoreTokens() ? tokenizer.nextToken() : null;
            ++i;
        }
        return new HistoryFile(str[0], PreferenceValueConverter.asType(str[2]), Integer.parseInt(str[1]));
    }

    public static String asString(List<?> historyFiles) {
        Iterator<?> it = historyFiles.iterator();
        StringBuffer buffer = new StringBuffer();
        while (it.hasNext()) {
            HistoryFile file = (HistoryFile)it.next();
            buffer.append(PreferenceValueConverter.asString(file));
            buffer.append(ITEM_DELIMITER);
        }
        return buffer.toString();
    }

    public static List<HistoryFile> asUnsortedHistoryFileList(String value) {
        Vector<HistoryFile> files = new Vector<HistoryFile>();
        StringTokenizer tokenizer = new StringTokenizer(value, ITEM_DELIMITER);
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            files.add(PreferenceValueConverter.asHistoryFile(token));
        }
        return files;
    }

    public static String asString(LogFile logFile) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(logFile.getFileName());
        buffer.append(VALUE_DELIMITER);
        buffer.append(logFile.getTabName());
        buffer.append(VALUE_DELIMITER);
        buffer.append(logFile.getEncoding());
        buffer.append(VALUE_DELIMITER);
        buffer.append(logFile.getMonitor());
        buffer.append(VALUE_DELIMITER);
        buffer.append(logFile.getFileType().toString());
        return buffer.toString();
    }

    public static String asLogFileListString(List<?> logFiles) {
        Iterator<?> it = logFiles.iterator();
        StringBuffer buffer = new StringBuffer();
        while (it.hasNext()) {
            LogFile logFile = (LogFile)it.next();
            buffer.append(PreferenceValueConverter.asString(logFile));
            buffer.append(ITEM_DELIMITER);
        }
        return buffer.toString();
    }

    public static LogFile asLogFile(String logFileStr) {
        String[] str = new String[5];
        StringTokenizer tokenizer = new StringTokenizer(logFileStr, VALUE_DELIMITER);
        int i = 0;
        while (i < 5) {
            str[i] = tokenizer.hasMoreTokens() ? tokenizer.nextToken() : null;
            ++i;
        }
        LogFile.LogFileType type = PreferenceValueConverter.asType(str[4]);
        LogFile logFile = new LogFile(type, str[0], str[1], str[2], !"false".equals(str[3]));
        return logFile;
    }

    public static LogFile.LogFileType asType(String logTypeStr) {
        LogFile.LogFileType type = LogFile.LogFileType.LOGFILE_SYSTEM_FILE;
        if (logTypeStr != null && logTypeStr.length() != 0) {
            LogFile.LogFileType[] types = LogFile.LogFileType.values();
            int i = 0;
            while (i < types.length) {
                if (types[i].toString().equals(logTypeStr)) {
                    type = types[i];
                    break;
                }
                ++i;
            }
        }
        return type;
    }

    public static List<LogFile> asLogFileList(String logFileList) {
        Vector<LogFile> files = new Vector<LogFile>();
        StringTokenizer tokenizer = new StringTokenizer(logFileList, ITEM_DELIMITER);
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            files.add(PreferenceValueConverter.asLogFile(token));
        }
        return files;
    }
}

