/*
 * Decompiled with CFR 0.152.
 */
package de.anbos.eclipse.logviewer.plugin.preferences.rule;

import de.anbos.eclipse.logviewer.plugin.LogViewerPlugin;
import de.anbos.eclipse.logviewer.plugin.Logger;
import de.anbos.eclipse.logviewer.plugin.preferences.RuleItemReadWriter;
import de.anbos.eclipse.logviewer.plugin.preferences.rule.ItemMover;
import de.anbos.eclipse.logviewer.plugin.preferences.rule.RuleContentProvider;
import de.anbos.eclipse.logviewer.plugin.preferences.rule.RuleDialog;
import de.anbos.eclipse.logviewer.plugin.preferences.rule.RuleLabelProvider;
import de.anbos.eclipse.logviewer.plugin.preferences.rule.RulePreferenceData;
import de.anbos.eclipse.logviewer.plugin.preferences.rule.RuleStore;
import de.anbos.eclipse.logviewer.plugin.preferences.rule.TableItemColorController;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class RulePreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static final int TABLE_WIDTH = 400;
    private Logger logger;
    private Table table;
    private ItemMover itemMover;
    private RuleStore store;
    private CheckboxTableViewer tableViewer;
    private Button addButton;
    private Button editButton;
    private Button upButton;
    private Button downButton;
    private Button importButton;
    private Button exportSelectedButton;
    private Button exportAllButton;
    private Button removeButton;

    public void init(IWorkbench workbench) {
        this.logger = LogViewerPlugin.getDefault().getLogger();
    }

    public boolean performOk() {
        this.store.save();
        return true;
    }

    protected void performDefaults() {
        this.store.loadDefault();
        this.tableViewer.refresh();
    }

    protected void performApply() {
        this.performOk();
    }

    protected Control createContents(Composite parent) {
        Font font = parent.getFont();
        Composite pageComponent = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        pageComponent.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        this.table = new Table(pageComponent, 65570);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        this.table.setFont(parent.getFont());
        TableColumn column1 = new TableColumn(this.table, 16384);
        column1.setText(LogViewerPlugin.getResourceString("preferences.ruleseditor.table.header.column0.title"));
        column1.setResizable(false);
        TableColumn column2 = new TableColumn(this.table, 16384);
        column2.setText(LogViewerPlugin.getResourceString("preferences.ruleseditor.table.header.column1.title"));
        column2.setResizable(false);
        int availableRows = this.availableRows(pageComponent);
        data.heightHint = this.table.getItemHeight() * (availableRows / 8);
        data.widthHint = 400;
        this.table.setLayoutData((Object)data);
        new TableItemColorController(this.table);
        this.tableViewer = new CheckboxTableViewer(this.table);
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new RuleLabelProvider());
        this.tableViewer.setContentProvider((IContentProvider)new RuleContentProvider());
        this.store = new RuleStore(LogViewerPlugin.getDefault().getPreferenceStore());
        this.store.load();
        this.tableViewer.setInput((Object)this.store);
        this.tableViewer.setAllChecked(false);
        this.tableViewer.setCheckedElements((Object[])this.store.getAllCheckedRuleDetails());
        this.tableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent e) {
                RulePreferencePage.this.edit();
            }
        });
        this.tableViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                RulePreferenceData data = (RulePreferenceData)event.getElement();
                data.setEnabled(event.getChecked());
            }
        });
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)RulePreferencePage.this.tableViewer.getSelection();
                boolean selected = !selection.isEmpty();
                RulePreferencePage.this.editButton.setEnabled(selected);
                RulePreferencePage.this.removeButton.setEnabled(selected);
                RulePreferencePage.this.upButton.setEnabled(selected);
                RulePreferencePage.this.downButton.setEnabled(selected);
                RulePreferencePage.this.exportSelectedButton.setEnabled(selected);
            }
        });
        this.tableViewer.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object object1, Object object2) {
                if (!(object1 instanceof RulePreferenceData) || !(object2 instanceof RulePreferenceData)) {
                    return super.compare(viewer, object1, object2);
                }
                RulePreferenceData data1 = (RulePreferenceData)object1;
                RulePreferenceData data2 = (RulePreferenceData)object2;
                if (data1.getPosition() > data2.getPosition()) {
                    return 1;
                }
                if (data1.getPosition() < data2.getPosition()) {
                    return -1;
                }
                if (data1.getPosition() == data2.getPosition()) {
                    return 0;
                }
                return super.compare(viewer, object1, object2);
            }

            public boolean isSorterProperty(Object element, String property) {
                return true;
            }
        });
        this.itemMover = new ItemMover(this.table, this.store);
        Composite groupComponent = new Composite(pageComponent, 0);
        GridLayout groupLayout = new GridLayout();
        groupLayout.marginWidth = 0;
        groupLayout.marginHeight = 0;
        groupComponent.setLayout((Layout)groupLayout);
        data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        groupComponent.setLayoutData((Object)data);
        groupComponent.setFont(font);
        this.addButton = new Button(groupComponent, 8);
        this.addButton.setText(LogViewerPlugin.getResourceString("preferences.ruleseditor.button.add"));
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                RulePreferencePage.this.add();
            }
        });
        this.addButton.setLayoutData((Object)data);
        this.addButton.setFont(font);
        this.setButtonLayoutData(this.addButton);
        this.editButton = new Button(groupComponent, 8);
        this.editButton.setText(LogViewerPlugin.getResourceString("preferences.ruleseditor.button.edit"));
        this.editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                RulePreferencePage.this.edit();
            }
        });
        this.editButton.setLayoutData((Object)data);
        this.editButton.setFont(font);
        this.setButtonLayoutData(this.editButton);
        this.removeButton = new Button(groupComponent, 8);
        this.removeButton.setText(LogViewerPlugin.getResourceString("preferences.ruleseditor.button.remove"));
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                RulePreferencePage.this.remove();
            }
        });
        this.removeButton.setFont(font);
        this.setButtonLayoutData(this.removeButton);
        this.upButton = new Button(groupComponent, 8);
        this.upButton.setText(LogViewerPlugin.getResourceString("preferences.ruleseditor.button.up"));
        this.upButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                RulePreferencePage.this.up();
            }
        });
        this.upButton.setFont(font);
        this.setButtonLayoutData(this.upButton);
        this.downButton = new Button(groupComponent, 8);
        this.downButton.setText(LogViewerPlugin.getResourceString("preferences.ruleseditor.button.down"));
        this.downButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                RulePreferencePage.this.down();
            }
        });
        this.downButton.setFont(font);
        this.setButtonLayoutData(this.downButton);
        this.exportSelectedButton = new Button(groupComponent, 8);
        this.exportSelectedButton.setText(LogViewerPlugin.getResourceString("preferences.ruleseditor.button.export.selected"));
        this.exportSelectedButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                RulePreferencePage.this.exportSelected();
            }
        });
        this.exportSelectedButton.setFont(font);
        this.setButtonLayoutData(this.exportSelectedButton);
        this.exportAllButton = new Button(groupComponent, 8);
        this.exportAllButton.setText(LogViewerPlugin.getResourceString("preferences.ruleseditor.button.export.all"));
        this.exportAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                RulePreferencePage.this.exportAll();
            }
        });
        this.exportAllButton.setFont(font);
        this.setButtonLayoutData(this.exportAllButton);
        this.importButton = new Button(groupComponent, 8);
        this.importButton.setText(LogViewerPlugin.getResourceString("preferences.ruleseditor.button.import"));
        this.importButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                RulePreferencePage.this.inport();
            }
        });
        this.importButton.setFont(font);
        this.setButtonLayoutData(this.importButton);
        this.configureTableResizing(this.table);
        Dialog.applyDialogFont((Control)pageComponent);
        this.table.getHorizontalBar().setVisible(true);
        Event event = new Event();
        event.item = null;
        this.tableViewer.getTable().notifyListeners(13, event);
        return pageComponent;
    }

    private int availableRows(Composite parent) {
        int fontHeight = parent.getFont().getFontData()[0].getHeight();
        int displayHeight = parent.getDisplay().getClientArea().height;
        return displayHeight / fontHeight;
    }

    private void configureTableResizing(Table table) {
        ControlAdapter resizer = new ControlAdapter(){
            private boolean fIsResizing = false;
            private final int[] fWidths = new int[]{120, 280};
            private int fSum = 400;

            public void controlResized(ControlEvent e) {
                if (this.fIsResizing) {
                    return;
                }
                try {
                    this.fIsResizing = true;
                    int clientAreaWidth = table.getClientArea().width;
                    TableColumn[] columns = table.getColumns();
                    int calculatedtableWidth = 0;
                    if (e.widget == table) {
                        int toDistribute;
                        int[] initial = new int[]{120, 280};
                        int[] minimums = new int[columns.length];
                        int minSum = 0;
                        int i = 0;
                        while (i < columns.length) {
                            minimums[i] = Math.min(this.fWidths[i], initial[i]);
                            minSum += minimums[i];
                            ++i;
                        }
                        int newWidth = this.fSum < clientAreaWidth ? clientAreaWidth : Math.max(clientAreaWidth, minSum);
                        int lastPart = toDistribute = newWidth - this.fSum;
                        if (toDistribute != 0) {
                            int[] nArray = new int[2];
                            nArray[1] = 1;
                            int[] iteration = nArray;
                            int i2 = 0;
                            while (i2 < iteration.length) {
                                int width;
                                int c = iteration[i2];
                                if (this.fSum > 0) {
                                    int part = i2 == iteration.length - 1 ? lastPart : toDistribute * this.fWidths[c] / this.fSum;
                                    lastPart -= part;
                                    width = Math.max(minimums[c], this.fWidths[c] + part);
                                } else {
                                    width = toDistribute * initial[c] / 400;
                                }
                                columns[c].setWidth(width);
                                this.fWidths[c] = width;
                                calculatedtableWidth += width;
                                ++i2;
                            }
                            this.fSum = calculatedtableWidth;
                        }
                    } else {
                        if (e.widget == columns[2]) {
                            return;
                        }
                        int i = 0;
                        while (i < columns.length) {
                            this.fWidths[i] = columns[i].getWidth();
                            calculatedtableWidth += this.fWidths[i];
                            ++i;
                        }
                        this.fSum = calculatedtableWidth;
                    }
                    table.getHorizontalBar().setVisible(calculatedtableWidth > clientAreaWidth);
                }
                finally {
                    this.fIsResizing = false;
                }
            }
        };
        table.addControlListener((ControlListener)resizer);
        TableColumn[] columns = table.getColumns();
        int i = 0;
        while (i < columns.length) {
            columns[i].addControlListener((ControlListener)resizer);
            ++i;
        }
    }

    private void add() {
        RulePreferenceData data = new RulePreferenceData();
        RuleDialog dialog = new RuleDialog(this.getShell(), data, false);
        if (dialog.open() == 0) {
            this.store.add(data);
            this.tableViewer.refresh();
            this.tableViewer.setChecked((Object)data, data.isEnabled());
            this.tableViewer.setSelection((ISelection)new StructuredSelection((Object)data));
            return;
        }
    }

    private void remove() {
        IStructuredSelection selection = (IStructuredSelection)this.tableViewer.getSelection();
        for (RulePreferenceData data : selection) {
            this.store.delete(data);
        }
        this.tableViewer.refresh();
    }

    private void edit() {
        IStructuredSelection selection = (IStructuredSelection)this.tableViewer.getSelection();
        RulePreferenceData data = (RulePreferenceData)selection.getFirstElement();
        RuleDialog dialog = new RuleDialog(this.getShell(), data, true);
        if (dialog.open() == 0) {
            this.tableViewer.refresh();
            this.tableViewer.setChecked((Object)data, data.isEnabled());
            this.tableViewer.setSelection((ISelection)new StructuredSelection((Object)data));
            return;
        }
    }

    private void up() {
        this.itemMover.moveCurrentSelectionUp();
        this.tableViewer.refresh();
    }

    private void down() {
        this.itemMover.moveCurrentSelectionDown();
        this.tableViewer.refresh();
    }

    private void exportSelected() {
        IStructuredSelection selection = (IStructuredSelection)this.tableViewer.getSelection();
        if (selection.isEmpty()) {
            if (this.askSelectAll()) {
                this.tableViewer.getTable().selectAll();
                selection = (IStructuredSelection)this.tableViewer.getSelection();
            } else {
                MessageDialog.openError((Shell)this.getShell(), (String)LogViewerPlugin.getResourceString("preferences.ruleseditor.export.error.title"), (String)LogViewerPlugin.getResourceString("preferences.ruleseditor.export.error.select.items.text"));
                return;
            }
        }
        ArrayList itemArray = new ArrayList();
        itemArray.addAll(selection.toList());
        this.export(itemArray.toArray(new RulePreferenceData[itemArray.size()]));
    }

    private void exportAll() {
        IStructuredSelection selectionSave = (IStructuredSelection)this.tableViewer.getSelection();
        this.tableViewer.getTable().selectAll();
        IStructuredSelection selection = (IStructuredSelection)this.tableViewer.getSelection();
        if (selection.isEmpty()) {
            MessageDialog.openError((Shell)this.getShell(), (String)LogViewerPlugin.getResourceString("preferences.ruleseditor.export.error.title"), (String)LogViewerPlugin.getResourceString("preferences.ruleseditor.export.error.select.items.text"));
            return;
        }
        ArrayList itemArray = new ArrayList();
        itemArray.addAll(selection.toList());
        this.export(itemArray.toArray(new RulePreferenceData[itemArray.size()]));
        this.tableViewer.setSelection((ISelection)selectionSave, true);
    }

    private void export(RulePreferenceData[] data) {
        FileDialog dialog = new FileDialog(this.getShell(), 8192);
        dialog.setText(LogViewerPlugin.getResourceString("preferences.ruleseditor.export.title"));
        dialog.setFilterExtensions(new String[]{LogViewerPlugin.getResourceString("preferences.ruleseditor.export.extension")});
        dialog.setFileName(LogViewerPlugin.getResourceString("preferences.ruleseditor.export.filename"));
        String path = dialog.open();
        if (path == null) {
            return;
        }
        File file = new File(path);
        if (file.isHidden()) {
            String title = LogViewerPlugin.getResourceString("preferences.ruleseditor.export.error.title");
            String message = LogViewerPlugin.getResourceString("preferences.ruleseditor.export.error.hidden.text", new String[]{file.getAbsolutePath()});
            MessageDialog.openError((Shell)this.getShell(), (String)title, (String)message);
            return;
        }
        if (file.exists() && !file.canWrite()) {
            String title = LogViewerPlugin.getResourceString("preferences.ruleseditor.export.error.title");
            String message = LogViewerPlugin.getResourceString("preferences.ruleseditor.export.error.cannotWrite.text", new String[]{file.getAbsolutePath()});
            MessageDialog.openError((Shell)this.getShell(), (String)title, (String)message);
            return;
        }
        if (!file.exists() || this.confirmOverwrite(file)) {
            this.performApply();
            OutputStream output = null;
            try {
                output = new BufferedOutputStream(new FileOutputStream(file));
                RuleItemReadWriter writer = new RuleItemReadWriter();
                writer.write(data, output);
                output.close();
            }
            catch (IOException e) {
                if (output != null) {
                    try {
                        output.close();
                    }
                    catch (IOException e2) {
                        this.logger.logError("unable to close existing file while attempting to export color items", e2);
                    }
                }
                this.openWriteErrorDialog(e);
            }
        }
    }

    private void inport() {
        FileDialog dialog = new FileDialog(this.getShell());
        dialog.setText(LogViewerPlugin.getResourceString("preferences.ruleseditor.import.title"));
        dialog.setFilterExtensions(new String[]{LogViewerPlugin.getResourceString("preferences.ruleseditor.import.extension")});
        String path = dialog.open();
        if (path == null) {
            return;
        }
        try {
            RuleItemReadWriter reader = new RuleItemReadWriter();
            File file = new File(path);
            if (file.exists()) {
                BufferedInputStream input = new BufferedInputStream(new FileInputStream(file));
                try {
                    RulePreferenceData[] datas = reader.read(input);
                    this.performApply();
                    if (this.askOverwriteImport()) {
                        this.store.removeAll();
                    }
                    int i = 0;
                    while (i < datas.length) {
                        RulePreferenceData data = datas[i];
                        this.store.add(data);
                        ++i;
                    }
                }
                finally {
                    try {
                        ((InputStream)input).close();
                    }
                    catch (IOException x) {
                        this.logger.logError("unable to close existing file while attempting to import color items", x);
                    }
                }
            }
            this.tableViewer.refresh();
            this.tableViewer.setAllChecked(false);
            this.tableViewer.setCheckedElements((Object[])this.store.getAllCheckedRuleDetails());
        }
        catch (FileNotFoundException e) {
            this.openReadErrorDialog(e);
        }
        catch (IOException e) {
            this.openReadErrorDialog(e);
        }
    }

    private boolean askOverwriteImport() {
        return MessageDialog.openQuestion((Shell)this.getShell(), (String)LogViewerPlugin.getResourceString("preferences.ruleseditor.import.dialog.overwrite.title"), (String)LogViewerPlugin.getResourceString("preferences.ruleseditor.import.dialog.overwrite.text"));
    }

    private boolean confirmOverwrite(File file) {
        return MessageDialog.openQuestion((Shell)this.getShell(), (String)LogViewerPlugin.getResourceString("preferences.ruleseditor.export.error.title"), (String)LogViewerPlugin.getResourceString("preferences.ruleseditor.export.error.exists.text", new String[]{file.getAbsolutePath()}));
    }

    private void openWriteErrorDialog(Exception e) {
        String title = LogViewerPlugin.getResourceString("preferences.ruleseditor.export.error.title");
        String message = LogViewerPlugin.getResourceString("preferences.ruleseditor.export.error.general.text");
        MessageDialog.openError((Shell)this.getShell(), (String)title, (String)message);
    }

    private void openReadErrorDialog(Exception e) {
        String title = LogViewerPlugin.getResourceString("preferences.ruleseditor.import.error.title");
        String message = LogViewerPlugin.getResourceString("preferences.ruleseditor.import.error.text");
        MessageDialog.openError((Shell)this.getShell(), (String)title, (String)message);
    }

    private boolean askSelectAll() {
        return MessageDialog.openQuestion((Shell)this.getShell(), (String)LogViewerPlugin.getResourceString("preferences.ruleseditor.export.dialog.selectall.title"), (String)LogViewerPlugin.getResourceString("preferences.ruleseditor.export.dialog.selectall.text"));
    }
}

