/*
 * Decompiled with CFR 0.152.
 */
package de.anbos.eclipse.logviewer.plugin.preferences.rule;

import de.anbos.eclipse.logviewer.plugin.preferences.PreferenceValueConverter;
import de.anbos.eclipse.logviewer.plugin.preferences.rule.RulePreferenceData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.jface.preference.IPreferenceStore;

public class RuleStore {
    private IPreferenceStore store;
    private List<RulePreferenceData> items = new ArrayList<RulePreferenceData>();
    private DataObjectComparator comparator;

    public RuleStore(IPreferenceStore store) {
        this.store = store;
    }

    public RulePreferenceData[] getAllRuleDetails() {
        RulePreferenceData[] data = new RulePreferenceData[this.items.size()];
        int i = 0;
        while (i < data.length) {
            data[i] = this.items.get(i);
            ++i;
        }
        return data;
    }

    public RulePreferenceData[] getAllCheckedRuleDetails() {
        ArrayList<RulePreferenceData> checkedItems = new ArrayList<RulePreferenceData>();
        for (RulePreferenceData data : this.items) {
            if (!data.isEnabled()) continue;
            checkedItems.add(data);
        }
        if (checkedItems.size() <= 0) {
            return new RulePreferenceData[0];
        }
        RulePreferenceData[] checked = new RulePreferenceData[checkedItems.size()];
        int i = 0;
        while (i < checked.length) {
            checked[i] = (RulePreferenceData)checkedItems.get(i);
            ++i;
        }
        return checked;
    }

    public RulePreferenceData getPreviousElement(RulePreferenceData data) {
        this.sort();
        int i = 0;
        while (i < this.items.size()) {
            RulePreferenceData item = this.items.get(i);
            if (item.equals(data)) {
                try {
                    return this.items.get(i - 1);
                }
                catch (Throwable throwable) {
                    return null;
                }
            }
            ++i;
        }
        return null;
    }

    public RulePreferenceData getNextElement(RulePreferenceData data) {
        this.sort();
        int i = 0;
        while (i < this.items.size()) {
            RulePreferenceData item = this.items.get(i);
            if (item.equals(data)) {
                try {
                    return this.items.get(i + 1);
                }
                catch (Throwable throwable) {
                    return null;
                }
            }
            ++i;
        }
        return null;
    }

    public RulePreferenceData getLastElement() {
        this.sort();
        int index = this.items.size() - 1;
        if (index < 0) {
            return null;
        }
        return this.items.get(index);
    }

    public void add(RulePreferenceData data) {
        int position = 0;
        RulePreferenceData lastElement = this.getLastElement();
        if (lastElement != null) {
            position = lastElement.getPosition() + 1;
        }
        data.setPosition(position);
        this.items.add(data);
        this.sort();
    }

    public void delete(RulePreferenceData data) {
        this.items.remove(data);
        this.sort();
    }

    public void save() {
        this.store.setValue("ITEM_COLORING", PreferenceValueConverter.asString(this.getAllRuleDetails()));
    }

    public void loadDefault() {
        RulePreferenceData[] items = PreferenceValueConverter.asRulePreferenceDataArray(this.store.getDefaultString("ITEM_COLORING"));
        this.items.clear();
        int i = 0;
        while (i < items.length) {
            this.items.add(items[i]);
            ++i;
        }
        this.sort();
    }

    public void load() {
        RulePreferenceData[] items = PreferenceValueConverter.asRulePreferenceDataArray(this.store.getString("ITEM_COLORING"));
        this.items.clear();
        int i = 0;
        while (i < items.length) {
            this.items.add(items[i]);
            ++i;
        }
        this.sort();
    }

    public void removeAll() {
        this.items.clear();
    }

    private void sort() {
        if (this.comparator == null) {
            this.comparator = new DataObjectComparator();
        }
        Collections.sort(this.items, this.comparator);
        int i = 0;
        while (i < this.items.size()) {
            this.items.get(i).setPosition(i);
            ++i;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DataObjectComparator
    implements Comparator<Object> {
        private DataObjectComparator() {
        }

        @Override
        public int compare(Object object1, Object object2) {
            RulePreferenceData data1 = null;
            RulePreferenceData data2 = null;
            if (object1 instanceof RulePreferenceData) {
                data1 = (RulePreferenceData)object1;
            }
            if (object2 instanceof RulePreferenceData) {
                data2 = (RulePreferenceData)object2;
            }
            if (data1 == null | data2 == null) {
                return -1;
            }
            if (data1.getPosition() > data2.getPosition()) {
                return 1;
            }
            if (data1.getPosition() == data2.getPosition()) {
                return 0;
            }
            if (data1.getPosition() < data2.getPosition()) {
                return -1;
            }
            return -1;
        }
    }
}

