/*
 * Decompiled with CFR 0.152.
 */
package de.anbos.eclipse.logviewer.plugin.ui.menu;

import de.anbos.eclipse.logviewer.plugin.LogViewer;
import de.anbos.eclipse.logviewer.plugin.action.ClearHistoryAction;
import de.anbos.eclipse.logviewer.plugin.action.HistoryFileOpenViewAction;
import de.anbos.eclipse.logviewer.plugin.preferences.FileHistoryTracker;
import de.anbos.eclipse.logviewer.plugin.preferences.HistoryFile;
import java.util.List;
import java.util.Vector;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.widgets.Shell;

public class LocalPullDownMenu
implements IMenuListener {
    private static final String FILELIST = "Filelist";
    private static final String SEPARATOR = "Separator";
    private IMenuManager menuManager;
    private LogViewer view;
    private Shell shell;
    private List<Object> actionList;

    public LocalPullDownMenu(IMenuManager menuManager, LogViewer view, Shell shell) {
        this.menuManager = menuManager;
        this.view = view;
        this.shell = shell;
        this.actionList = new Vector<Object>();
        this.menuManager.setRemoveAllWhenShown(true);
        this.menuManager.addMenuListener((IMenuListener)this);
    }

    public void addAction(IAction action) {
        this.actionList.add(action);
    }

    public void addSeparator() {
        this.actionList.add(SEPARATOR);
    }

    public void addFilelist() {
        this.actionList.add(FILELIST);
    }

    public void finalize() {
        this.fillMenu();
    }

    public void menuAboutToShow(IMenuManager manager) {
        this.fillMenu();
    }

    private void fillMenu() {
        boolean historyIsEmpty = true;
        for (Object object : this.actionList) {
            if (object instanceof String) {
                String value = (String)object;
                if (value.equals(SEPARATOR)) {
                    this.menuManager.add((IContributionItem)new Separator());
                }
                if (!value.equals(FILELIST)) continue;
                List<HistoryFile> files = FileHistoryTracker.getInstance().getFiles();
                int i = 0;
                while (i < files.size()) {
                    HistoryFile file = files.get(i);
                    if (file != null) {
                        HistoryFileOpenViewAction action = new HistoryFileOpenViewAction(file, this.view, this.shell);
                        this.menuManager.add((IAction)action);
                        historyIsEmpty = false;
                    }
                    ++i;
                }
                continue;
            }
            if (object instanceof ClearHistoryAction) {
                ((ClearHistoryAction)((Object)object)).setEnabled(!historyIsEmpty);
            }
            this.menuManager.add((IAction)object);
        }
    }
}

