/*
 * Decompiled with CFR 0.152.
 */
package de.anbos.eclipse.logviewer.plugin.viewer;

import de.anbos.eclipse.logviewer.plugin.LogViewerPlugin;
import de.anbos.eclipse.logviewer.plugin.viewer.DamageRepairer;
import de.anbos.eclipse.logviewer.plugin.viewer.DynamicRuleBasedScanner;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.CursorLinePainter;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IPainter;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public class LogFileViewer {
    private TextViewer txtViewer;
    private IDocument document;
    private IPreferenceStore store = LogViewerPlugin.getDefault().getPreferenceStore();
    private CursorLinePainter cursorLinePainter;
    private PresentationReconciler presentationReconciler;
    private boolean showWhenUpdated;
    private boolean showTopOfFile;

    public LogFileViewer(Composite parent, int style) {
        if (this.store.getBoolean("WORD_WRAP")) {
            style |= 0x40;
        }
        this.showWhenUpdated = this.store.getBoolean("SHOW_WHEN_UPDATED");
        this.showTopOfFile = this.store.getBoolean("SHOW_TOP_OF_FILE");
        this.txtViewer = new SourceViewer(parent, null, style);
        FontData[] fontData = PreferenceConverter.getFontDataArray((IPreferenceStore)this.store, (String)"EDITOR_FONT_SYLE");
        if (fontData == null) {
            fontData = JFaceResources.getDefaultFont().getFontData();
        }
        this.txtViewer.getTextWidget().setFont(new Font((Device)Display.getCurrent(), fontData));
        this.store.addPropertyChangeListener((IPropertyChangeListener)new PropertyChangeListener());
        this.createCursorLinePainter();
        this.createAndInstallPresentationReconciler();
    }

    public void setDocument(IDocument document) {
        this.document = document;
        this.txtViewer.setDocument(document);
    }

    public IDocument getDocument() {
        return this.document;
    }

    public TextViewer getActualViewer() {
        return this.txtViewer;
    }

    public Control getControl() {
        return this.txtViewer.getControl();
    }

    public ISelection getSelection() {
        return this.txtViewer.getSelection();
    }

    public int getTopIndex() {
        return this.txtViewer.getTopIndex();
    }

    public void refresh() {
        this.txtViewer.refresh();
    }

    public void setSelection(ISelection sel) {
        this.txtViewer.setSelection(sel);
    }

    public void showTopOfFile() {
        this.txtViewer.setTopIndex(0);
    }

    public void showBottomOfFile() {
        this.txtViewer.setTopIndex(this.document.getNumberOfLines());
    }

    public void showTopOrBottomOfFile() {
        if (this.isShowTopOfFile()) {
            this.showTopOfFile();
        } else {
            this.showBottomOfFile();
        }
    }

    public void setTopIndex(int index) {
        this.txtViewer.setTopIndex(index);
    }

    public boolean isShowWhenUpdated() {
        return this.showWhenUpdated;
    }

    public boolean isShowTopOfFile() {
        return this.showTopOfFile;
    }

    private void createCursorLinePainter() {
        this.cursorLinePainter = new CursorLinePainter((ITextViewer)this.txtViewer);
        Color color = new Color((Device)Display.getCurrent(), PreferenceConverter.getColor((IPreferenceStore)this.store, (String)"CURSOR_LINE_COLOR"));
        this.cursorLinePainter.setHighlightColor(color);
        TextViewer extension = this.txtViewer;
        extension.addPainter((IPainter)this.cursorLinePainter);
    }

    private void createAndInstallPresentationReconciler() {
        this.presentationReconciler = new PresentationReconciler();
        DamageRepairer dr = new DamageRepairer(new DynamicRuleBasedScanner(this.store.getString("ITEM_COLORING")));
        this.presentationReconciler.setDamager((IPresentationDamager)dr, "__dftl_partition_content_type");
        this.presentationReconciler.setRepairer((IPresentationRepairer)dr, "__dftl_partition_content_type");
        this.presentationReconciler.install((ITextViewer)this.txtViewer);
    }

    private class PropertyChangeListener
    implements IPropertyChangeListener {
        private PropertyChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent event) {
            if (event.getProperty().equals("CURSOR_LINE_COLOR")) {
                Color color = new Color((Device)Display.getCurrent(), PreferenceConverter.getColor((IPreferenceStore)LogFileViewer.this.store, (String)"CURSOR_LINE_COLOR"));
                LogFileViewer.this.cursorLinePainter.setHighlightColor(color);
            }
            if (event.getProperty().equals("EDITOR_FONT_SYLE")) {
                FontData[] fontData = PreferenceConverter.getFontDataArray((IPreferenceStore)LogFileViewer.this.store, (String)"EDITOR_FONT_SYLE");
                LogFileViewer.this.txtViewer.getTextWidget().setFont(new Font((Device)Display.getCurrent(), fontData));
            }
            if (event.getProperty().equals("WORD_WRAP")) {
                boolean wordWrap = LogFileViewer.this.store.getBoolean("WORD_WRAP");
                LogFileViewer.this.txtViewer.getTextWidget().setWordWrap(wordWrap);
            }
            if (event.getProperty().equals("SHOW_WHEN_UPDATED")) {
                LogFileViewer.this.showWhenUpdated = LogFileViewer.this.store.getBoolean("SHOW_WHEN_UPDATED");
            }
            if (event.getProperty().equals("SHOW_TOP_OF_FILE")) {
                LogFileViewer.this.showTopOfFile = LogFileViewer.this.store.getBoolean("SHOW_TOP_OF_FILE");
            }
        }
    }
}

