/*
 * Decompiled with CFR 0.152.
 */
package de.anbos.eclipse.logviewer.plugin.viewer.rule;

import de.anbos.eclipse.logviewer.plugin.viewer.rule.ILogFileToolRule;
import de.anbos.eclipse.logviewer.plugin.viewer.rule.LogToolRuleDesc;
import de.anbos.eclipse.logviewer.plugin.viewer.rule.TextAttributeFactory;
import de.anbos.eclipse.logviewer.plugin.viewer.rule.TokenData;
import java.util.regex.Pattern;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IPredicateRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;

public class JavaRegExpRule
implements IPredicateRule,
ILogFileToolRule {
    private Pattern regexp;
    private boolean find;
    private Token successToken;
    private int priority;

    public JavaRegExpRule(LogToolRuleDesc ruleDesc) {
        int flags = 0;
        this.find = false;
        if (ruleDesc.isCaseInsensitive()) {
            flags = 66;
        }
        if (ruleDesc.getMatchMode().startsWith("find")) {
            this.find = true;
        }
        this.regexp = Pattern.compile(ruleDesc.getRuleValue(), flags);
        this.priority = ruleDesc.getPriority();
        this.successToken = new Token((Object)new TokenData(TextAttributeFactory.getTextAttribute(ruleDesc), this.priority));
    }

    public IToken getSuccessToken() {
        return this.successToken;
    }

    public IToken evaluate(ICharacterScanner scanner, boolean resume) {
        String line = this.returnNextCompleteLine(scanner);
        if (line != null && (this.find ? this.regexp.matcher(line).find() : this.regexp.matcher(line).matches())) {
            return this.successToken;
        }
        return Token.UNDEFINED;
    }

    public IToken evaluate(ICharacterScanner scanner) {
        return this.evaluate(scanner, false);
    }

    public int getPriority() {
        return this.priority;
    }

    private String returnNextCompleteLine(ICharacterScanner scanner) {
        int c;
        char[][] lineDelimiters = scanner.getLegalLineDelimiters();
        StringBuffer buffer = new StringBuffer();
        while ((c = scanner.read()) != -1) {
            if (this.isEOLCharacter(c, lineDelimiters)) {
                return buffer.toString();
            }
            buffer.append((char)c);
        }
        return null;
    }

    private boolean isEOLCharacter(int c, char[][] eolChars) {
        int i = 0;
        while (i < eolChars.length) {
            if (c == eolChars[i][0]) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

