/*
 * Decompiled with CFR 0.152.
 */
package de.anbos.eclipse.logviewer.plugin.viewer.rule;

import de.anbos.eclipse.logviewer.plugin.LogViewerPlugin;
import de.anbos.eclipse.logviewer.plugin.viewer.rule.ILogFileToolRule;
import de.anbos.eclipse.logviewer.plugin.viewer.rule.JakartaRegExpRule;
import de.anbos.eclipse.logviewer.plugin.viewer.rule.JavaRegExpRule;
import de.anbos.eclipse.logviewer.plugin.viewer.rule.LogToolRuleDesc;
import de.anbos.eclipse.logviewer.plugin.viewer.rule.WordRule;

public class RuleFactory {
    private static final String[] RULES = new String[]{LogViewerPlugin.getResourceString(WordRule.class.getName()), LogViewerPlugin.getResourceString(JakartaRegExpRule.class.getName()), LogViewerPlugin.getResourceString(JavaRegExpRule.class.getName())};

    public static ILogFileToolRule getRule(String ruleName, LogToolRuleDesc ruleDesc) {
        if (ruleDesc.isEnabled()) {
            if (RuleFactory.isWordRule(ruleName)) {
                return RuleFactory.getWordRule(ruleDesc);
            }
            if (RuleFactory.isJakartaRegExpRule(ruleName)) {
                return RuleFactory.getJakartaRegExpRule(ruleDesc);
            }
            if (RuleFactory.isJavaRegExpRule(ruleName)) {
                return RuleFactory.getJavaRegExpRule(ruleDesc);
            }
        }
        return null;
    }

    public static boolean isWordRule(String ruleName) {
        return ruleName.equals(WordRule.class.getName());
    }

    public static WordRule getWordRule(LogToolRuleDesc ruleDesc) {
        return new WordRule(ruleDesc);
    }

    public static boolean isJakartaRegExpRule(String ruleName) {
        return ruleName.equals(JakartaRegExpRule.class.getName());
    }

    public static JakartaRegExpRule getJakartaRegExpRule(LogToolRuleDesc ruleDesc) {
        return new JakartaRegExpRule(ruleDesc);
    }

    public static boolean isJavaRegExpRule(String ruleName) {
        return ruleName.equals(JavaRegExpRule.class.getName());
    }

    public static JavaRegExpRule getJavaRegExpRule(LogToolRuleDesc ruleDesc) {
        return new JavaRegExpRule(ruleDesc);
    }

    public static String[] getAllRulesAsComboNames() {
        return RULES;
    }

    public static String getDefaultRule() {
        return RULES[0];
    }
}

