/*
 * Decompiled with CFR 0.152.
 */
package mnita.ansiconsole;

import java.text.NumberFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import mnita.ansiconsole.AnsiConsoleUtils;
import mnita.ansiconsole.preferences.AnsiConsolePreferenceUtils;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.ui.console.IConsolePageParticipant;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Version;

public class AnsiConsoleActivator
extends AbstractUIPlugin {
    private static AnsiConsoleActivator plugin;
    private static boolean showWarning;
    private static boolean showAnsiConsoleWarning;
    private static boolean pluginDisabled;
    private final Map<StyledText, IConsolePageParticipant> viewers = new HashMap<StyledText, IConsolePageParticipant>();

    static {
        showWarning = true;
        showAnsiConsoleWarning = true;
        pluginDisabled = false;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        AnsiConsoleActivator.checkNativeConsoleAnsiSupport();
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static AnsiConsoleActivator getDefault() {
        return plugin;
    }

    public static boolean isDisabled() {
        return pluginDisabled;
    }

    public void addViewer(StyledText viewer, IConsolePageParticipant participant) {
        this.viewers.put(viewer, participant);
        AnsiConsoleActivator.checkConsolePerformanceSettings();
    }

    public void removeViewerWithPageParticipant(IConsolePageParticipant participant) {
        HashSet<StyledText> toRemove = new HashSet<StyledText>();
        for (Map.Entry<StyledText, IConsolePageParticipant> entry : this.viewers.entrySet()) {
            if (entry.getValue() != participant) continue;
            toRemove.add(entry.getKey());
        }
        for (StyledText viewer : toRemove) {
            this.viewers.remove(viewer);
        }
    }

    private static void checkConsolePerformanceSettings() {
        if (!showWarning) {
            return;
        }
        if (!AnsiConsolePreferenceUtils.isPerformanceWarningEnabled()) {
            return;
        }
        String indent = "\u00a0\u00a0\u00a0\u00a0";
        String where = AnsiConsoleUtils.isMacOS() ? "Main menu \u2192 \u201cEclipse\u201d \u2192 \u201cPreferences...\u201d \u2192 \u201cRun Debug\u201d \u2192 \u201cConsole\u201d\n" : "Main menu \u2192 \u201cWindow\u201d \u2192 \u201cPreferences\u201d \u2192 \u201cRun/Debug\u201d \u2192 \u201cConsole\u201d\n";
        StringBuffer message = new StringBuffer();
        int wattermarkLevel = AnsiConsolePreferenceUtils.getWattermarkLevel();
        if (wattermarkLevel < 150000) {
            NumberFormat nf = NumberFormat.getInstance();
            message.append(String.format("\nConsole buffer size too low (%s). About 2 times slower.\n\n" + where + indent + "\u2022 Check \u201cLimit console output\u201d\n" + indent + "\u2022 Set \u201cConsole buffer size (characters)\u201d to a bigger value.\n" + indent + "\u00a0\u00a0\u00a0The sweet spot seems to be around %s\n" + "or\n" + indent + "\u2022 Uncheck \u201cLimit console output\u201d\n" + indent + "\u00a0\u00a0\u00a0No noticeable performance difference compared to %s\n", nf.format(wattermarkLevel), nf.format(1000000L), nf.format(1000000L)));
        }
        if (AnsiConsolePreferenceUtils.isWordWrapEnabled()) {
            message.append("\nWord wrap enabled. Up to 20 times slower!!!\n\n" + indent + where + indent + "\u2022 Uncheck \u201cEnable word wrap\u201d\n");
        }
        if (message.length() > 0) {
            showWarning = false;
            AnsiConsoleUtils.showDialogAsync("CONSOLE PERFORMANCE WARNING (from Ansi Console)!\n" + message, AnsiConsolePreferenceUtils::setEnablePerformanceWarning, false);
        }
    }

    private static void checkNativeConsoleAnsiSupport() {
        Version ansiVer;
        if (!showAnsiConsoleWarning) {
            return;
        }
        showAnsiConsoleWarning = false;
        Bundle consoleBundle = Platform.getBundle((String)"org.eclipse.ui.console");
        if (consoleBundle == null) {
            return;
        }
        Version currentVer = consoleBundle.getVersion();
        if (currentVer.compareTo(ansiVer = new Version(3, 11, 300, "v20220804-1122")) < 0) {
            return;
        }
        String indent = "\u00a0\u00a0\u00a0\u00a0";
        String where = AnsiConsoleUtils.isMacOS() ? "Main menu \u2192 \u201cEclipse\u201d \u2192 \u201cAbout Eclipse\u201d \u2192 \u201cInstallation Details\u201d\n" : "Main menu \u2192 \u201cHelp\u201d \u2192 \u201cAbout Eclipse\u201d \u2192 \u201cInstallation Details\u201d\n";
        String message = "Starting with the 2022-09 release Eclipse supports ANSI escapes in console.\n\nSo this plugin is redundant, uninstall it to prevent conflicts:\n" + indent + where + indent + "Select \u201cAnsi Console\u201d \u2192 click \u201cUninstall...\u201d\n" + "\n" + "For now this plugin disabled itself.\n";
        AnsiConsoleUtils.showDialogAsync("ANSI CONSOLE WARNING!\n\n" + message, null, true);
        pluginDisabled = true;
    }
}

