/*
 * Decompiled with CFR 0.152.
 */
package mnita.ansiconsole;

import java.util.function.Consumer;
import java.util.regex.Pattern;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class AnsiConsoleUtils {
    public static final Pattern ESCAPE_SEQUENCE_REGEX_TXT = Pattern.compile("\u001b\\[[\\d;]*[A-HJKSTfimnsu]");
    public static final Pattern ESCAPE_SEQUENCE_REGEX_RTF = Pattern.compile("\\{\\\\cf\\d+[^}]* \u001b\\[[\\d;]*[A-HJKSTfimnsu][^}]*\\}");
    public static final Pattern ESCAPE_SEQUENCE_REGEX_RTF_FIX_SRC = Pattern.compile("\\\\chshdng\\d+\\\\chcbpat(\\d+)");
    public static final String ESCAPE_SEQUENCE_REGEX_RTF_FIX_TRG = "$0\\\\cb$1";
    private static final String DLG_TITLE = "Ansi Console";
    static final String[] DLG_BUTTONS = new String[]{"Remind me later", "Never remind me again"};
    static final String[] DLG_BUTTONS_OK = new String[]{"OK"};
    public static final char ESCAPE_SGR = 'm';

    private AnsiConsoleUtils() {
    }

    public static boolean isWindows() {
        return "win32".equals(SWT.getPlatform());
    }

    public static boolean isMacOS() {
        return "cocoa".equals(SWT.getPlatform());
    }

    public static boolean isGTK() {
        return "gtk".equals(SWT.getPlatform());
    }

    public static void showDialogAsync(final String message, final Consumer<Boolean> func, final boolean onlyOkButton) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                MessageDialog dlg = new MessageDialog(window.getShell(), AnsiConsoleUtils.DLG_TITLE, null, message, 4, 0, onlyOkButton ? DLG_BUTTONS_OK : DLG_BUTTONS);
                if (dlg.open() == 1 && func != null) {
                    func.accept(false);
                }
            }
        });
    }
}

