/*
 * Decompiled with CFR 0.152.
 */
package mnita.ansiconsole.participants;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import mnita.ansiconsole.utils.AnsiConsoleAttributes;
import mnita.ansiconsole.utils.AnsiConsoleColorPalette;
import org.eclipse.jface.text.Position;

public class AnsiPosition
extends Position {
    public static final String POSITION_NAME = "ansi_color";
    private static final AnsiConsoleAttributes current = new AnsiConsoleAttributes();
    public final AnsiConsoleAttributes attributes;
    public final String text;

    public AnsiPosition(int offset, String text) {
        super(offset, text == null ? 0 : text.length());
        this.text = text == null ? "" : text;
        this.attributes = this.updateAttributes();
    }

    public String toString() {
        return String.format("AnsiPosition:{ offset:%d length:%d text:\"%s\" attr:\"%s\" }", this.offset, this.length, this.text, this.attributes);
    }

    private static List<Integer> parseSemicolonSeparatedIntList(String text) {
        ArrayList<Integer> result = new ArrayList<Integer>(10);
        int crtValue = 0;
        int i = 0;
        while (i < text.length()) {
            char ch = text.charAt(i);
            if (ch >= '0' && ch <= '9') {
                crtValue *= 10;
                crtValue += ch - 48;
            } else {
                result.add(crtValue);
                crtValue = 0;
            }
            ++i;
        }
        result.add(crtValue);
        return result;
    }

    private AnsiConsoleAttributes updateAttributes() {
        char code = this.text.charAt(this.text.length() - 1);
        if (code == 'm') {
            String theEscape = this.text.substring(2, this.text.length() - 1);
            AnsiPosition.interpretCommand(AnsiPosition.parseSemicolonSeparatedIntList(theEscape));
            return AnsiConsoleAttributes.from(current);
        }
        return null;
    }

    private static void interpretCommand(List<Integer> nCommands) {
        Iterator<Integer> iter = nCommands.iterator();
        block22: while (iter.hasNext()) {
            int nCmd = iter.next();
            switch (nCmd) {
                case 0: {
                    current.reset();
                    break;
                }
                case 1: {
                    AnsiPosition.current.bold = true;
                    break;
                }
                case 2: 
                case 22: {
                    AnsiPosition.current.bold = false;
                    break;
                }
                case 3: {
                    AnsiPosition.current.italic = true;
                    break;
                }
                case 23: {
                    AnsiPosition.current.italic = false;
                    break;
                }
                case 4: {
                    AnsiPosition.current.underline = 0;
                    break;
                }
                case 21: {
                    AnsiPosition.current.underline = 1;
                    break;
                }
                case 24: {
                    AnsiPosition.current.underline = -1;
                    break;
                }
                case 9: {
                    AnsiPosition.current.strike = true;
                    break;
                }
                case 29: {
                    AnsiPosition.current.strike = false;
                    break;
                }
                case 7: {
                    AnsiPosition.current.invert = true;
                    break;
                }
                case 27: {
                    AnsiPosition.current.invert = false;
                    break;
                }
                case 8: {
                    AnsiPosition.current.conceal = true;
                    break;
                }
                case 28: {
                    AnsiPosition.current.conceal = false;
                    break;
                }
                case 51: {
                    AnsiPosition.current.framed = true;
                    break;
                }
                case 54: {
                    AnsiPosition.current.framed = false;
                    break;
                }
                case 39: {
                    AnsiPosition.current.currentFgColor = null;
                    break;
                }
                case 49: {
                    AnsiPosition.current.currentBgColor = null;
                    break;
                }
                case 38: 
                case 48: {
                    int nMustBe2or5;
                    int color = -1;
                    int n = nMustBe2or5 = iter.hasNext() ? iter.next() : -1;
                    if (nMustBe2or5 == 5) {
                        int n2 = color = iter.hasNext() ? iter.next() : -1;
                        if (!AnsiConsoleColorPalette.isValidIndex(color)) {
                            color = -1;
                        }
                    } else if (nMustBe2or5 == 2) {
                        int r = iter.hasNext() ? iter.next() : -1;
                        int g = iter.hasNext() ? iter.next() : -1;
                        int b = iter.hasNext() ? iter.next() : -1;
                        color = AnsiConsoleColorPalette.hackRgb(r, g, b);
                    }
                    if (color == -1) continue block22;
                    if (nCmd == 38) {
                        AnsiPosition.current.currentFgColor = color;
                        break;
                    }
                    AnsiPosition.current.currentBgColor = color;
                    break;
                }
                case -1: {
                    break;
                }
                default: {
                    if (nCmd >= 30 && nCmd <= 37) {
                        AnsiPosition.current.currentFgColor = nCmd - 30;
                        break;
                    }
                    if (nCmd >= 40 && nCmd <= 47) {
                        AnsiPosition.current.currentBgColor = nCmd - 40;
                        break;
                    }
                    if (nCmd >= 90 && nCmd <= 97) {
                        AnsiPosition.current.currentFgColor = nCmd - 90 + 8;
                        break;
                    }
                    if (nCmd < 100 || nCmd > 107) continue block22;
                    AnsiPosition.current.currentBgColor = nCmd - 100 + 8;
                }
            }
        }
    }
}

