/*
 * Decompiled with CFR 0.152.
 */
package mnita.ansiconsole.preferences;

import java.net.URL;
import mnita.ansiconsole.AnsiConsoleActivator;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.ComboFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.IHandlerService;

public class AnsiConsolePreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private BooleanFieldEditor fAnsiEnabled;
    private BooleanFieldEditor fWindowsMapping;
    private BooleanFieldEditor fShowEscapes;
    private BooleanFieldEditor fKeepStderrColor;
    private BooleanFieldEditor fRtfInClipboard;
    private ComboFieldEditor fColorPalette;
    private BooleanFieldEditor fCheckPerformance;
    private BooleanFieldEditor fCheckM2e;

    public AnsiConsolePreferencePage() {
        super(1);
        this.setPreferenceStore(AnsiConsoleActivator.getDefault().getPreferenceStore());
        this.setDescription("Preferences for Ansi Console");
    }

    public void createFieldEditors() {
        Composite parent = this.getFieldEditorParent();
        this.fAnsiEnabled = new BooleanFieldEditor("booleanEnabled", "Plugin enabled", parent);
        this.addField((FieldEditor)this.fAnsiEnabled);
        this.fWindowsMapping = new BooleanFieldEditor("booleanWindowsMapping", "Use &Windows color mapping (bold => intense, italic => reverse)", parent);
        this.addField((FieldEditor)this.fWindowsMapping);
        this.fShowEscapes = new BooleanFieldEditor("booleanShowEscapes", "&Show the escape sequences", parent);
        this.addField((FieldEditor)this.fShowEscapes);
        this.fKeepStderrColor = new BooleanFieldEditor("booleanKeepStderrColor", "&Try using the standard error color setting for stderr output", parent);
        this.addField((FieldEditor)this.fKeepStderrColor);
        this.fRtfInClipboard = new BooleanFieldEditor("booleanPutRtfInClipboard", "Put &RTF in Clipboard. You will be able to paste styled text in some applications.", parent);
        this.addField((FieldEditor)this.fRtfInClipboard);
        this.fColorPalette = new ComboFieldEditor("choiceColorPalette", "&Color palette:", (String[][])new String[][]{{"Standard VGA colors", "paletteVGA"}, {"Windows XP command prompt", "paletteXP"}, {"Windows 10 command prompt", "paletteWin10"}, {"Mac OS X Terminal.app", "paletteMac"}, {"PuTTY", "palettePuTTY"}, {"xterm", "paletteXTerm"}, {"mIRC", "paletteMirc"}, {"Ubuntu", "paletteUbuntu"}}, parent);
        this.addField((FieldEditor)this.fColorPalette);
        AnsiConsolePreferencePage.createSeparator(parent);
        this.fCheckPerformance = new BooleanFieldEditor("booleanPerformanceWarningEnabled", "Enable performance check (\u201cConsole buffer size\u201d)", parent);
        this.addField((FieldEditor)this.fCheckPerformance);
        this.fCheckM2e = new BooleanFieldEditor("booleanM2eChromaticCoreWarningEnabled", "Enable check for the \u201cM2E Chromatic Core Plugin\u201d", parent);
        this.addField((FieldEditor)this.fCheckM2e);
        AnsiConsolePreferencePage.createSeparator(parent);
        AnsiConsolePreferencePage.createLink(parent, true, "<a href=\"https://github.com/mihnita/ansi-econsole/wiki/\">Home page</a>: some documentation, release notes, etc.");
        AnsiConsolePreferencePage.createLink(parent, false, "<a href=\"https://github.com/mihnita/ansi-econsole/\">GitHub page</a>: source code, report issues, etc.");
        AnsiConsolePreferencePage.createLink(parent, false, "<a href=\"https://marketplace.eclipse.org/content/ansi-escape-console\">Eclipse Marketplace</a>: give it a star / review if you like it :-).");
    }

    public void init(IWorkbench workbench) {
    }

    protected void initialize() {
        super.initialize();
        this.enableDisableAll();
    }

    private static void createSeparator(Composite parent) {
        new Label(parent, 0);
    }

    private static void createLink(Composite parent, boolean fillGap, String text) {
        Link link = new Link(parent, 64);
        link.setText(text);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.grabExcessVerticalSpace = fillGap;
        gridData.verticalAlignment = 1024;
        link.setLayoutData((Object)gridData);
        link.addListener(13, event -> {
            try {
                PlatformUI.getWorkbench().getBrowserSupport().getExternalBrowser().openURL(new URL(event.text));
            }
            catch (Exception e) {
                System.out.println("AnsiConsole: error opening url in browser.URL: " + event.text + "Error: " + e.getMessage());
            }
        });
    }

    public boolean performOk() {
        boolean result = super.performOk();
        IHandlerService handlerService = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
        try {
            handlerService.executeCommand("AnsiConsole.command.enable_disable", new Event());
        }
        catch (Exception ex) {
            System.out.println("AnsiConsole: Command 'AnsiConsole.command.enable_disable' not found");
        }
        return result;
    }

    public void propertyChange(PropertyChangeEvent event) {
        super.propertyChange(event);
        Object source = event.getSource();
        if (source != null && source.equals(this.fAnsiEnabled)) {
            this.enableDisableAll();
        }
    }

    private void enableDisableAll() {
        Composite parent = this.getFieldEditorParent();
        boolean enable = this.fAnsiEnabled.getBooleanValue();
        this.fWindowsMapping.setEnabled(enable, parent);
        this.fShowEscapes.setEnabled(enable, parent);
        this.fKeepStderrColor.setEnabled(enable, parent);
        this.fRtfInClipboard.setEnabled(enable, parent);
        this.fColorPalette.setEnabled(enable, parent);
        this.fCheckPerformance.setEnabled(enable, parent);
        this.fCheckM2e.setEnabled(enable, parent);
    }
}

