/*
 * Decompiled with CFR 0.152.
 */
package mnita.ansiconsole.preferences;

import mnita.ansiconsole.AnsiConsoleActivator;
import mnita.ansiconsole.utils.AnsiConsoleColorPalette;
import mnita.ansiconsole.utils.ColorCache;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class AnsiConsolePreferenceUtils {
    private static final String ECLIPSE_UI_WORKBENCH = "org.eclipse.ui.workbench";
    private static final String ECLIPSE_UI_CONSOLE = "org.eclipse.ui.console";
    private static final String ECLIPSE_DEBUG_UI = "org.eclipse.debug.ui";
    private static final String ECLIPSE_CDT_UI = "org.eclipse.cdt.ui";
    private static final String DEBUG_CONSOLE_FALLBACK_BKCOLOR = "47,47,47";
    private static final String DEBUG_CONSOLE_FALLBACK_FGCOLOR = "192,192,192";
    private static final String DEBUG_CONSOLE_FALLBACK_ERRCOLOR = "255,0,0";
    private static final String DEBUG_CONSOLE_FALLBACK_LINK_COLOR = "111,197,238";
    private static final IPreferenceStore PREF_STORE = AnsiConsoleActivator.getDefault().getPreferenceStore();
    private static Color debugConsoleBgColor = null;
    private static Color debugConsoleFgColor = null;
    private static Color debugConsoleErrorColor = null;
    private static Color hyperlinkColor = null;
    private static Color cdtOutputStreamColor = null;
    private static String getPreferredPalette = AnsiConsoleColorPalette.getBestPaletteForOS();
    private static boolean useWindowsMapping = false;
    private static boolean showAnsiEscapes = false;
    private static boolean tryPreservingStdErrColor = true;
    private static boolean isAnsiConsoleEnabled = true;
    private static boolean clipboardPutRtf = true;

    static {
        AnsiConsolePreferenceUtils.refresh();
        PREF_STORE.addPropertyChangeListener(evt -> AnsiConsolePreferenceUtils.refresh());
        ScopedPreferenceStore preferenceStoreDebug = new ScopedPreferenceStore(InstanceScope.INSTANCE, ECLIPSE_DEBUG_UI);
        ScopedPreferenceStore preferenceStoreWorkbench = new ScopedPreferenceStore(InstanceScope.INSTANCE, ECLIPSE_UI_WORKBENCH);
        preferenceStoreWorkbench.addPropertyChangeListener(evt -> AnsiConsolePreferenceUtils.refresh());
        preferenceStoreDebug.addPropertyChangeListener(evt -> AnsiConsolePreferenceUtils.refresh());
    }

    private AnsiConsolePreferenceUtils() {
    }

    private static Color colorFromStringRgb(String strRgb) {
        Color result = null;
        String[] splitted = strRgb.split(",");
        if (splitted != null && splitted.length == 3) {
            int red = AnsiConsolePreferenceUtils.tryParseInteger(splitted[0]);
            int green = AnsiConsolePreferenceUtils.tryParseInteger(splitted[1]);
            int blue = AnsiConsolePreferenceUtils.tryParseInteger(splitted[2]);
            result = ColorCache.get(new RGB(red, green, blue));
        }
        return result;
    }

    public static int tryParseInteger(String text) {
        if ("".equals(text)) {
            return -1;
        }
        try {
            return Integer.parseInt(text);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    public static Color getDebugConsoleBgColor() {
        return debugConsoleBgColor;
    }

    public static Color getDebugConsoleFgColor() {
        return debugConsoleFgColor;
    }

    public static Color getDebugConsoleErrorColor() {
        return debugConsoleErrorColor;
    }

    public static Color getHyperlinkColor() {
        return hyperlinkColor;
    }

    public static Color getCdtOutputStreamColor() {
        return cdtOutputStreamColor;
    }

    public static boolean putRtfInClipboard() {
        return clipboardPutRtf;
    }

    public static boolean isAnsiConsoleEnabled() {
        return isAnsiConsoleEnabled;
    }

    public static void setAnsiConsoleEnabled(boolean enabled) {
        isAnsiConsoleEnabled = enabled;
        PREF_STORE.setValue("booleanEnabled", enabled);
    }

    public static boolean useWindowsMapping() {
        return useWindowsMapping;
    }

    public static String getPreferredPalette() {
        return getPreferredPalette;
    }

    public static boolean showAnsiEscapes() {
        return showAnsiEscapes;
    }

    public static boolean tryPreservingStdErrColor() {
        return tryPreservingStdErrColor;
    }

    public static int getWattermarkLevel() {
        IPreferencesService prefServices = Platform.getPreferencesService();
        if (prefServices.getBoolean(ECLIPSE_DEBUG_UI, "Console.limitConsoleOutput", true, null)) {
            return prefServices.getInt(ECLIPSE_DEBUG_UI, "Console.lowWaterMark", 80000, null);
        }
        return Integer.MAX_VALUE;
    }

    public static boolean isWordWrapEnabled() {
        IPreferencesService prefServices = Platform.getPreferencesService();
        return prefServices.getBoolean(ECLIPSE_UI_CONSOLE, "org.eclipse.ui.console.P_CONSOLE_WORD_WRAP", false, null);
    }

    public static boolean isPerformanceWarningEnabled() {
        return PREF_STORE.getBoolean("booleanPerformanceWarningEnabled");
    }

    public static void setEnablePerformanceWarning(boolean newValue) {
        PREF_STORE.setValue("booleanPerformanceWarningEnabled", newValue);
    }

    public static boolean isM2eChromaticCoreWarningEnabled() {
        return PREF_STORE.getBoolean("booleanM2eChromaticCoreWarningEnabled");
    }

    public static void setEnableM2eChromaticCoreWarning(boolean newValue) {
        PREF_STORE.setValue("booleanM2eChromaticCoreWarningEnabled", newValue);
    }

    public static void refresh() {
        IPreferencesService prefServices = Platform.getPreferencesService();
        String value = prefServices.getString(ECLIPSE_DEBUG_UI, "org.eclipse.debug.ui.consoleBackground", DEBUG_CONSOLE_FALLBACK_BKCOLOR, null);
        debugConsoleBgColor = AnsiConsolePreferenceUtils.colorFromStringRgb(value);
        value = prefServices.getString(ECLIPSE_DEBUG_UI, "org.eclipse.debug.ui.outColor", DEBUG_CONSOLE_FALLBACK_FGCOLOR, null);
        debugConsoleFgColor = AnsiConsolePreferenceUtils.colorFromStringRgb(value);
        value = prefServices.getString(ECLIPSE_DEBUG_UI, "org.eclipse.debug.ui.errorColor", DEBUG_CONSOLE_FALLBACK_ERRCOLOR, null);
        debugConsoleErrorColor = AnsiConsolePreferenceUtils.colorFromStringRgb(value);
        value = prefServices.getString(ECLIPSE_UI_WORKBENCH, "HYPERLINK_COLOR", DEBUG_CONSOLE_FALLBACK_LINK_COLOR, null);
        hyperlinkColor = AnsiConsolePreferenceUtils.colorFromStringRgb(value);
        value = prefServices.getString(ECLIPSE_CDT_UI, "buildConsoleOutputStreamColor", "", null);
        cdtOutputStreamColor = value.isEmpty() ? null : AnsiConsolePreferenceUtils.colorFromStringRgb(value);
        useWindowsMapping = PREF_STORE.getBoolean("booleanWindowsMapping");
        getPreferredPalette = PREF_STORE.getString("choiceColorPalette");
        showAnsiEscapes = PREF_STORE.getBoolean("booleanShowEscapes");
        tryPreservingStdErrColor = PREF_STORE.getBoolean("booleanKeepStderrColor");
        isAnsiConsoleEnabled = PREF_STORE.getBoolean("booleanEnabled");
        clipboardPutRtf = PREF_STORE.getBoolean("booleanPutRtfInClipboard");
    }
}

