/*
 * Decompiled with CFR 0.152.
 */
package mnita.ansiconsole.utils;

import mnita.ansiconsole.preferences.AnsiConsolePreferenceUtils;
import mnita.ansiconsole.utils.AnsiConsoleColorPalette;
import mnita.ansiconsole.utils.ColorCache;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;

public class AnsiConsoleAttributes {
    public static final int UNDERLINE_NONE = -1;
    public Integer currentBgColor;
    public Integer currentFgColor;
    public int underline;
    public boolean bold;
    public boolean italic;
    public boolean invert;
    public boolean conceal;
    public boolean strike;
    public boolean framed;

    public AnsiConsoleAttributes() {
        this.reset();
    }

    public void reset() {
        this.currentBgColor = null;
        this.currentFgColor = null;
        this.underline = -1;
        this.bold = false;
        this.italic = false;
        this.invert = false;
        this.conceal = false;
        this.strike = false;
        this.framed = false;
    }

    public static AnsiConsoleAttributes from(AnsiConsoleAttributes other) {
        AnsiConsoleAttributes result = new AnsiConsoleAttributes();
        if (other != null) {
            result.currentBgColor = other.currentBgColor;
            result.currentFgColor = other.currentFgColor;
            result.underline = other.underline;
            result.bold = other.bold;
            result.italic = other.italic;
            result.invert = other.invert;
            result.conceal = other.conceal;
            result.strike = other.strike;
            result.framed = other.framed;
        }
        return result;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        if (this.currentBgColor != null) {
            result.append("Bg" + this.currentBgColor);
        }
        if (this.currentFgColor != null) {
            result.append("Fg" + this.currentFgColor);
        }
        if (this.underline != -1) {
            result.append("_");
        }
        if (this.bold) {
            result.append("B");
        }
        if (this.italic) {
            result.append("I");
        }
        if (this.invert) {
            result.append("!");
        }
        if (this.conceal) {
            result.append("H");
        }
        if (this.strike) {
            result.append("-");
        }
        if (this.framed) {
            result.append("[]");
        }
        return result.toString();
    }

    private static Color hiliteRgbColor(Color color) {
        if (color == null) {
            return ColorCache.get(new RGB(255, 255, 255));
        }
        int red = color.getRed() * 2;
        int green = color.getGreen() * 2;
        int blue = color.getBlue() * 2;
        if (red > 255) {
            red = 255;
        }
        if (green > 255) {
            green = 255;
        }
        if (blue > 255) {
            blue = 255;
        }
        return ColorCache.get(new RGB(red, green, blue));
    }

    public static void updateRangeStyle(StyleRange range, AnsiConsoleAttributes attribute) {
        if (attribute == null) {
            return;
        }
        AnsiConsoleAttributes tempAttrib = AnsiConsoleAttributes.from(attribute);
        boolean hilite = false;
        if (AnsiConsolePreferenceUtils.useWindowsMapping()) {
            if (tempAttrib.bold) {
                tempAttrib.bold = false;
                hilite = true;
            }
            if (tempAttrib.italic) {
                tempAttrib.italic = false;
                tempAttrib.invert = true;
            }
            tempAttrib.underline = -1;
            tempAttrib.strike = false;
            tempAttrib.framed = false;
        }
        if (hilite) {
            if (tempAttrib.currentFgColor == null) {
                range.foreground = AnsiConsolePreferenceUtils.getDebugConsoleFgColor();
                range.foreground = AnsiConsoleAttributes.hiliteRgbColor(range.foreground);
            } else {
                range.foreground = tempAttrib.currentFgColor < 8 ? ColorCache.get(AnsiConsoleColorPalette.getColor(tempAttrib.currentFgColor + 8)) : ColorCache.get(AnsiConsoleColorPalette.getColor(tempAttrib.currentFgColor));
            }
        } else if (tempAttrib.currentFgColor != null) {
            range.foreground = ColorCache.get(AnsiConsoleColorPalette.getColor(tempAttrib.currentFgColor));
        }
        if (tempAttrib.currentBgColor != null) {
            range.background = ColorCache.get(AnsiConsoleColorPalette.getColor(tempAttrib.currentBgColor));
        }
        if (tempAttrib.invert) {
            if (range.foreground == null) {
                range.foreground = AnsiConsolePreferenceUtils.getDebugConsoleFgColor();
            }
            if (range.background == null) {
                range.background = AnsiConsolePreferenceUtils.getDebugConsoleBgColor();
            }
            Color tmp = range.background;
            range.background = range.foreground;
            range.foreground = tmp;
        }
        if (tempAttrib.conceal) {
            if (range.background == null) {
                range.background = AnsiConsolePreferenceUtils.getDebugConsoleBgColor();
            }
            range.foreground = range.background;
        }
        range.font = null;
        range.fontStyle = 0;
        if (tempAttrib.bold) {
            range.fontStyle |= 1;
        }
        if (tempAttrib.italic) {
            range.fontStyle |= 2;
        }
        if (tempAttrib.underline != -1) {
            range.underline = true;
            range.underlineColor = range.foreground;
            range.underlineStyle = tempAttrib.underline;
        } else {
            range.underline = false;
        }
        range.strikeout = tempAttrib.strike;
        range.strikeoutColor = range.foreground;
        if (tempAttrib.framed) {
            range.borderStyle = 1;
            range.borderColor = range.foreground;
        } else {
            range.borderStyle = 0;
        }
    }
}

