/*
 * Decompiled with CFR 0.152.
 */
package org.dadacoalition.yedit.editor;

import java.util.ArrayList;
import java.util.List;
import org.dadacoalition.yedit.Activator;
import org.dadacoalition.yedit.editor.IDocumentIdleListener;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Display;

public class IdleTimer
extends Thread {
    private final ISourceViewer sourceViewer;
    private final Display display;
    private final List<IDocumentIdleListener> listeners = new ArrayList<IDocumentIdleListener>();
    private long lastChange = -1L;
    private int waitForTermination = 1000;
    private int timeBetweenActivation;

    public IdleTimer(ISourceViewer sourceViewer, Display display) {
        super("IdleTimer");
        assert (sourceViewer != null);
        assert (display != null);
        this.timeBetweenActivation = Activator.getDefault().getPreferenceStore().getInt("secondsToReevaluate") * 1000;
        this.sourceViewer = sourceViewer;
        this.display = display;
    }

    public synchronized void addListener(IDocumentIdleListener listener) {
        this.listeners.add(listener);
        this.lastChange = System.currentTimeMillis();
        this.notifyAll();
    }

    public void dispose() throws InterruptedException {
        this.interrupt();
        this.join(this.waitForTermination);
    }

    @Override
    public void run() {
        IDocumentListener changeListener = new IDocumentListener(){

            public void documentAboutToBeChanged(DocumentEvent event) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void documentChanged(DocumentEvent event) {
                IdleTimer idleTimer = IdleTimer.this;
                synchronized (idleTimer) {
                    IdleTimer.this.lastChange = System.currentTimeMillis();
                    IdleTimer.this.notifyAll();
                }
            }
        };
        this.sourceViewer.getDocument().addDocumentListener(changeListener);
        try {
            this.runImpl();
        }
        catch (InterruptedException interruptedException) {}
    }

    private boolean isEditorVisible() {
        StyledText widget = ((SourceViewer)this.sourceViewer).getTextWidget();
        return widget != null && widget.isVisible();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runImpl() throws InterruptedException {
        while (!Thread.interrupted()) {
            IdleTimer idleTimer = this;
            synchronized (idleTimer) {
                while (this.lastChange == -1L) {
                    this.wait();
                }
                while (System.currentTimeMillis() < this.lastChange + (long)this.timeBetweenActivation) {
                    this.wait(this.timeBetweenActivation);
                }
                this.lastChange = -1L;
            }
            try {
                IDocumentIdleListener[] _listeners = new IDocumentIdleListener[this.listeners.size()];
                IdleTimer idleTimer2 = this;
                synchronized (idleTimer2) {
                    this.listeners.toArray(_listeners);
                }
                int i = 0;
                while (i < _listeners.length) {
                    final IDocumentIdleListener listener = _listeners[i];
                    this.display.syncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (IdleTimer.this.isEditorVisible()) {
                                listener.editorIdle(IdleTimer.this.sourceViewer);
                            }
                        }
                    });
                    ++i;
                }
            }
            catch (SWTException sWTException) {}
        }
    }
}

