/*
 * Decompiled with CFR 0.152.
 */
package org.dadacoalition.yedit.editor;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dadacoalition.yedit.YEditLog;
import org.dadacoalition.yedit.editor.TaskTag;
import org.dadacoalition.yedit.editor.TaskTagPreference;
import org.dadacoalition.yedit.editor.scanner.YAMLScanner;
import org.dadacoalition.yedit.editor.scanner.YAMLToken;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;

public class TaskTagParser {
    private final List<TaskTagPreference> tagsToFind;
    private final YAMLScanner scanner;
    private final Pattern tagPattern;

    public TaskTagParser(List<TaskTagPreference> tagsToFind, YAMLScanner scanner, boolean caseSensitive) {
        this.tagsToFind = tagsToFind;
        this.scanner = scanner;
        this.tagPattern = caseSensitive ? Pattern.compile(this.constructTagPattern(tagsToFind)) : Pattern.compile(this.constructTagPattern(tagsToFind), 66);
    }

    public List<TaskTag> parseTags(IDocument document) {
        if (this.tagsToFind.isEmpty()) {
            return new ArrayList<TaskTag>();
        }
        ArrayList<TaskTag> foundTags = new ArrayList<TaskTag>();
        int rangeLength = document.getLength();
        this.scanner.setRange(document, 0, rangeLength);
        IToken token = this.scanner.nextToken();
        while (token != Token.EOF) {
            if (this.tokenHasTag(token, document)) {
                YAMLToken yToken = (YAMLToken)token;
                TaskTag tag = this.parseToken(document, yToken);
                foundTags.add(tag);
            }
            int newOffset = this.scanner.getTokenOffset() + this.scanner.getTokenLength();
            this.scanner.setRange(document, newOffset, rangeLength -= this.scanner.getTokenLength());
            token = this.scanner.nextToken();
        }
        return foundTags;
    }

    private boolean tokenHasTag(IToken token, IDocument document) {
        if (!(token instanceof YAMLToken) || ((YAMLToken)token).getTokenType() != YAMLToken.COMMENT) {
            return false;
        }
        String comment = this.getTokenString(document);
        return this.hasTag(comment);
    }

    private TaskTag parseToken(IDocument document, YAMLToken token) {
        String tokenString = this.getTokenString(document);
        TaskTag todoTag = this.constructTodoTag(tokenString, document);
        return todoTag;
    }

    private String getTokenString(IDocument document) {
        try {
            return document.get(this.scanner.getTokenOffset(), this.scanner.getTokenLength());
        }
        catch (BadLocationException e) {
            YEditLog.logException(e, "Finding todo tag failed");
            return "";
        }
    }

    private TaskTag constructTodoTag(String tokenString, IDocument document) {
        int lineNumber = 1;
        try {
            lineNumber = document.getLineOfOffset(this.scanner.getTokenOffset()) + 1;
        }
        catch (BadLocationException e) {
            YEditLog.logException(e, "Failed to get the correct line number");
        }
        TaskTagPreference ttp = this.getFoundTagType(tokenString);
        String message = this.getTodoTagMessage(tokenString, ttp.tag);
        return new TaskTag(ttp.tag, ttp.severity, lineNumber, message);
    }

    private String getTodoTagMessage(String comment, String tag) {
        String message = comment.substring(comment.indexOf(tag) + tag.length());
        return message.trim();
    }

    private TaskTagPreference getFoundTagType(String comment) {
        comment = comment.toLowerCase();
        for (TaskTagPreference ttp : this.tagsToFind) {
            if (comment.indexOf(ttp.tag.toLowerCase()) <= 0) continue;
            return ttp;
        }
        throw new IllegalArgumentException("Did not find the correct tag preference for : '" + comment + "' Should not be possible.");
    }

    private String constructTagPattern(List<TaskTagPreference> tagsToFind) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (TaskTagPreference ttp : tagsToFind) {
            if (!first) {
                sb.append("|");
            }
            sb.append(ttp.tag);
            first = false;
        }
        return sb.toString();
    }

    private boolean hasTag(String comment) {
        Matcher m = this.tagPattern.matcher(comment);
        return m.find();
    }
}

