/*
 * Decompiled with CFR 0.152.
 */
package org.dadacoalition.yedit.editor;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.jface.preference.IPreferenceStore;

public class TaskTagPreference {
    public String tag;
    public String severity;

    public TaskTagPreference() {
    }

    public TaskTagPreference(String tag, String severity) {
        this.tag = tag;
        this.severity = severity;
    }

    public static List<TaskTagPreference> getTaskTagPreferences(IPreferenceStore prefStore) {
        String currTags = prefStore.getString("todoTaskTags");
        String currPrios = prefStore.getString("todoTaskPriorities");
        String[] tags = TaskTagPreference.getTokens(currTags, ",");
        String[] prios = TaskTagPreference.getTokens(currPrios, ",");
        ArrayList<TaskTagPreference> elements = new ArrayList<TaskTagPreference>(tags.length);
        int i = 0;
        while (i < tags.length) {
            String tag = tags[i].trim();
            String severity = i < prios.length ? prios[i] : "normal";
            elements.add(new TaskTagPreference(tag, severity));
            ++i;
        }
        return elements;
    }

    private static String[] getTokens(String text, String separator) {
        StringTokenizer tok = new StringTokenizer(text, separator);
        int nTokens = tok.countTokens();
        String[] res = new String[nTokens];
        int i = 0;
        while (i < res.length) {
            res[i] = tok.nextToken().trim();
            ++i;
        }
        return res;
    }
}

