/*
 * Decompiled with CFR 0.152.
 */
package org.dadacoalition.yedit.editor;

import java.io.Reader;
import java.io.StringReader;
import java.util.Iterator;
import java.util.List;
import org.dadacoalition.yedit.Activator;
import org.dadacoalition.yedit.YEditLog;
import org.dadacoalition.yedit.editor.ColorManager;
import org.dadacoalition.yedit.editor.IDocumentIdleListener;
import org.dadacoalition.yedit.editor.IdleTimer;
import org.dadacoalition.yedit.editor.PreferenceChangeListener;
import org.dadacoalition.yedit.editor.SymfonyCompatibilityMode;
import org.dadacoalition.yedit.editor.TaskTag;
import org.dadacoalition.yedit.editor.TaskTagParser;
import org.dadacoalition.yedit.editor.TaskTagPreference;
import org.dadacoalition.yedit.editor.YAMLContentOutlinePage;
import org.dadacoalition.yedit.editor.YEditSourceViewerConfiguration;
import org.dadacoalition.yedit.formatter.FormatterUtils;
import org.dadacoalition.yedit.formatter.YamlFormatter;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.error.MarkedYAMLException;
import org.yaml.snakeyaml.error.YAMLException;

public class YEdit
extends TextEditor {
    private ColorManager colorManager;
    private IdleTimer idleTimer;
    YEditSourceViewerConfiguration sourceViewerConfig;
    private YAMLContentOutlinePage contentOutline;
    private final IPropertyChangeListener propertyChangeListener = new PreferenceChangeListener(this);
    public static final String SOURCE_VIEWER_CONFIGURATION_CONTRIB_ID = "org.dadacoalition.yedit.sourceViewerConfigurationContribution";

    public YEdit() {
        this.colorManager = new ColorManager();
        this.setKeyBindingScopes(new String[]{"org.dadacoalition.yedit.yeditScope"});
    }

    public void dispose() {
        try {
            this.colorManager.dispose();
            if (this.idleTimer != null) {
                this.idleTimer.dispose();
            }
            Activator.getDefault().getPreferenceStore().removePropertyChangeListener(this.propertyChangeListener);
            super.dispose();
        }
        catch (InterruptedException e) {
            YEditLog.logException(e);
        }
    }

    protected void addDocumentIdleListener(IDocumentIdleListener listener) {
        if (this.idleTimer != null) {
            this.idleTimer.addListener(listener);
        } else {
            YEditLog.logError("Failed adding listener for idle document since listener is null");
            YEditLog.logger.severe("listener is null");
        }
    }

    protected void initializeEditor() {
        super.initializeEditor();
        YEditSourceViewerConfiguration jsvc = this.createSourceViewerConfiguration();
        this.setSourceViewerConfiguration((SourceViewerConfiguration)jsvc);
        this.sourceViewerConfig = jsvc;
    }

    protected YEditSourceViewerConfiguration createSourceViewerConfiguration() {
        IConfigurationElement[] elts;
        YEditSourceViewerConfiguration jsvc = null;
        boolean contribFound = false;
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint(SOURCE_VIEWER_CONFIGURATION_CONTRIB_ID);
        IConfigurationElement[] iConfigurationElementArray = elts = point.getConfigurationElements();
        int n = elts.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement elt = iConfigurationElementArray[n2];
            if ("sourceViewerConfiguration".equals(elt.getName())) {
                try {
                    jsvc = (YEditSourceViewerConfiguration)((Object)elt.createExecutableExtension("class"));
                    contribFound = true;
                    break;
                }
                catch (CoreException coreException) {}
            }
            ++n2;
        }
        if (!contribFound) {
            jsvc = new YEditSourceViewerConfiguration();
        }
        return jsvc;
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.idleTimer = new IdleTimer(this.getSourceViewer(), Display.getCurrent());
        this.idleTimer.start();
        IDocumentIdleListener listener = new IDocumentIdleListener(){

            @Override
            public void editorIdle(ISourceViewer sourceViewer) {
                sourceViewer.invalidateTextPresentation();
            }
        };
        this.addDocumentIdleListener(listener);
        Activator.getDefault().getPreferenceStore().addPropertyChangeListener(this.propertyChangeListener);
    }

    public Object getAdapter(Class required) {
        if (IContentOutlinePage.class.equals((Object)required)) {
            if (this.contentOutline == null) {
                this.contentOutline = new YAMLContentOutlinePage(this.getDocumentProvider(), this);
                if (this.getEditorInput() != null) {
                    this.contentOutline.setInput(this.getEditorInput());
                }
            }
            return this.contentOutline;
        }
        return super.getAdapter(required);
    }

    public void doSave(IProgressMonitor monitor) {
        super.doSave(monitor);
        this.markErrors();
        this.locateTaskTags();
        this.updateContentOutline();
    }

    public void doSaveAs() {
        super.doSaveAs();
        this.markErrors();
        this.locateTaskTags();
        this.updateContentOutline();
    }

    void updateContentOutline() {
        if (this.contentOutline != null) {
            this.contentOutline.update();
        }
    }

    void reinitialize() {
        if (this.getSourceViewer() instanceof SourceViewer) {
            ((SourceViewer)this.getSourceViewer()).unconfigure();
            this.initializeEditor();
            this.getSourceViewer().configure((SourceViewerConfiguration)this.sourceViewerConfig);
        } else {
            String msg = "Expected source viewer to be of type SourceViewer, but is wasn't. ";
            msg = String.valueOf(msg) + "Might cause problems with preferences.";
            YEditLog.logger.warning(msg);
        }
    }

    private YAMLException checkForErrors() {
        IDocument document = this.getDocumentProvider().getDocument((Object)this.getEditorInput());
        String content = document.get();
        IPreferenceStore prefs = Activator.getDefault().getPreferenceStore();
        if (prefs.getBoolean("symfonyCompatibilityMode")) {
            SymfonyCompatibilityMode sr = new SymfonyCompatibilityMode(this.sourceViewerConfig.getScanner());
            content = sr.fixScalars(document);
        }
        Yaml yamlParser = new Yaml();
        YAMLException parserError = null;
        try {
            Iterator iterator = yamlParser.composeAll((Reader)new StringReader(content)).iterator();
            while (iterator.hasNext()) {
                iterator.next();
            }
        }
        catch (YAMLException ex) {
            parserError = ex;
            YEditLog.logger.info("Encountered YAML syntax error:" + ex.toString());
        }
        return parserError;
    }

    void markErrors() {
        YAMLException syntaxError;
        IEditorInput editorInput = this.getEditorInput();
        if (!(editorInput instanceof IFileEditorInput)) {
            YEditLog.logError("Marking errors not supported for files outside of a project.");
            YEditLog.logger.info("editorInput is not a part of a project.");
            return;
        }
        IFile file = ((IFileEditorInput)editorInput).getFile();
        int depth = 2;
        try {
            file.deleteMarkers("org.eclipse.core.resources.problemmarker", true, depth);
        }
        catch (CoreException e) {
            YEditLog.logException(e);
            YEditLog.logger.warning("Failed to delete markers:\n" + e.toString());
        }
        IPreferenceStore prefs = Activator.getDefault().getPreferenceStore();
        String severity = prefs.getString("validation");
        if ("syntaxValidationIgnore".equals(severity)) {
            YEditLog.logger.info("Possible syntax errors ignored due to preference settings");
            return;
        }
        int markerSeverity = 2;
        if ("syntaxValidationWarning".equals(severity)) {
            markerSeverity = 1;
        }
        if ((syntaxError = this.checkForErrors()) == null) {
            YEditLog.logger.fine("No syntax errors");
            return;
        }
        try {
            IMarker marker = file.createMarker("org.eclipse.core.resources.problemmarker");
            marker.setAttribute("severity", markerSeverity);
            if (syntaxError instanceof MarkedYAMLException) {
                MarkedYAMLException ex = (MarkedYAMLException)syntaxError;
                marker.setAttribute("message", (Object)ex.getProblem());
                int lineNumber = ex.getProblemMark().getLine() + 1;
                marker.setAttribute("lineNumber", lineNumber);
            } else {
                marker.setAttribute("message", (Object)"General YAMLException from parser");
            }
        }
        catch (CoreException e) {
            YEditLog.logException(e);
            YEditLog.logger.warning("Failed to create marker for syntax error: \n" + e.toString());
        }
    }

    void locateTaskTags() {
        IEditorInput editorInput = this.getEditorInput();
        if (!(editorInput instanceof IFileEditorInput)) {
            YEditLog.logError("Locating task tags are not supported for files outside of a project.");
            YEditLog.logger.info("editorInput is not a part of a project.");
            return;
        }
        IFile file = ((IFileEditorInput)editorInput).getFile();
        int depth = 2;
        try {
            file.deleteMarkers("org.eclipse.core.resources.taskmarker", true, depth);
        }
        catch (CoreException e) {
            YEditLog.logException(e);
            YEditLog.logger.warning("Failed to delete task markers:\n" + e.toString());
        }
        List<TaskTagPreference> prefs = this.getTaskTagPreferences();
        boolean caseSensitiveTags = Boolean.valueOf(Activator.getDefault().getPreferenceStore().getString("todoTaskCaseSensitive"));
        TaskTagParser ttp = new TaskTagParser(prefs, this.sourceViewerConfig.getScanner(), caseSensitiveTags);
        List<TaskTag> tags = ttp.parseTags(this.getDocumentProvider().getDocument((Object)this.getEditorInput()));
        for (TaskTag tag : tags) {
            try {
                IMarker marker = file.createMarker("org.eclipse.core.resources.taskmarker");
                marker.setAttribute("severity", this.tagToMarkerSeverity(tag));
                marker.setAttribute("lineNumber", tag.getLineNumber());
                marker.setAttribute("message", (Object)tag.getMessage());
            }
            catch (CoreException e) {
                YEditLog.logException(e);
            }
        }
    }

    private int tagToMarkerSeverity(TaskTag tag) {
        switch (tag.getSeverity()) {
            case "high": {
                return 2;
            }
            case "normal": {
                return 1;
            }
            case "low": {
                return 0;
            }
        }
        return 1;
    }

    private List<TaskTagPreference> getTaskTagPreferences() {
        return TaskTagPreference.getTaskTagPreferences(Activator.getDefault().getPreferenceStore());
    }

    public boolean formatDocument() {
        IDocument document = this.getDocumentProvider().getDocument((Object)this.getEditorInput());
        String content = document.get();
        Yaml yamlParser = new Yaml();
        YamlFormatter formatter = FormatterUtils.preferencesToFormatter(Activator.getDefault().getPreferenceStore());
        try {
            Iterable yamlDocuments = yamlParser.loadAll(content);
            document.set(formatter.formatDocuments(yamlDocuments));
        }
        catch (YAMLException yAMLException) {
            YEditLog.logger.info("Cannot format a file when it has syntax errors.");
            return false;
        }
        return true;
    }

    protected boolean isTabsToSpacesConversionEnabled() {
        return true;
    }

    protected ColorManager getColorManager() {
        return this.colorManager;
    }

    public YAMLContentOutlinePage getContentOutlinePage() {
        return this.contentOutline;
    }
}

