/*
 * Decompiled with CFR 0.152.
 */
package org.dadacoalition.yedit.formatter;

import java.util.ArrayList;
import org.dadacoalition.yedit.Utils;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;

public class YamlFormatter {
    private final DumperOptions options = new DumperOptions();

    private YamlFormatter(Builder builder) {
        this.options.setExplicitStart(builder.explicitStart);
        this.options.setExplicitEnd(builder.explicitEnd);
        this.options.setIndent(builder.indent);
        this.options.setWidth(builder.lineLength);
        this.options.setDefaultFlowStyle(builder.flowStyle);
        this.options.setPrettyFlow(builder.prettyFlow);
        this.options.setDefaultScalarStyle(builder.scalarStyle);
    }

    public String formatDocuments(Iterable<Object> documents) {
        ArrayList<String> formattedDocuments = new ArrayList<String>();
        for (Object document : documents) {
            formattedDocuments.add(this.formatDocument(document));
        }
        if (formattedDocuments.isEmpty()) {
            return this.formatDocument(null);
        }
        return Utils.joinAsString(formattedDocuments, System.lineSeparator());
    }

    private String formatDocument(Object document) {
        Yaml yaml = new Yaml(this.options);
        if (document == null) {
            StringBuilder sb = new StringBuilder();
            if (this.options.isExplicitStart()) {
                sb.append("---");
            }
            sb.append(System.lineSeparator());
            if (this.options.isExplicitEnd()) {
                sb.append("...");
            }
            return sb.toString();
        }
        return yaml.dump(document).trim();
    }

    /* synthetic */ YamlFormatter(Builder builder, YamlFormatter yamlFormatter) {
        this(builder);
    }

    public static class Builder {
        private boolean explicitStart = false;
        private boolean explicitEnd = false;
        private int indent = 2;
        private int lineLength = 80;
        private DumperOptions.FlowStyle flowStyle = DumperOptions.FlowStyle.BLOCK;
        private boolean prettyFlow = false;
        private DumperOptions.ScalarStyle scalarStyle = DumperOptions.ScalarStyle.PLAIN;

        public Builder explicitStart(boolean explicitStart) {
            this.explicitStart = explicitStart;
            return this;
        }

        public Builder explicitEnd(boolean explicitEnd) {
            this.explicitEnd = explicitEnd;
            return this;
        }

        public Builder indent(int indent) {
            this.indent = indent;
            return this;
        }

        public Builder lineLength(int lineLength) {
            this.lineLength = lineLength;
            return this;
        }

        public Builder flowStyle(DumperOptions.FlowStyle flowStyle) {
            this.flowStyle = flowStyle;
            return this;
        }

        public Builder prettyFlow(boolean prettyFlow) {
            this.prettyFlow = prettyFlow;
            return this;
        }

        public Builder scalarStyle(DumperOptions.ScalarStyle scalarStyle) {
            this.scalarStyle = scalarStyle;
            return this;
        }

        public YamlFormatter build() {
            return new YamlFormatter(this, null);
        }
    }
}

