/*
 * Decompiled with CFR 0.152.
 */
package org.dadacoalition.yedit.preferences.tasktag;

import org.dadacoalition.yedit.preferences.tasktag.DialogField;
import org.dadacoalition.yedit.preferences.tasktag.SWTUtil;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class SelectionButtonDialogField
extends DialogField {
    private Button fButton;
    private boolean fIsSelected = false;
    private DialogField[] fAttachedDialogFields = null;
    private int fButtonStyle;

    public SelectionButtonDialogField(int buttonStyle) {
        this.fButtonStyle = buttonStyle;
    }

    public void attachDialogField(DialogField dialogField) {
        this.attachDialogFields(new DialogField[]{dialogField});
    }

    public void attachDialogFields(DialogField[] dialogFields) {
        this.fAttachedDialogFields = dialogFields;
        int i = 0;
        while (i < dialogFields.length) {
            dialogFields[i].setEnabled(this.fIsSelected);
            ++i;
        }
    }

    public boolean isAttached(DialogField editor) {
        if (this.fAttachedDialogFields != null) {
            int i = 0;
            while (i < this.fAttachedDialogFields.length) {
                if (this.fAttachedDialogFields[i] == editor) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    @Override
    public Control[] doFillIntoGrid(Composite parent, int nColumns) {
        this.assertEnoughColumns(nColumns);
        Button button = this.getSelectionButton(parent);
        GridData gd = new GridData();
        gd.horizontalSpan = nColumns;
        gd.horizontalAlignment = 4;
        if (this.fButtonStyle == 8) {
            gd.widthHint = SWTUtil.getButtonWidthHint(button);
        }
        button.setLayoutData((Object)gd);
        return new Control[]{button};
    }

    @Override
    public int getNumberOfControls() {
        return 1;
    }

    public Button getSelectionButton(Composite group) {
        if (this.fButton == null) {
            this.assertCompositeNotNull(group);
            this.fButton = new Button(group, this.fButtonStyle);
            this.fButton.setFont(group.getFont());
            this.fButton.setText(this.fLabelText);
            this.fButton.setEnabled(this.isEnabled());
            this.fButton.setSelection(this.fIsSelected);
            this.fButton.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                    SelectionButtonDialogField.this.doWidgetSelected(e);
                }

                public void widgetSelected(SelectionEvent e) {
                    SelectionButtonDialogField.this.doWidgetSelected(e);
                }
            });
        }
        return this.fButton;
    }

    protected void doWidgetSelected(SelectionEvent e) {
        if (this.isOkToUse((Control)this.fButton)) {
            this.changeValue(this.fButton.getSelection());
        }
    }

    private void changeValue(boolean newState) {
        if (this.fIsSelected != newState) {
            this.fIsSelected = newState;
            if (this.fAttachedDialogFields != null) {
                boolean focusSet = false;
                int i = 0;
                while (i < this.fAttachedDialogFields.length) {
                    this.fAttachedDialogFields[i].setEnabled(this.fIsSelected);
                    if (this.fIsSelected && !focusSet) {
                        focusSet = this.fAttachedDialogFields[i].setFocus();
                    }
                    ++i;
                }
            }
            this.dialogFieldChanged();
        } else if (this.fButtonStyle == 8) {
            this.dialogFieldChanged();
        }
    }

    public boolean isSelected() {
        return this.fIsSelected;
    }

    public void setSelection(boolean selected) {
        this.changeValue(selected);
        if (this.isOkToUse((Control)this.fButton)) {
            this.fButton.setSelection(selected);
        }
    }

    @Override
    protected void updateEnableState() {
        super.updateEnableState();
        if (this.isOkToUse((Control)this.fButton)) {
            this.fButton.setEnabled(this.isEnabled());
        }
    }
}

