/*
 * Decompiled with CFR 0.152.
 */
package org.dadacoalition.yedit.preferences.tasktag;

import java.util.List;
import org.dadacoalition.yedit.YEditLog;
import org.dadacoalition.yedit.editor.TaskTagPreference;
import org.dadacoalition.yedit.preferences.tasktag.DialogField;
import org.dadacoalition.yedit.preferences.tasktag.IDialogFieldListener;
import org.dadacoalition.yedit.preferences.tasktag.IListAdapter;
import org.dadacoalition.yedit.preferences.tasktag.IStatusChangeListener;
import org.dadacoalition.yedit.preferences.tasktag.ListDialogField;
import org.dadacoalition.yedit.preferences.tasktag.SelectionButtonDialogField;
import org.dadacoalition.yedit.preferences.tasktag.StatusInfo;
import org.dadacoalition.yedit.preferences.tasktag.TodoTaskInputDialog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class TaskTagConfigurationBlock {
    private IStatusChangeListener fContext;
    private Shell fShell;
    private IPreferenceStore fPreferenceStore;
    private static final String[] ALL_KEYS = new String[]{"todoTaskTags", "todoTaskPriorities", "todoTaskCaseSensitive"};
    private static final String TASK_PRIORITY_HIGH = "high";
    private static final String TASK_PRIORITY_NORMAL = "normal";
    private static final String TASK_PRIORITY_LOW = "low";
    private static final int IDX_ADD = 0;
    private static final int IDX_EDIT = 1;
    private static final int IDX_REMOVE = 2;
    private IStatus fTaskTagsStatus;
    private final ListDialogField<TaskTagPreference> fTodoTasksList;
    private final SelectionButtonDialogField fCaseSensitiveCheckBox;

    public TaskTagConfigurationBlock(IStatusChangeListener context, IPreferenceStore preferenceStore) {
        this.fPreferenceStore = preferenceStore;
        this.fContext = context;
        this.checkIfOptionsComplete(ALL_KEYS);
        this.settingsUpdated();
        TaskTagAdapter adapter = new TaskTagAdapter();
        String[] stringArray = new String[4];
        stringArray[0] = "Add";
        stringArray[1] = "Edit";
        stringArray[2] = "Remove";
        String[] buttons = stringArray;
        this.fTodoTasksList = new ListDialogField<TaskTagPreference>(adapter, buttons, (IBaseLabelProvider)new TodoTaskLabelProvider());
        this.fTodoTasksList.setDialogFieldListener(adapter);
        this.fTodoTasksList.setRemoveButtonIndex(2);
        String[] columnsHeaders = new String[]{"Name", "Priority"};
        this.fTodoTasksList.setTableColumns(new ListDialogField.ColumnsDescription(columnsHeaders, true));
        this.fTodoTasksList.setViewerComparator(new TodoTaskSorter());
        this.fCaseSensitiveCheckBox = new SelectionButtonDialogField(32);
        this.fCaseSensitiveCheckBox.setLabelText("Case sensitive task tag names");
        this.fCaseSensitiveCheckBox.setDialogFieldListener(adapter);
        this.unpackTodoTasks();
        if (this.fTodoTasksList.getSize() > 0) {
            this.fTodoTasksList.selectFirstElement();
        } else {
            this.fTodoTasksList.enableButton(1, false);
        }
        this.fTaskTagsStatus = new StatusInfo();
    }

    public void setEnabled(boolean isEnabled) {
        this.fTodoTasksList.setEnabled(isEnabled);
        this.fCaseSensitiveCheckBox.setEnabled(isEnabled);
    }

    public Control createContents(Composite parent) {
        this.setShell(parent.getShell());
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        PixelConverter conv = new PixelConverter((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)layout);
        composite.setFont(parent.getFont());
        GridData data = new GridData(1808);
        data.widthHint = conv.convertWidthInCharsToPixels(50);
        Control listControl = this.fTodoTasksList.getListControl(composite);
        listControl.setLayoutData((Object)data);
        Composite buttonsControl = this.fTodoTasksList.getButtonBox(composite);
        buttonsControl.setLayoutData((Object)new GridData(258));
        this.fCaseSensitiveCheckBox.doFillIntoGrid(composite, 2);
        this.validateSettings(null);
        return composite;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void validateSettings(String changedKey) {
        if (changedKey != null) {
            if (!"todoTaskTags".equals(changedKey)) return;
            this.fTaskTagsStatus = this.validateTaskTags();
        } else {
            this.fTaskTagsStatus = this.validateTaskTags();
        }
        IStatus status = this.fTaskTagsStatus;
        this.fContext.statusChanged(status);
    }

    private IStatus validateTaskTags() {
        return new StatusInfo();
    }

    private void updateModel(DialogField field) {
        if (field == this.fTodoTasksList) {
            StringBuffer tags = new StringBuffer();
            StringBuffer prios = new StringBuffer();
            List<TaskTagPreference> list = this.fTodoTasksList.getElements();
            int i = 0;
            while (i < list.size()) {
                if (i > 0) {
                    tags.append(',');
                    prios.append(',');
                }
                TaskTagPreference elem = list.get(i);
                tags.append(elem.tag);
                prios.append(elem.severity);
                ++i;
            }
            this.setValue("todoTaskTags", tags.toString());
            this.setValue("todoTaskPriorities", prios.toString());
            this.validateSettings("todoTaskTags");
        } else if (field == this.fCaseSensitiveCheckBox) {
            String state = String.valueOf(this.fCaseSensitiveCheckBox.isSelected());
            this.setValue("todoTaskCaseSensitive", state);
        }
    }

    private void unpackTodoTasks() {
        List<TaskTagPreference> elements = TaskTagPreference.getTaskTagPreferences(this.fPreferenceStore);
        this.fTodoTasksList.setElements(elements);
        boolean isCaseSensitive = this.getBooleanValue("todoTaskCaseSensitive");
        this.fCaseSensitiveCheckBox.setSelection(isCaseSensitive);
    }

    private void doTodoButtonPressed(int index) {
        TodoTaskInputDialog dialog;
        TaskTagPreference edited = null;
        if (index != 0) {
            edited = this.fTodoTasksList.getSelectedElements().get(0);
        }
        if ((index == 0 || index == 1) && (dialog = new TodoTaskInputDialog(this.getShell(), edited, this.fTodoTasksList.getElements())).open() == 0) {
            if (edited != null) {
                this.fTodoTasksList.replaceElement(edited, dialog.getResult());
            } else {
                this.fTodoTasksList.addElement(dialog.getResult());
            }
        }
    }

    private void checkIfOptionsComplete(String[] allKeys) {
        int i = 0;
        while (i < allKeys.length) {
            if (this.fPreferenceStore.getString(allKeys[i]) == null) {
                YEditLog.logError("Preference option missing: " + allKeys[i] + " (" + this.getClass().getName() + ')');
            }
            ++i;
        }
    }

    protected void settingsUpdated() {
    }

    private Shell getShell() {
        return this.fShell;
    }

    private void setShell(Shell shell) {
        this.fShell = shell;
    }

    private String getValue(String key) {
        return this.fPreferenceStore.getString(key);
    }

    private boolean getBooleanValue(String key) {
        return Boolean.valueOf(this.getValue(key));
    }

    private String setValue(String key, String value) {
        String oldValue = this.getValue(key);
        this.fPreferenceStore.setValue(key, value);
        return oldValue;
    }

    public void dispose() {
    }

    public class TaskTagAdapter
    implements IListAdapter<TaskTagPreference>,
    IDialogFieldListener {
        private boolean canEdit(List<TaskTagPreference> selectedElements) {
            return selectedElements.size() == 1;
        }

        @Override
        public void customButtonPressed(ListDialogField<TaskTagPreference> field, int index) {
            TaskTagConfigurationBlock.this.doTodoButtonPressed(index);
        }

        @Override
        public void selectionChanged(ListDialogField<TaskTagPreference> field) {
            List<TaskTagPreference> selectedElements = field.getSelectedElements();
            field.enableButton(1, this.canEdit(selectedElements));
        }

        @Override
        public void doubleClicked(ListDialogField<TaskTagPreference> field) {
            if (this.canEdit(field.getSelectedElements())) {
                TaskTagConfigurationBlock.this.doTodoButtonPressed(1);
            }
        }

        @Override
        public void dialogFieldChanged(DialogField field) {
            TaskTagConfigurationBlock.this.updateModel(field);
        }
    }

    private class TodoTaskLabelProvider
    extends LabelProvider
    implements ITableLabelProvider,
    IFontProvider {
        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            return this.getColumnText(element, 0);
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            TaskTagPreference task = (TaskTagPreference)element;
            if (columnIndex == 0) {
                return task.tag;
            }
            if (TaskTagConfigurationBlock.TASK_PRIORITY_HIGH.equals(task.severity)) {
                return "High";
            }
            if (TaskTagConfigurationBlock.TASK_PRIORITY_NORMAL.equals(task.severity)) {
                return "Normal";
            }
            if (TaskTagConfigurationBlock.TASK_PRIORITY_LOW.equals(task.severity)) {
                return "Low";
            }
            return "";
        }

        public Font getFont(Object element) {
            return null;
        }
    }

    private static class TodoTaskSorter
    extends ViewerComparator {
        private TodoTaskSorter() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            return this.getComparator().compare(((TaskTagPreference)e1).tag, ((TaskTagPreference)e2).tag);
        }
    }
}

