/*
 * Decompiled with CFR 0.152.
 */
package org.dadacoalition.yedit.preferences.tasktag;

import java.util.ArrayList;
import java.util.List;
import org.dadacoalition.yedit.editor.TaskTagPreference;
import org.dadacoalition.yedit.preferences.tasktag.ComboDialogField;
import org.dadacoalition.yedit.preferences.tasktag.DialogField;
import org.dadacoalition.yedit.preferences.tasktag.IDialogFieldListener;
import org.dadacoalition.yedit.preferences.tasktag.LayoutUtil;
import org.dadacoalition.yedit.preferences.tasktag.StatusInfo;
import org.dadacoalition.yedit.preferences.tasktag.StringDialogField;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class TodoTaskInputDialog
extends StatusDialog {
    private final StringDialogField fNameDialogField;
    private final ComboDialogField fPriorityDialogField;
    private final List<String> fExistingNames;

    public TodoTaskInputDialog(Shell parent, TaskTagPreference task, List<TaskTagPreference> existingEntries) {
        super(parent);
        this.fExistingNames = new ArrayList<String>(existingEntries.size());
        int i = 0;
        while (i < existingEntries.size()) {
            TaskTagPreference curr = existingEntries.get(i);
            if (!curr.equals(task)) {
                this.fExistingNames.add(curr.tag);
            }
            ++i;
        }
        if (task == null) {
            this.setTitle("New");
        } else {
            this.setTitle("Edit");
        }
        CompilerTodoTaskInputAdapter adapter = new CompilerTodoTaskInputAdapter();
        this.fNameDialogField = new StringDialogField();
        this.fNameDialogField.setLabelText("Name");
        this.fNameDialogField.setDialogFieldListener(adapter);
        this.fNameDialogField.setText(task != null ? task.tag : "");
        String[] items = new String[]{"High", "Normal", "Low"};
        this.fPriorityDialogField = new ComboDialogField(8);
        this.fPriorityDialogField.setLabelText("Priority");
        this.fPriorityDialogField.setItems(items);
        if (task != null) {
            if ("high".equals(task.severity)) {
                this.fPriorityDialogField.selectItem(0);
            } else if ("normal".equals(task.severity)) {
                this.fPriorityDialogField.selectItem(1);
            } else {
                this.fPriorityDialogField.selectItem(2);
            }
        } else {
            this.fPriorityDialogField.selectItem(1);
        }
    }

    public TaskTagPreference getResult() {
        TaskTagPreference task = new TaskTagPreference();
        task.tag = this.fNameDialogField.getText().trim();
        switch (this.fPriorityDialogField.getSelectionIndex()) {
            case 0: {
                task.severity = "high";
                break;
            }
            case 1: {
                task.severity = "normal";
                break;
            }
            default: {
                task.severity = "low";
            }
        }
        return task;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Composite inner = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        inner.setLayout((Layout)layout);
        this.fNameDialogField.doFillIntoGrid(inner, 2);
        this.fPriorityDialogField.doFillIntoGrid(inner, 2);
        LayoutUtil.setHorizontalGrabbing((Control)this.fNameDialogField.getTextControl(null), true);
        LayoutUtil.setWidthHint((Control)this.fNameDialogField.getTextControl(null), this.convertWidthInCharsToPixels(45));
        this.fNameDialogField.postSetFocusOnDialogField(parent.getDisplay());
        TodoTaskInputDialog.applyDialogFont((Control)composite);
        return composite;
    }

    private void doValidation() {
        StatusInfo status = new StatusInfo();
        String newText = this.fNameDialogField.getText();
        if (newText.isEmpty()) {
            status.setError("Enter task tag name.");
        } else if (newText.indexOf(44) != -1) {
            status.setError("Name cannot contain a comma.");
        } else if (this.fExistingNames.contains(newText)) {
            status.setError("An entry with the same name already exists.");
        } else if (Character.isWhitespace(newText.charAt(0)) || Character.isWhitespace(newText.charAt(newText.length() - 1))) {
            status.setError("Name cannot begin or end with a whitespace.");
        }
        this.updateStatus(status);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
    }

    private class CompilerTodoTaskInputAdapter
    implements IDialogFieldListener {
        private CompilerTodoTaskInputAdapter() {
        }

        @Override
        public void dialogFieldChanged(DialogField field) {
            TodoTaskInputDialog.this.doValidation();
        }
    }
}

