/*
 * Decompiled with CFR 0.152.
 */
package org.pdtextensions.core.ui.codemanipulation;

import java.util.HashSet;
import java.util.List;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.IType;
import org.eclipse.php.internal.core.typeinference.PHPModelUtils;

public abstract class ElementStub {
    protected String code = null;
    protected IScriptProject scriptProject = null;
    protected String lineDelim = "\n";
    protected String name;
    protected String namespace;
    protected List<IType> interfaces;
    protected boolean generateComments;

    protected String generateInterfacesCode() {
        String code = new String();
        if (!this.interfaces.isEmpty()) {
            code = " implements";
            int size = this.interfaces.size();
            int i = 1;
            for (IType interfaceObject : this.interfaces) {
                String prefix = this.getUseNamespaceString(interfaceObject) == null ? "\\" : "";
                code = i < size ? String.valueOf(code) + " " + prefix + interfaceObject.getElementName() + "," : String.valueOf(code) + " " + prefix + interfaceObject.getElementName();
                ++i;
            }
        }
        return code;
    }

    protected String generateNamespacePart() {
        String code = new String();
        if (this.namespace != null && this.namespace.length() > 0) {
            code = "namespace " + this.namespace + ";" + this.lineDelim + this.lineDelim;
        }
        for (String useNamespace : this.getUseNamespacesList()) {
            code = String.valueOf(code) + useNamespace + this.lineDelim;
        }
        code = String.valueOf(code) + this.lineDelim;
        return code;
    }

    protected HashSet<String> getUseNamespacesList() {
        HashSet<String> namespaces = new HashSet<String>();
        if (this.interfaces != null) {
            for (IType interfaceType : this.interfaces) {
                String useString = this.getUseNamespaceString(interfaceType);
                if (useString == null) continue;
                namespaces.add(useString);
            }
        }
        return namespaces;
    }

    protected String getUseNamespaceString(IType type) {
        String namespaceString = this.extractNamespaceName(type);
        if (namespaceString != null) {
            return "use " + namespaceString + "\\" + type.getElementName() + ";";
        }
        return null;
    }

    protected String extractNamespaceName(IType type) {
        return PHPModelUtils.extractNameSpaceName((String)type.getFullyQualifiedName().replace("$", "\\"));
    }

    protected abstract void generateCode();

    public String toString() {
        if (this.code == null) {
            this.generateCode();
        }
        return this.code;
    }
}

