/*
 * Decompiled with CFR 0.152.
 */
package org.pdtextensions.core.ui.expressions;

import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.php.internal.core.documentModel.dom.ElementImplForPHP;
import org.eclipse.php.internal.core.documentModel.dom.IImplForPHP;
import org.pdtextensions.core.log.Logger;

public class NaturePropertyTester
extends PropertyTester {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        try {
            if (expectedValue == null || property == null || !"parentProjectNature".equals(property)) {
                return false;
            }
            IProject project = null;
            if (receiver instanceof IImplForPHP) {
                ElementImplForPHP phpElement = (ElementImplForPHP)receiver;
                IModelElement element = phpElement.getModelElement();
                if (element == null) {
                    return false;
                }
                project = element.getScriptProject().getProject();
            } else if (receiver instanceof ISourceModule) {
                ISourceModule source = (ISourceModule)receiver;
                project = source.getScriptProject().getProject();
            } else if (receiver instanceof IProject) {
                project = (IProject)receiver;
            } else if (receiver instanceof IAdaptable) {
                IAdaptable adaptable = (IAdaptable)receiver;
                project = ((IResource)adaptable.getAdapter(IResource.class)).getProject();
            } else if (receiver instanceof IResource) {
                project = ((IResource)receiver).getProject();
            }
            if (project == null || !project.hasNature(expectedValue.toString())) return false;
            return true;
        }
        catch (Exception e) {
            Logger.logException((Throwable)e);
        }
        return false;
    }
}

