/*
 * Decompiled with CFR 0.152.
 */
package org.pdtextensions.core;

import java.util.regex.Pattern;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.dltk.core.IModelStatus;
import org.pdtextensions.core.Messages;

public final class PHPConventions {
    private static final Pattern PATTERN_FIELD_NAME = Pattern.compile("^\\$[a-zA-Z_\\x7f-\\xff\\u0100-\\uffff][a-zA-Z0-9_\\x7f-\\xff\\u0100-\\uffff]*$");
    private static final Pattern PATTERN_LABEL = Pattern.compile("^[a-zA-Z_\\x7f-\\xff\\u0100-\\uffff][a-zA-Z0-9_\\x7f-\\xff\\u0100-\\uffff]*$");

    public static IStatus validateConstantName(String name) {
        return PHPConventions.validateIdentifier(name);
    }

    public static IStatus validateFieldName(String name) {
        return PHPConventions.validateIdentifier(name, PATTERN_FIELD_NAME);
    }

    public static IStatus validateMethodName(String name) {
        return PHPConventions.validateIdentifier(name);
    }

    public static IStatus validateTypeName(String name) {
        return PHPConventions.validateIdentifier(name);
    }

    public static IStatus validateIdentifier(String id, Pattern pattern) {
        if (pattern.matcher(id).matches()) {
            return IModelStatus.VERIFIED_OK;
        }
        return new Status(4, "org.pdtextensions.core", -1, Messages.bind((String)Messages.Convention_illegalIdentifier, (Object)id), null);
    }

    public static IStatus validateIdentifier(String id) {
        return PHPConventions.validateIdentifier(id, PATTERN_LABEL);
    }
}

