/*
 * Decompiled with CFR 0.152.
 */
package org.pdtextensions.core;

import java.io.IOException;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.php.core.ast.nodes.Bindings;
import org.eclipse.php.core.ast.nodes.IMethodBinding;
import org.eclipse.php.core.ast.nodes.MethodDeclaration;
import org.eclipse.php.core.ast.nodes.Program;
import org.eclipse.php.core.ast.visitor.AbstractVisitor;
import org.eclipse.php.core.ast.visitor.Visitor;
import org.eclipse.php.ui.editor.SharedASTProvider;

public class PHPMethod {
    private IMethod method;

    public PHPMethod(IMethod method) {
        Assert.isNotNull((Object)method);
        this.method = method;
    }

    public IMethod getFarthestOverriddenMethod() throws CoreException {
        IMethod overriddenMethod = this.getOverriddenMethod();
        if (overriddenMethod == null) {
            return this.method;
        }
        return new PHPMethod(overriddenMethod).getFarthestOverriddenMethod();
    }

    public IMethod getOverriddenMethod() throws CoreException {
        try {
            Program ast = SharedASTProvider.getAST((ISourceModule)this.method.getSourceModule(), (SharedASTProvider.WAIT_FLAG)SharedASTProvider.WAIT_YES, (IProgressMonitor)new NullProgressMonitor());
            if (ast != null) {
                OverriddenMethodFinder overriddenMethodFinder = new OverriddenMethodFinder();
                ast.accept((Visitor)overriddenMethodFinder);
                return overriddenMethodFinder.getOverriddenMethod();
            }
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.pdtextensions.core", e.getMessage(), (Throwable)e));
        }
        return null;
    }

    private class OverriddenMethodFinder
    extends AbstractVisitor {
        private IMethod overriddenMethod;

        private OverriddenMethodFinder() {
        }

        public boolean visit(MethodDeclaration node) {
            if (node.getFunction().getFunctionName().getName().equals(PHPMethod.this.method.getElementName())) {
                IMethodBinding overriddenMethodBinding;
                IMethodBinding methodBinding = node.resolveMethodBinding();
                if (methodBinding != null && (overriddenMethodBinding = Bindings.findOverriddenMethod((IMethodBinding)methodBinding, (boolean)true)) != null) {
                    this.overriddenMethod = (IMethod)overriddenMethodBinding.getPHPElement();
                }
                return false;
            }
            return true;
        }

        public IMethod getOverriddenMethod() {
            return this.overriddenMethod;
        }
    }
}

