/*
 * Decompiled with CFR 0.152.
 */
package org.pdtextensions.core;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ITypeHierarchy;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.php.internal.core.typeinference.PHPModelUtils;
import org.pdtextensions.core.util.PDTModelUtils;

public class PHPType {
    private static final String NAMESPACE_SEPARATOR = "\\";
    private IType type;

    public PHPType(IType type) {
        Assert.isNotNull((Object)type);
        this.type = type;
    }

    public boolean inResourceWithSameName() throws CoreException {
        return PDTModelUtils.inResourceWithSameName(this.type.getResource(), this.type.getElementName());
    }

    public boolean equals(IType type) {
        return this.equals(type.getTypeQualifiedName(NAMESPACE_SEPARATOR));
    }

    public boolean equals(Object obj) {
        if (obj instanceof PHPType) {
            return this.equals(((PHPType)obj).type);
        }
        return false;
    }

    public boolean equals(String typeName) {
        return this.type.getTypeQualifiedName(NAMESPACE_SEPARATOR).equals(typeName);
    }

    public boolean isInstanceOf(IType type) throws ModelException {
        return this.isInstanceOf(PHPModelUtils.getFullName((IType)type));
    }

    public boolean isInstanceOf(String typeName) throws ModelException {
        if (this.equals(typeName)) {
            return true;
        }
        ITypeHierarchy hierarchy = this.type.newSupertypeHierarchy((IProgressMonitor)new NullProgressMonitor());
        if (hierarchy == null) {
            return false;
        }
        IType[] superTypes = hierarchy.getAllSuperclasses(this.type);
        if (superTypes == null) {
            return false;
        }
        IType[] iTypeArray = superTypes;
        int n = superTypes.length;
        int n2 = 0;
        while (n2 < n) {
            IType variableSuperType = iTypeArray[n2];
            if (new PHPType(variableSuperType).equals(typeName)) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

