/*
 * Decompiled with CFR 0.152.
 */
package org.pdtextensions.core.ast.util;

import java.util.ArrayList;
import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.php.core.ast.nodes.ASTNode;
import org.pdtextensions.core.ast.util.GenericVisitor;
import org.pdtextensions.core.ast.util.SourceRangeUtil;

public class RangeNodeFinder
extends GenericVisitor {
    protected ArrayList<ASTNode> fCoveredNodes = new ArrayList();
    protected ISourceRange fSourceRange;

    public RangeNodeFinder(ISourceRange range) {
        this.setRange(range);
    }

    @Override
    protected boolean visitNode(ASTNode node) {
        if (SourceRangeUtil.covers(this.fSourceRange, node)) {
            this.fCoveredNodes.add(node);
            return false;
        }
        return true;
    }

    public void setRange(ISourceRange range) {
        Assert.isNotNull((Object)range);
        this.fSourceRange = range;
    }

    public ArrayList<ASTNode> getNodes() {
        return this.fCoveredNodes;
    }
}

