/*
 * Decompiled with CFR 0.152.
 */
package org.pdtextensions.core.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.declarations.MethodDeclaration;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.references.SimpleReference;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IScriptFolder;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.SourceParserUtil;
import org.eclipse.dltk.core.index2.search.ISearchEngine;
import org.eclipse.dltk.core.search.IDLTKSearchScope;
import org.eclipse.dltk.core.search.SearchEngine;
import org.eclipse.dltk.evaluation.types.MultiTypeType;
import org.eclipse.dltk.internal.core.util.LRUCache;
import org.eclipse.dltk.ti.types.IEvaluatedType;
import org.eclipse.php.core.compiler.PHPFlags;
import org.eclipse.php.core.compiler.ast.nodes.FullyQualifiedReference;
import org.eclipse.php.core.compiler.ast.nodes.PHPDocBlock;
import org.eclipse.php.core.compiler.ast.nodes.PHPDocTag;
import org.eclipse.php.core.compiler.ast.nodes.UsePart;
import org.eclipse.php.core.compiler.ast.visitor.PHPASTVisitor;
import org.eclipse.php.internal.core.Logger;
import org.eclipse.php.internal.core.index.IPHPDocAwareElement;
import org.eclipse.php.internal.core.model.PHPModelAccess;
import org.eclipse.php.internal.core.typeinference.PHPClassType;
import org.eclipse.php.internal.core.typeinference.PHPModelUtils;
import org.eclipse.php.internal.core.typeinference.PHPSimpleTypes;
import org.eclipse.php.internal.core.typeinference.TraitAliasObject;
import org.eclipse.php.internal.core.typeinference.TraitPrecedenceObject;
import org.eclipse.php.internal.core.typeinference.TraitUtils;
import org.eclipse.php.internal.core.typeinference.UseTrait;
import org.pdtextensions.core.util.PDTTypeInferenceUtils;

public class PDTModelUtils {
    public static final String BACK_SLASH = "\\";
    private static final Pattern ARRAY_TYPE_PATTERN = Pattern.compile("array\\[.*\\]");
    private static LRUCache typeCache = new LRUCache();
    private static List<String> builtinTypes = new ArrayList<String>(Arrays.asList("array", "static", "self", "parent"));

    public static List<IEvaluatedType> collectUseStatements(List<IType> types, boolean includeAbstract) {
        ArrayList<IEvaluatedType> statements = new ArrayList<IEvaluatedType>();
        try {
            for (IType type : types) {
                IType currentNamespace = PHPModelUtils.getCurrentNamespace((IModelElement)type);
                boolean isInterface = PHPFlags.isInterface((int)type.getFlags());
                IEvaluatedType evaluated = PDTModelUtils.getEvaluatedType(type.getElementName(), currentNamespace);
                if (!statements.contains(evaluated)) {
                    statements.add(evaluated);
                }
                IMethod[] iMethodArray = type.getMethods();
                int n = iMethodArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IMethod method = iMethodArray[n2];
                    boolean isAbstract = PHPFlags.isAbstract((int)method.getFlags());
                    if (!isInterface && isAbstract && includeAbstract) {
                        statements.addAll(PDTModelUtils.collectParameterTypes(method));
                    } else if (isInterface) {
                        statements.addAll(PDTModelUtils.collectParameterTypes(method));
                    }
                    ++n2;
                }
            }
        }
        catch (ModelException e) {
            e.printStackTrace();
        }
        return statements;
    }

    public static IMethod[] getSuperTypeHierarchyMethod(IType type, String prefix, boolean exactName, IProgressMonitor monitor) throws CoreException {
        List<IMethod> list = Arrays.asList(PHPModelUtils.getSuperTypeHierarchyMethod((IType)type, (String)prefix, (boolean)exactName, (IProgressMonitor)monitor));
        PDTModelUtils.superTypeHierarchyMethods(list, type, prefix, exactName);
        return list.toArray(new IMethod[list.size()]);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean superTypeHierarchyMethods(List<IMethod> list, IType type, String prefix, boolean exactName) {
        try {
            if (type.getSuperClasses() == null) return false;
            if (type.getSuperClasses().length == 0) {
                return false;
            }
            String[] stringArray = type.getSuperClasses();
            int n = stringArray.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                String n3 = stringArray[n2];
                if (type.getSourceModule().getType(n3) != null) {
                    IType sub = type.getSourceModule().getType(n3);
                    IMethod[] iMethodArray = sub.getMethods();
                    int n4 = iMethodArray.length;
                    int n5 = 0;
                    while (true) {
                        if (n5 >= n4) {
                            if (!PDTModelUtils.superTypeHierarchyMethods(list, sub, prefix, exactName)) break;
                            return true;
                        }
                        IMethod m = iMethodArray[n5];
                        if (!list.contains(m) && m.getElementName().equals(prefix) || !exactName && m.getElementName().startsWith(prefix)) {
                            list.add(m);
                            return true;
                        }
                        ++n5;
                    }
                }
                ++n2;
            }
        }
        catch (ModelException modelException) {
            // empty catch block
        }
        return false;
    }

    public static List<IEvaluatedType> collectParameterTypes(IMethod method) throws ModelException {
        ArrayList<IEvaluatedType> evaluated = new ArrayList<IEvaluatedType>();
        IScriptProject project = method.getScriptProject();
        if (project == null) {
            return evaluated;
        }
        IType currentNamespace = PHPModelUtils.getCurrentNamespace((IModelElement)method);
        String[] typeNames = null;
        if (method instanceof IPHPDocAwareElement) {
            typeNames = ((IPHPDocAwareElement)method).getReturnTypes();
        } else {
            LinkedList<String> returnTypeList = new LinkedList<String>();
            PHPDocBlock docBlock = PHPModelUtils.getDocBlock((IMethod)method);
            if (docBlock == null) {
                return null;
            }
            PHPDocTag[] tags = docBlock.getTags(PHPDocTag.TagKind.PARAM);
            if (tags != null && tags.length > 0) {
                PHPDocTag[] pHPDocTagArray = tags;
                int n = tags.length;
                int n2 = 0;
                while (n2 < n) {
                    PHPDocTag phpDocTag = pHPDocTagArray[n2];
                    if (phpDocTag.getTypeReferences() != null && phpDocTag.getTypeReferences().size() > 0) {
                        for (SimpleReference ref : phpDocTag.getTypeReferences()) {
                            String type = ref.getName();
                            if (type == null || !PDTModelUtils.isValidType(type, project)) continue;
                            returnTypeList.add(type);
                        }
                    }
                    ++n2;
                }
            }
            typeNames = returnTypeList.toArray(new String[returnTypeList.size()]);
        }
        if (typeNames != null) {
            String[] stringArray = typeNames;
            int n = typeNames.length;
            int n3 = 0;
            while (n3 < n) {
                String typeName = stringArray[n3];
                Matcher m = ARRAY_TYPE_PATTERN.matcher(typeName);
                if (m.find()) {
                    int offset = 0;
                    try {
                        offset = method.getSourceRange().getOffset();
                    }
                    catch (ModelException modelException) {
                        // empty catch block
                    }
                    MultiTypeType t = PDTModelUtils.getArrayType(m.group(), currentNamespace, offset);
                    String name = t.getTypeName();
                    if (!evaluated.contains(name) && name.startsWith("$")) {
                        evaluated.add((IEvaluatedType)t);
                    }
                } else {
                    IEvaluatedType type;
                    if (currentNamespace != null) {
                        String fullName;
                        Map result;
                        String prefix;
                        PHPDocBlock docBlock = PHPModelUtils.getDocBlock((IMethod)method);
                        ModuleDeclaration moduleDeclaration = SourceParserUtil.getModuleDeclaration((ISourceModule)currentNamespace.getSourceModule());
                        if (typeName.indexOf(92) > 0) {
                            prefix = typeName.substring(0, typeName.indexOf(92));
                            result = PHPModelUtils.getAliasToNSMap((String)prefix, (ModuleDeclaration)moduleDeclaration, (int)docBlock.sourceStart(), (IType)currentNamespace, (boolean)true);
                            if (result.containsKey(prefix)) {
                                fullName = ((UsePart)result.get(prefix)).getNamespace().getFullyQualifiedName();
                                typeName = typeName.replace(prefix, fullName);
                            }
                        } else if (typeName.indexOf(92) < 0 && (result = PHPModelUtils.getAliasToNSMap((String)(prefix = typeName), (ModuleDeclaration)moduleDeclaration, (int)docBlock.sourceStart(), (IType)currentNamespace, (boolean)true)).containsKey(prefix)) {
                            typeName = fullName = ((UsePart)result.get(prefix)).getNamespace().getFullyQualifiedName();
                        }
                    }
                    if ((type = PDTModelUtils.getEvaluatedType(typeName, currentNamespace)) != null && PDTModelUtils.isValidType(typeName, project) && !evaluated.contains(type.getTypeName()) && !type.getTypeName().startsWith("$")) {
                        evaluated.add(type);
                    }
                }
                ++n3;
            }
        }
        return evaluated;
    }

    public static IEvaluatedType getEvaluatedType(String typeName, IType currentNamespace) {
        IEvaluatedType type = PHPSimpleTypes.fromString((String)typeName);
        if (type == null) {
            if (typeName.indexOf(92) != -1 || currentNamespace == null) {
                type = new PHPClassType(typeName);
            } else if (currentNamespace != null) {
                type = new PHPClassType(currentNamespace.getElementName(), typeName);
            }
        }
        return type;
    }

    public static MultiTypeType getArrayType(String type, IType currentNamespace, int offset) {
        String[] typeNames;
        int beginIndex = type.indexOf("[") + 1;
        int endIndex = type.lastIndexOf("]");
        type = type.substring(beginIndex, endIndex);
        MultiTypeType arrayType = new MultiTypeType();
        Matcher m = ARRAY_TYPE_PATTERN.matcher(type);
        if (m.find()) {
            arrayType.addType((IEvaluatedType)PDTModelUtils.getArrayType(m.group(), currentNamespace, offset));
            type = m.replaceAll("");
        }
        String[] stringArray = typeNames = type.split(",");
        int n = typeNames.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            if (!"".equals(name)) {
                if (name.indexOf(92) > 0 && currentNamespace != null) {
                    ModuleDeclaration moduleDeclaration = SourceParserUtil.getModuleDeclaration((ISourceModule)currentNamespace.getSourceModule());
                    String prefix = name.substring(0, name.indexOf(92));
                    Map result = PHPModelUtils.getAliasToNSMap((String)prefix, (ModuleDeclaration)moduleDeclaration, (int)offset, (IType)currentNamespace, (boolean)true);
                    if (result.containsKey(prefix)) {
                        String fullName = ((UsePart)result.get(prefix)).getNamespace().getFullyQualifiedName();
                        name = name.replace(prefix, fullName);
                    }
                }
                arrayType.addType(PDTModelUtils.getEvaluatedType(name, currentNamespace));
            }
            ++n2;
        }
        return arrayType;
    }

    public static String getMethodSignature(MethodDeclaration method, IScriptProject project) {
        String signature = method.getName().toLowerCase();
        return signature;
    }

    public static String getMethodSignature(IMethod method) {
        try {
            String methodSignature = method.getElementName().toLowerCase();
            return methodSignature;
        }
        catch (Exception e) {
            return "";
        }
    }

    public static boolean isBuiltinType(String type) {
        return builtinTypes.contains(type);
    }

    public static boolean isValidType(String type, IScriptProject project) {
        if (builtinTypes.contains(type)) {
            return true;
        }
        String key = String.valueOf(type) + project.getElementName();
        if (typeCache.get((Object)key) != null) {
            return (Boolean)typeCache.get((Object)key);
        }
        if (type == null || "object".equals(type)) {
            return (Boolean)typeCache.put((Object)key, (Object)new Boolean(false));
        }
        IDLTKSearchScope scope = SearchEngine.createSearchScope((IModelElement)project);
        IType[] types = PHPModelAccess.getDefault().findTypes(type, ISearchEngine.MatchRule.EXACT, 0, 0, scope, (IProgressMonitor)new NullProgressMonitor());
        return (Boolean)typeCache.put((Object)key, (Object)new Boolean(types.length > 0));
    }

    public static Map<String, IMethod> getImportedMethods(IType type) {
        IMethod[] methods;
        IType trait;
        HashMap<String, IMethod> ret = new HashMap<String, IMethod>();
        UseTrait parsed = TraitUtils.parse((IType)type);
        IDLTKSearchScope scope = TraitUtils.createSearchScope((IType)type);
        HashMap<String, IType> traits = new HashMap<String, IType>();
        HashSet<String> usedMethods = new HashSet<String>();
        for (String string : parsed.getTraits()) {
            if (PDTModelUtils.findType(type.getSourceModule(), string) != null) {
                traits.put(string, PDTModelUtils.findType(type.getSourceModule(), string));
                continue;
            }
            IType[] traitTypes = PHPModelAccess.getDefault().findTraits(string, ISearchEngine.MatchRule.EXACT, 0, 0, scope, (IProgressMonitor)new NullProgressMonitor());
            if (traitTypes.length != 1) continue;
            traits.put(string, traitTypes[0]);
        }
        if (traits.size() == 0) {
            return ret;
        }
        for (TraitAliasObject traitAliasObject : parsed.getTraitAliases()) {
            trait = (IType)traits.get(traitAliasObject.traitName);
            if (trait == null) continue;
            try {
                methods = PHPModelUtils.getTypeMethod((IType)trait, (String)traitAliasObject.traitMethodName, (boolean)true);
                if (methods.length != 1) continue;
                usedMethods.add(String.valueOf(traitAliasObject.traitName) + "::" + traitAliasObject.traitMethodName);
                ret.put(traitAliasObject.newMethodName, methods[0]);
            }
            catch (ModelException e) {
                Logger.logException((Throwable)e);
            }
        }
        for (Map.Entry entry : parsed.getPrecedenceMap().entrySet()) {
            trait = (IType)traits.get(((TraitPrecedenceObject)entry.getValue()).traitName);
            if (trait == null) continue;
            try {
                methods = PHPModelUtils.getTypeMethod((IType)trait, (String)((TraitPrecedenceObject)entry.getValue()).traitMethodName, (boolean)true);
                if (methods.length != 1) continue;
                usedMethods.add(String.valueOf(((TraitPrecedenceObject)entry.getValue()).traitName) + "::" + ((TraitPrecedenceObject)entry.getValue()).traitMethodName);
                ret.put(((TraitPrecedenceObject)entry.getValue()).traitMethodName, methods[0]);
            }
            catch (ModelException e) {
                Logger.logException((Throwable)e);
            }
        }
        for (Map.Entry entry : traits.entrySet()) {
            try {
                IMethod[] methods2;
                IMethod[] iMethodArray = methods2 = PHPModelUtils.getTypeMethod((IType)((IType)entry.getValue()), (String)"", (boolean)false);
                int n = methods2.length;
                int n2 = 0;
                while (n2 < n) {
                    IMethod method = iMethodArray[n2];
                    if (!ret.containsKey(method.getElementName()) && !usedMethods.contains(String.valueOf((String)entry.getKey()) + "::" + method.getElementName())) {
                        usedMethods.add(String.valueOf((String)entry.getKey()) + "::" + method.getElementName());
                        ret.put(method.getElementName(), method);
                    }
                    ++n2;
                }
            }
            catch (ModelException e) {
                Logger.logException((Throwable)e);
            }
        }
        return ret;
    }

    public static IModelElement getSourceElement(IModelElement element, int offset, int length) throws CoreException {
        Assert.isNotNull((Object)element);
        ISourceModule sourceModule = (ISourceModule)element.getAncestor(5);
        if (sourceModule == null) {
            return null;
        }
        return PDTModelUtils.getSourceElement(sourceModule, offset, length);
    }

    public static IModelElement getSourceElement(ISourceModule sourceModule, int offset, int length) throws CoreException {
        Assert.isNotNull((Object)sourceModule);
        IModelElement[] sourceElements = sourceModule.codeSelect(offset, length);
        if (sourceElements.length > 0) {
            IType sourceType;
            if (sourceElements[0].getElementType() == 9 && ((IMethod)sourceElements[0]).isConstructor() && (sourceType = PDTModelUtils.fixInvalidSourceElement((IMethod)sourceElements[0], offset, length)) != null) {
                return sourceType;
            }
            return sourceElements[0];
        }
        return null;
    }

    private static IType fixInvalidSourceElement(IMethod sourceElement, int offset, int length) throws CoreException {
        ModuleDeclaration moduleDeclaration = SourceParserUtil.getModuleDeclaration((ISourceModule)sourceElement.getSourceModule());
        if (moduleDeclaration != null) {
            PDTModelUtils pDTModelUtils = new PDTModelUtils();
            pDTModelUtils.getClass();
            SourceTypeFinder sourceTypeFinder = pDTModelUtils.new SourceTypeFinder(sourceElement.getSourceModule(), offset, length);
            try {
                moduleDeclaration.traverse((ASTVisitor)sourceTypeFinder);
            }
            catch (Exception e) {
                throw new CoreException((IStatus)new Status(4, "org.pdtextensions.core", e.getMessage(), (Throwable)e));
            }
            return sourceTypeFinder.getSourceType();
        }
        return null;
    }

    public static IType findType(ISourceModule module, String fqn) {
        try {
            IType[] iTypeArray = module.getAllTypes();
            int n = iTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                IType t = iTypeArray[n2];
                if (PHPModelUtils.getFullName((IType)t).equals(fqn)) {
                    return t;
                }
                ++n2;
            }
        }
        catch (ModelException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static IType[] findTypes(IScriptProject project, String fqn) {
        IType type;
        IType[] types;
        HashSet<IType> list = new HashSet<IType>();
        IDLTKSearchScope searchScope = SearchEngine.createSearchScope((IModelElement)project);
        IType[] iTypeArray = types = PHPModelAccess.getDefault().findTypes(fqn, ISearchEngine.MatchRule.EXACT, 0, 0, searchScope, (IProgressMonitor)new NullProgressMonitor());
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            type = iTypeArray[n2];
            if (fqn.equals(PHPModelUtils.getFullName((IType)type))) {
                list.add(type);
            }
            ++n2;
        }
        iTypeArray = types = PHPModelAccess.getDefault().findTraits(fqn, ISearchEngine.MatchRule.EXACT, 0, 0, searchScope, (IProgressMonitor)new NullProgressMonitor());
        n = types.length;
        n2 = 0;
        while (n2 < n) {
            type = iTypeArray[n2];
            if (fqn.equals(PHPModelUtils.getFullName((IType)type))) {
                list.add(type);
            }
            ++n2;
        }
        return list.toArray(new IType[list.size()]);
    }

    public static IType[] findTypes(IScriptProject project, String fqn, boolean force) throws ModelException {
        if (!force) {
            return PDTModelUtils.findTypes(project, fqn);
        }
        HashSet<IType> list = new HashSet<IType>();
        IProjectFragment[] iProjectFragmentArray = project.getAllProjectFragments();
        int n = iProjectFragmentArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProjectFragment f = iProjectFragmentArray[n2];
            PDTModelUtils.rawSearch(list, (IModelElement)f, fqn);
            ++n2;
        }
        return list.toArray(new IType[list.size()]);
    }

    private static void rawSearch(Set<IType> list, IModelElement el, String name) throws ModelException {
        block5: {
            block6: {
                block4: {
                    if (!(el instanceof IScriptFolder)) break block4;
                    IModelElement[] iModelElementArray = ((IScriptFolder)el).getChildren();
                    int n = iModelElementArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IModelElement sub = iModelElementArray[n2];
                        PDTModelUtils.rawSearch(list, sub, name);
                        ++n2;
                    }
                    break block5;
                }
                if (!(el instanceof IProjectFragment)) break block6;
                IModelElement[] iModelElementArray = ((IProjectFragment)el).getChildren();
                int n = iModelElementArray.length;
                int n3 = 0;
                while (n3 < n) {
                    IModelElement sub = iModelElementArray[n3];
                    PDTModelUtils.rawSearch(list, sub, name);
                    ++n3;
                }
                break block5;
            }
            if (!(el instanceof ISourceModule)) break block5;
            ISourceModule mod = (ISourceModule)el;
            IType[] iTypeArray = mod.getAllTypes();
            int n = iTypeArray.length;
            int n4 = 0;
            while (n4 < n) {
                IType t = iTypeArray[n4];
                if (PHPModelUtils.getFullName((IType)t).equals(name)) {
                    list.add(t);
                }
                ++n4;
            }
        }
    }

    public static boolean inResourceWithSameName(IResource resource, String typeName) throws CoreException {
        if (resource instanceof IFile) {
            return resource.getName().substring(0, resource.getName().indexOf(resource.getFileExtension()) - 1).equals(typeName);
        }
        if (resource instanceof IFolder) {
            return resource.getName().equals(typeName.substring(typeName.lastIndexOf(BACK_SLASH) + 1));
        }
        throw new CoreException((IStatus)new Status(4, "org.pdtextensions.core", "The resource is neither a file or folder"));
    }

    private class SourceTypeFinder
    extends PHPASTVisitor {
        private ISourceModule sourceModule;
        private int offset;
        private int length;
        private IType sourceType;

        public SourceTypeFinder(ISourceModule sourceModule, int offset, int length) {
            this.sourceModule = sourceModule;
            this.offset = offset;
            this.length = length;
        }

        public boolean visit(FullyQualifiedReference s) throws Exception {
            IType[] sourceTypes;
            if (s.sourceStart() <= this.offset && s.sourceEnd() >= this.offset + this.length && (sourceTypes = PDTTypeInferenceUtils.getTypes((ASTNode)s, this.sourceModule)).length > 0) {
                this.sourceType = sourceTypes[0];
                return false;
            }
            return true;
        }

        public IType getSourceType() {
            return this.sourceType;
        }
    }
}

